/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionCellRenderer;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.EmptyIcon;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import si.pylo.java.Code;
import si.pylo.java.CodeUtil;
import si.pylo.java.DOCParser;
import si.pylo.mcreator.FileIO;
import si.pylo.mcreator.MCPUtil;
import si.pylo.mcreator.MainUI;
import si.pylo.mcreator.OutlineGenerator;
import si.pylo.mcreator.ProgressMonitor;
import si.pylo.mcreator.ReplaceDialog;
import si.pylo.mcreator.SearchDialog;

public class CodeView
extends JFrame {
    private static final long serialVersionUID = 1L;
    JButton nazaj = new JButton("Nazaj");
    JButton saveOnly = new JButton("Save file");
    JButton save = new JButton("Nazaj");
    JTabbedPane btp = new JTabbedPane();
    RSyntaxTextArea te = new RSyntaxTextArea();
    SearchDialog sed = null;
    ReplaceDialog rep = null;
    int edit = 0;
    JSplitPane spne = new JSplitPane();
    OutlineGenerator og = new OutlineGenerator();
    DefaultCompletionProvider provider = new DefaultCompletionProvider();

    public CodeView(JFrame fa, final File fs) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("./res/gui/icon.png"));
        this.getContentPane().setBackground(Color.black);
        this.setTitle("MCreator code editor - " + fs.getName());
        this.setSize(960, 600);
        this.setExtendedState(6);
        try {
            Theme theme = Theme.load((InputStream)new FileInputStream(new File("./res/gui/rsthemes/dark.xml")));
            theme.apply(this.te);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sed = new SearchDialog((RTextArea)this.te, this);
        this.rep = new ReplaceDialog((RTextArea)this.te, this);
        Properties lang = new Properties();
        try {
            lang.load(new FileInputStream("./res/data/lang/GUI_" + MainUI.lang + ".lang"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nazaj.setText(lang.getProperty("exit"));
        this.save.setText(lang.getProperty("save2"));
        final AutoCompletion ac = new AutoCompletion((CompletionProvider)this.provider);
        ac.setShowDescWindow(true);
        ac.setAutoCompleteSingleChoices(true);
        ac.setParameterAssistanceEnabled(true);
        ac.setListCellRenderer((ListCellRenderer)((Object)new CCellRenderer()));
        ac.install((JTextComponent)this.te);
        JavaParser jp = new JavaParser(this.te);
        this.te.addParser((Parser)jp);
        this.nazaj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeView.this.sed.setVisible(false);
                CodeView.this.rep.setVisible(false);
            }
        });
        this.te.setText(FileIO.readCode(fs));
        this.te.requestFocusInWindow();
        this.te.setCaretPosition(this.te.getText().indexOf("public class"));
        if (fs.getName().endsWith(".java")) {
            this.te.setSyntaxEditingStyle("text/java");
        } else if (fs.getName().endsWith(".info")) {
            this.te.setSyntaxEditingStyle("text/json");
        } else if (fs.getName().endsWith(".json")) {
            this.te.setSyntaxEditingStyle("text/json");
        } else if (fs.getName().endsWith(".xml")) {
            this.te.setSyntaxEditingStyle("text/xml");
        } else if (fs.getName().endsWith(".lang")) {
            this.te.setSyntaxEditingStyle("text/properties");
        }
        RTextScrollPane sp = new RTextScrollPane((Component)this.te);
        sp.setFoldIndicatorEnabled(true);
        sp.setIconRowHeaderEnabled(true);
        final Gutter gr = sp.getGutter();
        this.te.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent es) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                int pos;
                if (!ac.isPopupVisible() && (pos = CodeView.this.te.getCaretPosition()) > 0) {
                    if (CodeView.this.te.getText().charAt(pos - 1) == '.') {
                        String line = null;
                        try {
                            line = CodeView.this.getStringAtLine(CodeView.this.te.getLineOfOffset(pos));
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        if (!line.startsWith("import")) {
                            CodeView.this.instalCompletion(CodeView.this.getType(line.substring(0, line.length() - 1)));
                            ac.doCompletion();
                        } else if (line.startsWith("import")) {
                            CodeView.this.instalImportCompletion(line.replaceAll("import", "").trim().replaceAll("\\;", "").replaceAll("\\*", ""));
                            ac.doCompletion();
                        }
                        CodeView.this.edit = 0;
                    } else if (CodeView.this.edit == 0) {
                        CodeView.this.instalStartCompletion();
                        CodeView.this.og.setCode(CodeView.this.te.getText());
                        List list = CodeView.this.te.getParserNotices();
                        Iterator iterator = list.iterator();
                        gr.removeAllTrackingIcons();
                        for (ParserNotice element : list) {
                            System.out.println("LINE:" + element.getLine() + "_ERROR:" + element.getMessage());
                            try {
                                if (element.getLevel() == 0) {
                                    gr.addLineTrackingIcon(element.getLine(), (Icon)new ImageIcon("./res/gui/code/error.png"));
                                    continue;
                                }
                                if (element.getLevel() == 1) {
                                    gr.addLineTrackingIcon(element.getLine(), (Icon)new ImageIcon("./res/gui/code/warning.gif"));
                                    continue;
                                }
                                if (element.getLevel() != 2) continue;
                                gr.addLineTrackingIcon(element.getLine(), (Icon)new ImageIcon("./res/gui/code/inforamtion.gif"));
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                        ++CodeView.this.edit;
                    } else {
                        CodeView.this.edit = CodeView.this.edit == 1 ? 0 : ++CodeView.this.edit;
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && (e.getModifiers() & 2) != 0) {
                    CodeView.this.sed.setVisible(true);
                } else if (e.getKeyCode() == 82 && (e.getModifiers() & 2) != 0) {
                    CodeView.this.rep.setVisible(true);
                }
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = String.valueOf(MainUI.CODEBASE) + fs.getName();
                FileIO.writeCode(CodeView.this.te.getText(), new File(file));
                MCPUtil.recompile(new ProgressMonitor());
            }
        });
        this.saveOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = String.valueOf(MainUI.CODEBASE) + fs.getName();
                FileIO.writeCode(CodeView.this.te.getText(), new File(file));
            }
        });
        this.update2(this.nazaj);
        this.update2(this.save);
        this.update2(this.saveOnly);
        JToolBar gor = new JToolBar();
        gor.setBackground(MainUI.barA);
        this.add("North", gor);
        JButton bs1 = new JButton("Find");
        bs1.setIcon(new ImageIcon("./res/gui/menu/find.png"));
        bs1.setOpaque(false);
        gor.add(bs1);
        bs1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CodeView.this.sed.setVisible(true);
            }
        });
        JButton bs2 = new JButton("Replace");
        bs2.setIcon(new ImageIcon("./res/gui/menu/replace.png"));
        gor.add(bs2);
        bs2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CodeView.this.rep.setVisible(true);
            }
        });
        JButton bs3 = new JButton("Undo");
        bs3.setIcon(new ImageIcon("./res/gui/menu/undo.png"));
        gor.add(bs3);
        bs3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CodeView.this.te.undoLastAction();
            }
        });
        JButton bs4 = new JButton("Redo");
        bs4.setIcon(new ImageIcon("./res/gui/menu/redo.png"));
        gor.add(bs4);
        bs4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CodeView.this.te.redoLastAction();
            }
        });
        JButton bs44 = new JButton("Save");
        bs44.setIcon(new ImageIcon("./res/gui/menu/save.png"));
        gor.add(bs44);
        bs44.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = String.valueOf(MainUI.CODEBASE) + fs.getName();
                FileIO.writeCode(CodeView.this.te.getText(), new File(file));
            }
        });
        JButton bs45 = new JButton("Save and recompile");
        bs45.setIcon(new ImageIcon("./res/gui/menu/scompile.png"));
        gor.add(bs45);
        bs45.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = String.valueOf(MainUI.CODEBASE) + fs.getName();
                FileIO.writeCode(CodeView.this.te.getText(), new File(file));
                MCPUtil.recompile(new ProgressMonitor());
            }
        });
        bs1.setOpaque(false);
        bs2.setOpaque(false);
        bs3.setOpaque(false);
        bs4.setOpaque(false);
        bs44.setOpaque(false);
        bs45.setOpaque(false);
        bs1.setForeground(Color.white);
        bs2.setForeground(Color.white);
        bs3.setForeground(Color.white);
        bs4.setForeground(Color.white);
        bs45.setForeground(Color.white);
        bs44.setForeground(Color.white);
        this.og.setCode(this.te.getText());
        sp.setOpaque(false);
        this.spne.setRightComponent((Component)sp);
        this.spne.setLeftComponent(new JScrollPane(this.og));
        this.spne.setContinuousLayout(true);
        this.te.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                CodeView.this.og.setCode(CodeView.this.te.getText());
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.add("Center", this.spne);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.spne.setDividerLocation(320);
    }

    private JPanel p(Component component) {
        JPanel p = new JPanel(new FlowLayout(1));
        p.setOpaque(false);
        p.add(component);
        return p;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(880, 572);
        f.setVisible(true);
    }

    private void update2(final JButton bnew) {
        bnew.setForeground(Color.white);
        bnew.setOpaque(false);
        bnew.setBorder(BorderFactory.createLineBorder(Color.white, 2));
        bnew.setContentAreaFilled(false);
        bnew.setPreferredSize(new Dimension(260, 40));
        bnew.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                bnew.setOpaque(false);
                bnew.setForeground(Color.white);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                bnew.setOpaque(true);
                bnew.setForeground(Color.black);
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
    }

    private void instalImportCompletion(String type) {
        Object[] clases2;
        System.out.println(type);
        this.provider.clear();
        Object[] clases = CodeUtil.getSubpackages(type);
        if (clases != null) {
            int i = 0;
            while (i < clases.length) {
                BasicCompletion bc = new BasicCompletion((CompletionProvider)this.provider, (String)clases[i]);
                bc.setIcon((Icon)new ImageIcon("./res/gui/code/package.gif"));
                this.provider.addCompletion((Completion)bc);
                ++i;
            }
        }
        if ((clases2 = CodeUtil.getClassesInPackage(type)) != null) {
            int i = 0;
            while (i < clases2.length) {
                BasicCompletion bc = new BasicCompletion((CompletionProvider)this.provider, (String)clases2[i]);
                bc.setIcon((Icon)new ImageIcon("./res/gui/code/class.gif"));
                this.provider.addCompletion((Completion)bc);
                ++i;
            }
        }
    }

    private void instalStartCompletion() {
        this.provider.clear();
        Object[] clases = CodeUtil.getAllClasses(new Code(this.te.getText()));
        int i = 0;
        while (i < clases.length) {
            BasicCompletion bc = new BasicCompletion((CompletionProvider)this.provider, (String)clases[i]);
            bc.setIcon((Icon)new ImageIcon("./res/gui/code/class.gif"));
            this.provider.addCompletion((Completion)bc);
            ++i;
        }
    }

    private void instalCompletion(String string) {
        if (string != null) {
            this.provider.clear();
            String pck = CodeUtil.getPackage(string, new Code(this.te.getText()));
            Object[] meth = CodeUtil.getMethods(pck);
            int i = 0;
            while (i < meth.length) {
                Method method = (Method)meth[i];
                FunctionCompletion fc = new FunctionCompletion((CompletionProvider)this.provider, method.getName(), method.getReturnType().getSimpleName());
                fc.setShortDescription(DOCParser.getDesc(pck, method.getName()));
                if (fc.getShortDescription().equals("No description found.")) {
                    fc.setIcon((Icon)new ImageIcon("./res/gui/code/function.png"));
                } else {
                    fc.setIcon((Icon)new ImageIcon("./res/gui/code/functionh.png"));
                }
                ArrayList<ParameterizedCompletion.Parameter> list = new ArrayList<ParameterizedCompletion.Parameter>();
                Class<?>[] clas = method.getParameterTypes();
                if (clas.length > -1) {
                    int is = 0;
                    while (is < clas.length) {
                        list.add(new ParameterizedCompletion.Parameter((Object)clas[is].getSimpleName(), "par" + is));
                        ++is;
                    }
                }
                fc.setParams(list);
                this.provider.addCompletion((Completion)fc);
                ++i;
            }
            Object[] fild = CodeUtil.getFields(pck);
            int ix = 0;
            while (ix < fild.length) {
                Field field = (Field)fild[ix];
                VariableCompletion fc = new VariableCompletion((CompletionProvider)this.provider, field.getName(), field.getType().getName());
                this.provider.addCompletion((Completion)fc);
                ++ix;
            }
        } else {
            this.provider.clear();
            FunctionCompletion fc = new FunctionCompletion((CompletionProvider)this.provider, "No suggestions found", "");
            this.provider.addCompletion((Completion)fc);
        }
    }

    private String getStringAtLine(int line) {
        String[] lines = this.te.getText().split("\n");
        return lines[line];
    }

    private String getType(String s) {
        s = s.trim().replaceAll("\t", "");
        String[] lines = this.te.getText().split("\n");
        int i = 0;
        while (i < lines.length) {
            String type;
            String line = lines[i].trim().replaceAll("\t", "");
            if (line.contains(s) && line.contains("new") && line.contains("=") ? line.startsWith(String.valueOf(type = line.split(" ")[0]) + " " + s + " =") || line.startsWith(String.valueOf(type) + " " + s + "=") : line.contains(s) && line.contains("=") && (line.startsWith(String.valueOf(type = line.split(" ")[0]) + " " + s + " =") || line.startsWith(String.valueOf(type) + " " + s + "="))) {
                return type;
            }
            ++i;
        }
        return null;
    }

    class CCellRenderer
    extends CompletionCellRenderer {
        private static final long serialVersionUID = 1L;
        private Icon variableIcon;
        private Icon functionIcon;
        private Icon emptyIcon = new EmptyIcon(16);

        public CCellRenderer() {
            this.variableIcon = this.getIcon("var.png");
            this.functionIcon = this.getIcon("function.png");
        }

        protected void prepareForOtherCompletion(JList list, Completion c, int index, boolean selected, boolean hasFocus) {
            super.prepareForOtherCompletion(list, c, index, selected, hasFocus);
            if (c instanceof BasicCompletion) {
                BasicCompletion cp = (BasicCompletion)c;
                this.setIcon(cp.getIcon());
            }
        }

        protected void prepareForVariableCompletion(JList list, VariableCompletion vc, int index, boolean selected, boolean hasFocus) {
            super.prepareForVariableCompletion(list, vc, index, selected, hasFocus);
            this.setIcon(this.variableIcon);
        }

        protected void prepareForFunctionCompletion(JList list, FunctionCompletion fc, int index, boolean selected, boolean hasFocus) {
            super.prepareForFunctionCompletion(list, fc, index, selected, hasFocus);
            this.setIcon(fc.getIcon());
        }
    }
}

