/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import si.pylo.mcreator.MainUI;
import si.pylo.mcreator.OS;

public class FileIO {
    static File prevDir = new File(System.getProperty("user.home"));

    static void unzip(String strZipFile, String dst) {
        try {
            File fSourceZip = new File(strZipFile);
            String zipPath = dst;
            ZipFile zipFile = new ZipFile(fSourceZip);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                if (destinationFilePath.isFile()) {
                    destinationFilePath.delete();
                }
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("IOError :" + ioe);
        }
    }

    public static String exec(String cmd) throws IOException, InterruptedException {
        String line;
        ProcessBuilder ps = new ProcessBuilder("cmd", "/c", cmd);
        Process pr = ps.start();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line = stdInput.readLine()) != null) {
            System.out.println(line);
            sb.append(String.valueOf(line) + "\n");
        }
        pr.waitFor();
        stdInput.close();
        return sb.toString();
    }

    public static String readCode(File f) {
        StringBuffer sb = new StringBuffer();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(f);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                sb.append(String.valueOf(strLine) + "\n");
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return sb.toString();
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                FileIO.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static String readWebpage(String s) {
        StringBuffer sb = new StringBuffer();
        if (MainUI.isInternet) {
            try {
                String inputLine;
                URL google = new URL(s);
                URLConnection yc = google.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                in.close();
            }
            catch (MalformedURLException e) {
                sb.append("<html><b>Could not connect to the Pylo server.<br>Some functions might not work!</b>");
            }
            catch (FileNotFoundException e) {
                sb.append("<html><b>Could not connect to the Pylo server.<br>Some functions might not work!</b>");
            }
            catch (IOException e) {
                sb.append("<html><b>Could not connect to the Pylo server.<br>Some functions might not work!</b>");
            }
        } else {
            sb.append("<html><b>Could not connect to the Pylo server.<br>Some functions might not work!</b>");
        }
        return sb.toString();
    }

    public static String readWebpage2(String s) {
        StringBuffer sb = new StringBuffer();
        if (MainUI.isInternet) {
            try {
                String inputLine;
                URL google = new URL(s);
                URLConnection yc = google.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                in.close();
            }
            catch (MalformedURLException e) {
                sb.append("Could not connect to the Pylo server");
            }
            catch (FileNotFoundException e) {
                sb.append("Could not connect to the Pylo server");
            }
            catch (IOException e) {
                sb.append("Could not connect to the Pylo server");
            }
        } else {
            sb.append("Could not connect to the Pylo server");
        }
        return sb.toString();
    }

    public static String readWebpage3(String s) {
        StringBuffer sb = new StringBuffer();
        if (MainUI.isInternet) {
            try {
                String inputLine;
                URL google = new URL(s);
                URLConnection yc = google.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                in.close();
            }
            catch (MalformedURLException e) {
                return "";
            }
            catch (FileNotFoundException e) {
                return "";
            }
            catch (IOException e) {
                return "";
            }
        } else {
            return "";
        }
        return sb.toString();
    }

    public static void readToStringBuffer(File f, StringBuffer sb) {
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(f);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                sb.append(String.valueOf(strLine) + "\n");
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void writeCode(String c, File f) {
        try {
            FileWriter fstream = new FileWriter(f);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(c);
            out.close();
        }
        catch (Exception e) {
            System.err.println("Napaka: " + e.getMessage());
        }
    }

    public static void createZip(String outFilename, String[] filenames) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            int i = 0;
            while (i < filenames.length) {
                int len;
                FileInputStream in = new FileInputStream(filenames[i]);
                out.putNextEntry(new ZipEntry(new File(filenames[i]).getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File getOpenDialog(Window f, File op, final String[] exp) {
        File fr = new File("");
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(prevDir);
        if (!exp[0].equals("dir")) {
            fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Files " + Arrays.toString(exp);
                }

                @Override
                public boolean accept(File arg0) {
                    int i = 0;
                    while (i < exp.length) {
                        if (arg0.getName().endsWith(exp[i]) || arg0.isDirectory()) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            });
        } else {
            fc.setFileSelectionMode(1);
        }
        int returnVal = fc.showOpenDialog(f);
        if (returnVal != 0) {
            prevDir = fc.getCurrentDirectory();
            return null;
        }
        fr = fc.getSelectedFile();
        prevDir = fc.getCurrentDirectory();
        return fr;
    }

    public static File getOpenDialog(JFrame f, File op) {
        File fr = new File("");
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(prevDir);
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            fr = fc.getSelectedFile();
            prevDir = fc.getCurrentDirectory();
        } else {
            prevDir = fc.getCurrentDirectory();
        }
        return fr;
    }

    public static File getOpenDialog(JDialog f, File op, final File parent) {
        File fr = new File("");
        JFileChooser fc = new JFileChooser(parent);
        fc.setFileSelectionMode(0);
        fc.setCurrentDirectory(prevDir);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Files in folder";
            }

            @Override
            public boolean accept(File arg0) {
                String[] exp = new String[]{".png", ".jpg", ".gif", ".jpeg"};
                int i = 0;
                while (i < exp.length) {
                    if (arg0.getName().endsWith(exp[i]) && arg0.isFile()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        fc.setFileView(new FileView(){

            @Override
            public Boolean isTraversable(File f) {
                return parent.equals(f);
            }
        });
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            fr = fc.getSelectedFile();
            prevDir = fc.getCurrentDirectory();
        } else {
            prevDir = fc.getCurrentDirectory();
        }
        return fr;
    }

    public static File[] getOpenMultiDialog(JFrame f, File file) {
        File[] fr = null;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(prevDir);
        fc.setMultiSelectionEnabled(true);
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            fr = fc.getSelectedFiles();
            prevDir = fc.getCurrentDirectory();
        } else {
            prevDir = fc.getCurrentDirectory();
        }
        return fr;
    }

    public static File getSaveDialog(JFrame f, File file, final String[] exp) {
        File fr = new File("");
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(prevDir);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Files " + Arrays.toString(exp);
            }

            @Override
            public boolean accept(File arg0) {
                int i = 0;
                while (i < exp.length) {
                    if (arg0.getName().endsWith(exp[i]) || arg0.isDirectory()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        int returnVal = fc.showSaveDialog(f);
        if (returnVal != 0) {
            prevDir = fc.getCurrentDirectory();
            return null;
        }
        fr = new File(String.valueOf(fc.getSelectedFile().toString()) + exp[0]);
        prevDir = fc.getCurrentDirectory();
        return fr;
    }

    public static void recursiveCopy(File fSource, File fDest) {
        try {
            if (fSource.isDirectory()) {
                if (!fDest.exists()) {
                    fDest.mkdirs();
                }
                String[] fList = fSource.list();
                int index = 0;
                while (index < fList.length) {
                    File dest = new File(fDest, fList[index]);
                    File source = new File(fSource, fList[index]);
                    FileIO.recursiveCopy(source, dest);
                    ++index;
                }
            } else {
                int iBytesReads;
                FileInputStream fInStream = new FileInputStream(fSource);
                FileOutputStream fOutStream = new FileOutputStream(fDest);
                byte[] buffer = new byte[2048];
                while ((iBytesReads = fInStream.read(buffer)) >= 0) {
                    fOutStream.write(buffer, 0, iBytesReads);
                }
                if (fInStream != null) {
                    fInStream.close();
                }
                if (fOutStream != null) {
                    fOutStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile) throws Exception {
        File[] file = new File(srcFolder).listFiles();
        String[] files = new String[file.length];
        int i = 0;
        while (i < file.length) {
            files[i] = file[i].toString();
            ++i;
        }
        FileIO.createZip(destZipFile, files);
    }

    public static void addFilesToExistingZip(File zipFile, File[] files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(name)) {
                    notInFiles = false;
                    break;
                }
                ++n2;
            }
            if (notInFiles) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            if (name.equals("minecraft")) break;
            entry = zin.getNextEntry();
        }
        zin.close();
        int i = 0;
        while (i < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry("assets/minecraft/" + files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
            ++i;
        }
        out.close();
        tempFile.delete();
    }

    public static void copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void addFilesToExistingZip2(File zipFile, File[] files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(name)) {
                    notInFiles = false;
                    break;
                }
                ++n2;
            }
            if (notInFiles) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            if (name.equals("armor")) break;
            entry = zin.getNextEntry();
        }
        zin.close();
        int i = 0;
        while (i < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry("assets/minecraft/textures/models/armor/" + files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
            ++i;
        }
        out.close();
        tempFile.delete();
    }

    public static void addFilesToExistingZip3(File zipFile, File[] files, String type) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(name)) {
                    notInFiles = false;
                    break;
                }
                ++n2;
            }
            if (notInFiles) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            if (name.equals(type)) break;
            entry = zin.getNextEntry();
        }
        zin.close();
        int i = 0;
        while (i < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry("assets/minecraft/textures/" + type + "/" + files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
            ++i;
        }
        out.close();
        tempFile.delete();
    }

    public static void addFilesToExistingZip4(File zipFile, File[] files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(name)) {
                    notInFiles = false;
                    break;
                }
                ++n2;
            }
            if (notInFiles) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            if (name.equals("title")) break;
            entry = zin.getNextEntry();
        }
        zin.close();
        int i = 0;
        while (i < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry("assets/minecraft/textures/gui/title/" + files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
            ++i;
        }
        out.close();
        tempFile.delete();
    }

    public static void addFilesToExistingZip5(File zipFile, File[] files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(name)) {
                    notInFiles = false;
                    break;
                }
                ++n2;
            }
            if (notInFiles) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            if (name.equals("gui")) break;
            entry = zin.getNextEntry();
        }
        zin.close();
        int i = 0;
        while (i < files.length) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry("assets/minecraft/textures/gui/" + files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
            ++i;
        }
        out.close();
        tempFile.delete();
    }

    public static void upload(String string, String name) {
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FileIO.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static String relativePath(Object o, String relativePathPart) {
        if (o instanceof File && OS.getOS() == 0) {
            String path = ((File)o).getAbsolutePath();
            int loc = path.lastIndexOf(relativePathPart.replaceAll("/", "\\"));
            return path.substring(loc, path.length());
        }
        if (o instanceof File && (OS.getOS() == 1 || OS.getOS() == 2)) {
            String path = ((File)o).getAbsolutePath();
            int loc = path.lastIndexOf(relativePathPart);
            return path.substring(loc, path.length());
        }
        return null;
    }

    public static void copyDirectoryAsTextAndReplaceAll(File sourceLocation, File targetLocation, String a, String b) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                FileIO.copyDirectoryAsTextAndReplaceAll(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), a, b);
                ++i;
            }
        } else {
            String code = FileIO.readCode(sourceLocation);
            FileIO.writeCode(code.replaceAll(a, b), targetLocation);
        }
    }

    static class DirectoryRestrictedFileSystemView
    extends FileSystemView {
        private final File[] rootDirectories;

        DirectoryRestrictedFileSystemView(File rootDirectory) {
            this.rootDirectories = new File[]{rootDirectory};
        }

        DirectoryRestrictedFileSystemView(File[] rootDirectories) {
            this.rootDirectories = rootDirectories;
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            throw new UnsupportedOperationException("Unable to create directory");
        }

        @Override
        public File[] getRoots() {
            return this.rootDirectories;
        }

        @Override
        public boolean isRoot(File file) {
            File[] fileArray = this.rootDirectories;
            int n = this.rootDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File root = fileArray[n2];
                if (root.equals(file)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public File getHomeDirectory() {
            return this.rootDirectories[0];
        }
    }
}

