/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import si.pylo.mcreator.ImagePanel;
import si.pylo.mcreator.MCPUtil;
import si.pylo.mcreator.MainUI;
import si.pylo.mcreator.OS;
import si.pylo.mcreator.ui.MCBasicScrollBarUI;
import si.pylo.mcreator.ui.MCScrollPaneLayout;

public class GradleConsole
extends JPanel {
    private static final long serialVersionUID = 1L;
    static GradleConsole instance = new GradleConsole(MainUI.globalMainUI);
    JTextPane pan = new JTextPane();
    StyledDocument doc = null;
    ActionListener al = null;
    JPanel rel = null;
    ImagePanel ho = null;
    boolean down = true;
    boolean anim = false;
    Process proc = null;
    boolean er2 = false;
    boolean error = false;
    Color bg = new Color(30, 30, 30);
    MainUI ref = null;
    static Color READY = new Color(113, 186, 73);
    static Color WORK = new Color(120, 120, 80);
    static Color ERR = new Color(120, 80, 80);
    static Color co2 = new Color(113, 186, 73);
    JPanel north = new JPanel(){
        private static final long serialVersionUID = 1L;

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(new Color(80, 80, 80));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(co2);
            g.fillRect(0, 0, 250, this.getHeight());
        }
    };

    public GradleConsole(MainUI f) {
        this.setLayout(new BorderLayout());
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - 610) / 2 + 610 - 70);
        this.pan.setContentType("text/html");
        this.pan.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.pan.setEditable(false);
        this.pan.setBackground(this.bg);
        this.pan.setForeground(Color.white);
        this.pan.setEditorKit(new WrapEditorKit());
        this.pan.setFont(new Font("Lucida Console", 0, 14));
        this.doc = this.pan.getStyledDocument();
        DefaultCaret caret = (DefaultCaret)this.pan.getCaret();
        caret.setUpdatePolicy(2);
        this.append("BOOTING UP GRADLE...", Color.lightGray);
        long millis = System.currentTimeMillis();
        this.ho = new ImagePanel("./res/gui/background/bottom.png");
        this.ho.setLayout(new BorderLayout());
        this.ho.setPreferredSize(new Dimension(880, 14));
        this.pan.setBorder(null);
        JScrollPane aae = new JScrollPane(this.pan, 22, 31);
        aae.setComponentZOrder(aae.getVerticalScrollBar(), 0);
        aae.setComponentZOrder(aae.getViewport(), 1);
        aae.getVerticalScrollBar().setOpaque(false);
        aae.getVerticalScrollBar().setUI(new MCBasicScrollBarUI());
        aae.setLayout(new MCScrollPaneLayout());
        aae.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 0, this.bg));
        aae.setBackground(this.bg);
        this.add("Center", aae);
        this.north.setPreferredSize(new Dimension(880, 5));
        this.add("North", this.north);
        this.append("Data loaded, MCreator gradle console ready [ver 1.007]! [boot took " + (System.currentTimeMillis() - millis) + " milliseconds]", Color.lightGray);
        this.append("RIGHT click once to copy log to the clipboard or twice to clear the log.", Color.magenta, false, true);
        if (!MainUI.isInternet) {
            this.append("MCreator was not able to connect to the internet. Gradle tasks are not going to work.", Color.yellow, false, true);
        }
        this.ho.setCursor(new Cursor(12));
        this.ho.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                GradleConsole.this.down();
            }
        });
        this.ho.addMouseMotionListener(new MouseAdapter(){
            int previousY;

            @Override
            public void mousePressed(MouseEvent e) {
                this.previousY = e.getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int y = e.getY();
                if (y < this.previousY) {
                    GradleConsole.this.up();
                } else if (y > this.previousY) {
                    GradleConsole.this.down();
                }
                this.previousY = y;
            }
        });
        this.pan.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (SwingUtilities.isRightMouseButton(arg0)) {
                    if (arg0.getClickCount() == 1) {
                        StringSelection stringSelection = new StringSelection(GradleConsole.this.pan.getText());
                        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clpbrd.setContents(stringSelection, null);
                    } else if (arg0.getClickCount() == 2) {
                        GradleConsole.this.pan.setText("");
                    }
                } else {
                    GradleConsole.this.down();
                }
            }
        });
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 2));
        bar.setBackground(Color.gray);
        JButton x = new JButton("Clear log");
        x.setMargin(new Insets(1, 1, 1, 1));
    }

    public void up() {
    }

    public void down() {
    }

    public void setActionListener(ActionListener ale) {
        this.al = ale;
    }

    public void append(String text) {
        this.append(text, Color.WHITE);
    }

    public void append(String text, Color c) {
        this.append(text, c, false);
    }

    public void append(String text, Color c, boolean a) {
        if (!text.equals("")) {
            if (!text.endsWith("\n")) {
                text = String.valueOf(text) + "\n";
            }
            SimpleAttributeSet keyWord = new SimpleAttributeSet();
            StyleConstants.setFontFamily(keyWord, "Lucida Console");
            StyleConstants.setFontSize(keyWord, 12);
            StyleConstants.setItalic(keyWord, a);
            StyleConstants.setForeground(keyWord, c);
            StyleConstants.setBackground(keyWord, this.bg);
            try {
                this.doc.insertString(this.doc.getLength(), text, keyWord);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.pan.setCaretPosition(this.pan.getDocument().getLength());
    }

    public void append(String text, Color c, boolean a, boolean b) {
        if (!text.equals("")) {
            if (!text.endsWith("\n")) {
                text = String.valueOf(text) + "\n";
            }
            SimpleAttributeSet keyWord = new SimpleAttributeSet();
            StyleConstants.setFontFamily(keyWord, "Lucida Console");
            StyleConstants.setFontSize(keyWord, 12);
            StyleConstants.setItalic(keyWord, a);
            StyleConstants.setBold(keyWord, b);
            StyleConstants.setForeground(keyWord, c);
            StyleConstants.setBackground(keyWord, this.bg);
            try {
                this.doc.insertString(this.doc.getLength(), text, keyWord);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.pan.setCaretPosition(this.pan.getDocument().getLength());
    }

    public Thread exec(final String command) {
        DefaultCaret caret = (DefaultCaret)this.pan.getCaret();
        caret.setUpdatePolicy(2);
        caret.setUpdatePolicy(2);
        Thread t = new Thread(){

            @Override
            public void run() {
                GradleConsole.this.up();
                try {
                    GradleConsole.this.append("===================================================================================================================================");
                    GradleConsole.this.append("Executing gradle command: " + command, Color.yellow);
                    co2 = WORK;
                    GradleConsole.this.north.repaint();
                    if (!MainUI.isInternet) {
                        GradleConsole.this.append("MCreator was not able to connect to the internet. Gradle tasks are not going to work.", Color.yellow, false, true);
                    }
                    final long millis = System.currentTimeMillis();
                    GradleConsole.this.proc = Runtime.getRuntime().exec(GradleConsole.getRuntimeProvider());
                    final BufferedReader stdInput = new BufferedReader(new InputStreamReader(GradleConsole.this.proc.getInputStream()));
                    final BufferedReader stdError = new BufferedReader(new InputStreamReader(GradleConsole.this.proc.getErrorStream()));
                    PrintWriter stdin = new PrintWriter(GradleConsole.this.proc.getOutputStream());
                    final StringBuffer errorbuff = new StringBuffer();
                    if (OS.getOS() == 0) {
                        stdin.println("cd forge");
                        stdin.println("SET \"JAVA_HOME=" + new File(System.getProperty("user.dir")).toString() + "\\jdk\\\"");
                        stdin.println("SET JAVA_EXE=%JAVA_HOME%\\bin\\java.exe");
                        stdin.println("SET PATH=%JAVA_HOME%\\bin\\;%PATH%");
                        stdin.println("gradlew " + command);
                    } else {
                        stdin.println("cd forge");
                        stdin.println("chmod 777 gradlew");
                        stdin.println("sudo ./gradlew " + command);
                    }
                    stdin.close();
                    Thread errr = new Thread(){

                        @Override
                        public void run() {
                            String s = null;
                            try {
                                while ((s = stdInput.readLine()) != null) {
                                    if (s.startsWith(":")) {
                                        GradleConsole.this.append(s, Color.cyan, true);
                                    } else {
                                        GradleConsole.this.append(s, Color.white);
                                    }
                                    if (!s.contains(":compileJava FAILED")) continue;
                                    (this).GradleConsole.this.error = true;
                                    (this).GradleConsole.this.er2 = true;
                                }
                                stdInput.close();
                                GradleConsole.this.append("Task completed with return code " + (this).GradleConsole.this.proc.exitValue() + " in " + (System.currentTimeMillis() - millis) + " milliseconds", Color.white, true);
                                if ((this).GradleConsole.this.proc.exitValue() == 0 && !(this).GradleConsole.this.error) {
                                    GradleConsole.this.append("Task return code check OK!", Color.green);
                                }
                                if ((this).GradleConsole.this.error) {
                                    Thread to = new Thread(){

                                        @Override
                                        public void run() {
                                            while (!((this).this).GradleConsole.this.er2) {
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (InterruptedException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            ((this).this).GradleConsole.this.er2 = false;
                                            ((this).this).GradleConsole.this.error = false;
                                            MCPUtil.showNiceErrorDialog(null, errorbuff.toString(), command);
                                        }
                                    };
                                    to.start();
                                }
                                if ((this).GradleConsole.this.proc.exitValue() == 0 && !(this).GradleConsole.this.error) {
                                    co2 = READY;
                                    (this).GradleConsole.this.north.repaint();
                                } else {
                                    co2 = ERR;
                                    (this).GradleConsole.this.north.repaint();
                                }
                                GradleConsole.this.up();
                                if ((this).GradleConsole.this.al != null) {
                                    (this).GradleConsole.this.al.actionPerformed(new ActionEvent("", 0, command));
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    errr.start();
                    Thread errr2 = new Thread(){

                        @Override
                        public void run() {
                            String s2 = null;
                            try {
                                while ((s2 = stdError.readLine()) != null) {
                                    if (s2.startsWith("Note: Some input files use or ov") || s2.startsWith("Note: Recompile with -Xlint") || s2.startsWith("warning: [options] boots") || s2.startsWith("1 warning") || s2.startsWith("Note: Some input files use unch")) continue;
                                    if (!s2.startsWith("Download attempt")) {
                                        GradleConsole.this.append(s2, Color.red.brighter().brighter().brighter().brighter());
                                    }
                                    errorbuff.append(String.valueOf(s2) + "\n");
                                }
                                stdError.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    errr2.start();
                }
                catch (IOException e) {
                    GradleConsole.this.append("FATAL: " + e.getMessage(), Color.red);
                }
            }
        };
        t.start();
        return t;
    }

    public void setInstance(MainUI ref) {
        this.ref = ref;
    }

    public void killProc() {
        if (this.proc != null) {
            this.append("== KILLED CURRENT PROCESS", Color.red);
        }
    }

    public Thread execRaw(final Object[] commands) {
        DefaultCaret caret = (DefaultCaret)this.pan.getCaret();
        caret.setUpdatePolicy(2);
        caret.setUpdatePolicy(2);
        Thread t = new Thread(){

            @Override
            public void run() {
                GradleConsole.this.up();
                try {
                    String s;
                    GradleConsole.this.append("===================================================================================================================================");
                    GradleConsole.this.append("Executing raw commands: ", Color.pink);
                    GradleConsole.this.ho.repaint("./res/gui/background/bottom2.png");
                    if (!MainUI.isInternet) {
                        GradleConsole.this.append("MCreator was not able to connect to the internet. Gradle tasks are not going to work.", Color.yellow, false, true);
                    }
                    long millis = System.currentTimeMillis();
                    GradleConsole.this.proc = Runtime.getRuntime().exec(GradleConsole.getRuntimeProvider());
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(GradleConsole.this.proc.getInputStream()));
                    BufferedReader stdError = new BufferedReader(new InputStreamReader(GradleConsole.this.proc.getErrorStream()));
                    PrintWriter stdin = new PrintWriter(GradleConsole.this.proc.getOutputStream());
                    Object[] objectArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object command = objectArray[n2];
                        stdin.println(command);
                        GradleConsole.this.append((String)command, Color.magenta, true);
                        ++n2;
                    }
                    stdin.close();
                    String s2 = null;
                    while ((s = stdInput.readLine()) != null || (s2 = stdError.readLine()) != null) {
                        if (s != null) {
                            if (s.startsWith(":")) {
                                GradleConsole.this.append(s, Color.cyan, true);
                            } else {
                                GradleConsole.this.append(s, Color.white);
                            }
                        }
                        if (s2 == null) continue;
                        GradleConsole.this.append(s2, Color.red.brighter().brighter());
                    }
                    stdInput.close();
                    stdError.close();
                    GradleConsole.this.append("Task completed with return code " + GradleConsole.this.proc.exitValue() + " in " + (System.currentTimeMillis() - millis) + " milliseconds", Color.white, true);
                    if (GradleConsole.this.proc.exitValue() == 0) {
                        GradleConsole.this.append("Task return code check OK!", Color.green);
                    }
                    GradleConsole.this.ho.repaint("./res/gui/background/bottom.png");
                    GradleConsole.this.up();
                }
                catch (IOException e) {
                    GradleConsole.this.append("FATAL: " + e.getMessage(), Color.red);
                }
            }
        };
        t.start();
        return t;
    }

    public static String getRuntimeProvider() {
        if (OS.getOS() == 0) {
            return "cmd";
        }
        return "bash";
    }

    public static void main(String[] args) {
        System.out.println(new File(System.getProperty("user.dir")).toString());
    }

    public Thread execRecompile() {
        return this.exec("build");
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    class WrapEditorKit
    extends StyledEditorKit {
        private static final long serialVersionUID = 1L;
        ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }
}

