/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.LookupOp;
import java.awt.image.PixelGrabber;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import si.pylo.mcreator.AnimationGUI;

public class ImageUtils
extends ImageIcon {
    private static final long serialVersionUID = 1L;
    Image image = null;
    int tileSize;
    int tile = 0;

    public ImageUtils(Image im, int tileSize, int tile) {
        this.image = im;
        this.tileSize = tileSize;
        this.tile = tile;
        this.doIconing();
    }

    public static ImageIcon drawOver(ImageIcon i, ImageIcon wh) {
        Image original = i.getImage();
        Image over = wh.getImage();
        int x = original.getWidth(null);
        int y = original.getHeight(null);
        BufferedImage resizedImage = new BufferedImage(x, y, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(original, 0, 0, x, y, null);
        g.drawImage(over, 0, 0, x, y, null);
        g.dispose();
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(resizedImage.getSource()));
    }

    public static Image darken(Image im, int level) {
        BufferedImage bufferedImage = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(im, 0, 0, null);
        g.dispose();
        RescaleOp op = new RescaleOp((float)level / 100.0f, 0.0f, null);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static ImageIcon makeAnimationIcon(int stevilo, DefaultListModel<AnimationGUI.AnimationFrame> timelinevector, int size) {
        int x = size;
        int y = size * stevilo;
        BufferedImage resizedImage = new BufferedImage(x, y, 2);
        Graphics2D g = resizedImage.createGraphics();
        int i = 0;
        while (i < timelinevector.getSize()) {
            g.drawImage(Toolkit.getDefaultToolkit().getImage(timelinevector.get((int)i).slika.getAbsolutePath()), 0, i * size, size, size, new JLabel());
            ++i;
        }
        g.dispose();
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(resizedImage.getSource()));
    }

    public static ImageIcon drawOverNoScale(ImageIcon i, ImageIcon wh) {
        Image original = i.getImage();
        Image over = wh.getImage();
        int x = original.getWidth(null);
        int y = original.getHeight(null);
        BufferedImage resizedImage = new BufferedImage(x, y, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(original, 0, 0, x, y, null);
        g.drawImage(over, 0, 0, over.getWidth(null), over.getHeight(null), null);
        g.dispose();
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(resizedImage.getSource()));
    }

    public static ImageIcon colorize(ImageIcon i, Color to) {
        Image original = i.getImage();
        LookupOp colorizeFilter = ImageUtils.createColorizeOp((short)to.getRed(), (short)to.getGreen(), (short)to.getBlue());
        BufferedImage targetImage = colorizeFilter.filter(ImageUtils.toBufferedImage(original), null);
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(targetImage.getSource()));
    }

    private static LookupOp createColorizeOp(short R1, short G1, short B1) {
        short[] alpha = new short[256];
        short[] red = new short[256];
        short[] green = new short[256];
        short[] blue = new short[256];
        int i = 0;
        while (i < 256) {
            alpha[i] = i;
            red[i] = (short)((R1 + i * 1) / 2);
            green[i] = (short)((G1 + i * 1) / 2);
            blue[i] = (short)((B1 + i * 1) / 2);
            i = (short)(i + 1);
        }
        short[][] data = new short[][]{red, green, blue, alpha};
        ShortLookupTable lookupTable = new ShortLookupTable(0, data);
        return new LookupOp(lookupTable, null);
    }

    private void doIconing() {
        BufferedImage off_Image = ImageUtils.toBufferedImage(this.image);
        int imX = this.tile % 16;
        int imY = this.tile / 16;
        int y = imY * 16;
        int x = imX * 16;
        int type = 2;
        this.setImage(Toolkit.getDefaultToolkit().createImage(ImageUtils.resizeImageWithHint(off_Image.getSubimage(x, y, this.tileSize, this.tileSize), type, 26, 26).getSource()));
    }

    public static Image resize(Image image, int size) {
        return Toolkit.getDefaultToolkit().createImage(ImageUtils.resizeImageWithHint(ImageUtils.toBufferedImage(image), 2, size, size).getSource());
    }

    public static Image resize(Image image, int size, int y) {
        return Toolkit.getDefaultToolkit().createImage(ImageUtils.resizeImageWithHint(ImageUtils.toBufferedImage(image), 2, size, y).getSource());
    }

    private static BufferedImage resizeImageWithHint(BufferedImage originalImage, int type, int size, int y) {
        BufferedImage resizedImage = new BufferedImage(size, y, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, size, y, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = image.getHeight(null) <= 0 ? null : gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            if (image.getHeight(null) > 0) {
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        if (cm != null) {
            return cm.hasAlpha();
        }
        return false;
    }

    public Image getTileImage() {
        BufferedImage off_Image = ImageUtils.toBufferedImage(this.image);
        int imX = this.tile % 16;
        int imY = this.tile / 16;
        int y = imY * 16;
        int x = imX * 16;
        int type = 2;
        return Toolkit.getDefaultToolkit().createImage(ImageUtils.resizeImageWithHint(off_Image.getSubimage(x, y, this.tileSize, this.tileSize), type, 26, 26).getSource());
    }

    public static ImageIcon rotate(ImageIcon ic, int radians) {
        BufferedImage image = ImageUtils.toBufferedImage(ic.getImage());
        double rotationRequired = Math.toRadians(radians);
        double locationX = image.getWidth() / 2;
        double locationY = image.getHeight() / 2;
        AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        return new ImageIcon(op.filter(image, null));
    }

    public static ImageIcon drawToTile(ImageIcon i, ImageIcon wh, int cx, int cy) {
        Image original = i.getImage();
        Image over = wh.getImage();
        int x = original.getWidth(null);
        int y = original.getHeight(null);
        BufferedImage resizedImage = new BufferedImage(x, y, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(original, 0, 0, x, y, null);
        g.drawImage(over, 16 * cx, 16 * cy, 16, 16, null);
        g.dispose();
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(resizedImage.getSource()));
    }
}

