/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import si.pylo.mcreator.MaterialHolder;

public class JMaterial
extends JComboBox {
    private static final long serialVersionUID = 1L;
    DefaultComboBoxModel model = new DefaultComboBoxModel();

    public JMaterial() {
        this.setModel(this.model);
        this.setRenderer(new ComboBoxRenderer());
        try {
            File file = new File("./res/data/material.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("material");
            int s = 0;
            while (s < nodeLst.getLength()) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() == 1) {
                    Element fstElmnt = (Element)fstNode;
                    NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("type");
                    Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
                    NodeList fstNm = fstNmElmnt.getChildNodes();
                    String name = fstNm.item(0).getNodeValue();
                    if (new File("./res/material/" + name + ".png").exists()) {
                        this.model.addElement(new MaterialHolder(String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1), new ImageIcon("./res/material/" + name + ".png")));
                    } else {
                        this.model.addElement(new MaterialHolder(String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1), new ImageIcon("./res/material/air.png")));
                    }
                }
                ++s;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JMaterial pr = new JMaterial();
        f.add(new JScrollPane(pr));
        f.setSize(400, 400);
        f.setVisible(true);
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            MaterialHolder mh = (MaterialHolder)value;
            if (mh != null) {
                this.setText(mh.s);
                this.setIcon(mh.i);
                this.setHorizontalTextPosition(4);
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }
}

