/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import si.pylo.mcreator.FileIO;
import si.pylo.mcreator.GradleConsole;
import si.pylo.mcreator.MainUI;
import si.pylo.mcreator.ModUtil;
import si.pylo.mcreator.NameTranslator;
import si.pylo.mcreator.ProgressMonitor;

public class MCPUtil {
    public static boolean bol = true;
    static boolean lo = true;

    public static void recompile(ProgressMonitor pm) {
        MCPUtil.recompile(pm, "TestEnvironmentMod", "1.0", false);
    }

    protected static void reportErrors(String string) {
        String[] lines;
        String errors = "";
        String[] stringArray = lines = string.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("mcreator_") && !line.contains("warning:")) {
                String start = line.split("\\.java\\:")[0].replaceAll("src\\\\minecraft\\\\net\\\\minecraft\\\\src\\\\mcreator_", "");
                errors = String.valueOf(errors) + "\n" + start;
                System.out.println(start);
            }
            ++n2;
        }
        FileIO.writeCode(errors, new File("./user/recompile.log"));
    }

    public static void recompile(final ProgressMonitor pm, final String a, final String b, final boolean custom) {
        if (!MainUI.isRecompiling) {
            MCPUtil.cleanOldMods();
            ModUtil.resetNames();
            ModUtil.makeModFile(a, b, custom, false);
            MainUI.setReco(true);
            GradleConsole.instance.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ModUtil.resetNames();
                    MainUI.setReco(false);
                }
            });
            GradleConsole.instance.exec("clean build");
        } else {
            JOptionPane.showMessageDialog(null, "Recompilation is still in progress in background!\nMCreator will automaticaly start recompilation after previous one is done.", "Warning", 2, null);
            Thread ta = new Thread(){

                @Override
                public void run() {
                    while (MainUI.isRecompiling) {
                        System.out.print("");
                    }
                    MCPUtil.recompile(pm, a, b, custom);
                }
            };
            ta.start();
        }
    }

    public static void startMinecraft() {
        if (!MainUI.isRecompiling) {
            MCPUtil.cleanOldMods();
            ModUtil.makeModFile("TestEnvironmentMod", "1.0", false, true);
            MainUI.setReco(true);
            GradleConsole.instance.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MainUI.setReco(false);
                }
            });
            try {
                new File("./forge/src/main/resources/assets/testenvironmentmod/lang/").mkdirs();
                if (new File("./user/lang/").isDirectory()) {
                    FileIO.copyDirectory(new File("./user/lang/"), new File("./forge/src/main/resources/assets/testenvironmentmod/lang/"));
                }
                if (new File("./user/sound/").isDirectory()) {
                    FileIO.copyDirectory(new File("./user/sound/"), new File("./forge/src/main/resources/assets/testenvironmentmod/"));
                }
                if (new File("./user/json/").isDirectory()) {
                    FileIO.copyDirectory(new File("./user/json/"), new File("./forge/src/main/resources/assets/testenvironmentmod/"));
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            GradleConsole.instance.exec("clean runClient");
        } else {
            JOptionPane.showMessageDialog(null, "Recompilation is still in progress in background!\nPlease try later!", "Warning", 2, null);
        }
    }

    public static void startMinecraftServer() {
        if (!MainUI.isRecompiling) {
            MCPUtil.cleanOldMods();
            ModUtil.makeModFile("TestEnvironmentMod", "1.0", false, true);
            GradleConsole.instance.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
            String eula = FileIO.readCode(new File("./forge/eclipse/eula.txt"));
            if (eula.contains("eula=false") && !eula.equals("")) {
                JOptionPane.showMessageDialog(null, "<html>In order to run Minecraft Server, you need to agree with the Minecraft EULA (End User License Agreement).<br>After you click OK, you will be redirected to the website of their EULA.<br><b>After you read it, go back to the MCreator to agree or disagree with the EULA.");
                try {
                    Desktop.getDesktop().browse(new URI("https://account.mojang.com/documents/minecraft_eula"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                Object[] options = new Object[]{"Yes, I agree", "No, I don't agree"};
                int n = JOptionPane.showOptionDialog(null, "<html><b><font color=red>Do you agree with the Minecraft EULA you read before on their website?", "EULA Agreement", 1, 3, null, options, options[0]);
                if (n == 0) {
                    Properties por = new Properties();
                    try {
                        por.load(new FileInputStream(new File("./forge/eclipse/eula.txt")));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    por.setProperty("eula", "true");
                    try {
                        por.store(new FileOutputStream(new File("./forge/eclipse/eula.txt")), "#Edited by MCreator - User agreed with EULA inside MCreator client");
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    GradleConsole.instance.exec("clean runServer");
                } else {
                    JOptionPane.showMessageDialog(null, "<html><b>In order to run Minecraft Server, you need to agree with the Minecraft EULA (End User License Agreement).</b><br>You can redo your action by running Minecraft Server again.");
                }
            } else {
                GradleConsole.instance.exec("clean runServer");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Recompilation is still in progress in background!\nPlease try later!", "Warning", 2, null);
        }
    }

    public static void showQuickErrorDialog(JFrame parent, String text) {
        RSyntaxTextArea textArea = new RSyntaxTextArea();
        RTextScrollPane sp = new RTextScrollPane((Component)textArea);
        textArea.setSyntaxEditingStyle("text/java");
        textArea.setFont(new Font("Sans-Serif", 0, 10));
        textArea.setEditable(false);
        textArea.setText(text);
        sp.setPreferredSize(new Dimension(610, 460));
        JOptionPane.showMessageDialog(parent, sp, "Gradle log", 0);
    }

    public static void showNiceErrorDialog(JFrame parent, String text, String oldc) {
        ArrayList<String> problematicMods = new ArrayList<String>();
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.contains(": error:") && line.contains(".java:")) {
                String phaseOne = line.split("mcreator_")[1];
                String modName = NameTranslator.translateNameReverse(phaseOne.split("\\.java")[0]);
                problematicMods.add(modName);
            }
            ++i;
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(problematicMods);
        JList<Object> textArea = new JList<Object>(hs.toArray());
        JScrollPane sp = new JScrollPane(textArea);
        sp.setPreferredSize(new Dimension(150, 100));
        JPanel list = new JPanel(new BorderLayout());
        list.add("North", new JLabel("<html><b><font color=red>Recompilation has failed because compiler found errors.<br></b></font><br>Most likely, this was caused by the last mod you made.<br><b>Edit this mod and make sure you fill all the form elements.</b><br><br>There are some other things you can do:<ul><li>If you still see this message after you do this, remove the mod or some of functionality and try again.</li><li>If you can't get rid of this message, export workspace and send it to us so we can try to help you.<br>Then remove the mod which caused the error.</li></ul><br>Click <b>Ignore errors</b> to ignore this message and fix errors on your own. Click <b>Remove problematic mods</b> <br>if you want MCreator to remove mods listed above. After MCreator will do this, last Gradle action will be reinvoked. <br>Mods that cause errors: "));
        list.add("Center", sp);
        Object[] options = new Object[]{"Ignore errors", "Remove problematic mods", "Show gradle log"};
        int n = JOptionPane.showOptionDialog(parent, list, "Porblematic mods", 1, 0, null, options, options[0]);
        if (n != 0) {
            if (n == 1) {
                for (String muname : hs) {
                    ModUtil.removeMod(muname);
                    String names = muname;
                    new File("./user/data/" + muname + ".mod").delete();
                    new File(String.valueOf(MainUI.CODEBASE) + "mcreator_" + NameTranslator.translateName(names) + ".java").delete();
                }
                MCPUtil.cleanOldMods();
                ModUtil.makeModFile("TestEnvironmentMod", "1.0", false, true);
                GradleConsole.instance.exec(oldc);
            } else if (n == 2) {
                MCPUtil.showQuickErrorDialog(parent, text);
            }
        }
    }

    public static void startClient(ProgressMonitor pm) {
        if (!MainUI.isRecompiling) {
            Vector<String> commands = new Vector<String>();
            commands.addElement("cd forge");
            commands.addElement("\"../jdk/bin/java.exe\" ");
            GradleConsole.instance.execRaw(commands.toArray());
        } else {
            JOptionPane.showMessageDialog(null, "Recompilation is still in progress in background! You need to wait until it's done and try again.", "Error", 2, null);
        }
    }

    public static void startServer(ProgressMonitor pm) {
        if (!MainUI.isRecompiling) {
            try {
                JOptionPane.showMessageDialog(null, "After boot of server you also need to start client and open MCreator's local test server.\nAlso, currently some mods (tabs, achievements, mobs, partly blocks) aren't SMP compatible so you may get errors.");
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        Process child = null;
                        try {
                            child = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "startserver.bat"});
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        BufferedReader input = new BufferedReader(new InputStreamReader(child.getErrorStream()));
                        try {
                            child.waitFor();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        StringBuffer sb = new StringBuffer();
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                sb.append(String.valueOf(line) + "\n");
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        JFrame f = new JFrame("Server output");
                        RSyntaxTextArea rs = new RSyntaxTextArea();
                        RTextScrollPane sp = new RTextScrollPane((Component)rs);
                        rs.setSyntaxEditingStyle("text/java");
                        f.setSize(540, 540);
                        f.setLayout(new GridLayout());
                        if (sb.toString().contains("!! Can not find server bins")) {
                            JOptionPane.showMessageDialog(null, "<html><b>You made mod with errors and ignored Errors found message. </b><br>You can't run test server until you fix them. <br>You can delete the mod wich caused Recompialtion errors (the mod that you made and caused error message after creation) <br>or reinstall MCreator. You can paste Error log on our forums and we will try to help you.", "Error", 0);
                        }
                        rs.setText(sb.toString().replaceAll("\"scalac\" is not found on the PATH.  Scala files will not be recompiled", ""));
                        f.add((Component)sp);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        Rectangle abounds = f.getBounds();
                        f.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
                        f.setVisible(true);
                    }
                };
                t.start();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Recompilation is still in progress in background! You need to wait until it's done and try again.", "Error", 2, null);
        }
    }

    public static boolean reobfuscate(MainUI main) {
        bol = true;
        if (!MainUI.isRecompiling) {
            try {
                Process child = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "reobfuscate.bat"});
                final BufferedReader input = new BufferedReader(new InputStreamReader(child.getErrorStream()));
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        StringBuffer sb = new StringBuffer();
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                sb.append(String.valueOf(line) + "\n");
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (sb.toString().contains("!! Can not find client bins")) {
                            JOptionPane.showMessageDialog(null, "<html><b>You made mod with errors and ignored Errors found message. </b><br>You can't export your mod until you fix them. <br>You can delete the mod wich caused Recompialtion errors (the mod that you made and caused error message after creation) <br>or reinstall MCreator. You can paste Error log on our forums and we will try to help you.", "Error", 0);
                            bol = false;
                        }
                    }
                };
                t.start();
                try {
                    child.waitFor();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Recompilation is still in progress in background!\nYou need to wait until it's done and try again. Don not export mods until recompialtion is done!\nThis will cause errors. Cancel exporting till recompilation is done.", "Error", 2, null);
            bol = false;
        }
        return bol;
    }

    public static void dcp() {
        try {
            System.out.println("Decompile");
            Process child = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "install.bat"}, null, new File("./mcp/forge/"));
            final BufferedReader input = new BufferedReader(new InputStreamReader(child.getErrorStream()));
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = input.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            child.waitFor();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static boolean minecraftExists() {
        return new File(String.valueOf(System.getenv("appdata")) + "/.minecraft/bin/").exists();
    }

    public static String getLoc() {
        return new File(".").toString();
    }

    public static void copyFile(File src, File dest) throws IOException {
        int length;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void reset() {
        Properties lang = new Properties();
        try {
            lang.load(new FileInputStream("./res/data/lang/GUI_" + MainUI.lang + ".lang"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object[] options = new Object[]{lang.getProperty("yes"), lang.getProperty("no")};
        int n = JOptionPane.showOptionDialog(null, lang.getProperty("sure3"), lang.getProperty("confirm"), 1, 3, new ImageIcon("./res/gui/icon.png"), options, options[1]);
        if (n == 0) {
            FileIO.deleteDir(new File("./forge/"));
            FileIO.writeCode("0", new File("./user/id.block"));
            new File("./user/skip.pylo").delete();
            new File("./user/user.pylo").delete();
            new File("./user/dropbox.sync").delete();
            FileIO.writeCode("", new File("./user/recompile.log"));
            FileIO.writeCode("Visit MCreators website;SP@;false;SP@;1\nMake an awesome mod;SP@;false;SP@;2", new File("./user/todo.list"));
            FileIO.writeCode("todo=true\ngradle=true", new File("./user/windows.conf"));
            FileIO.writeCode("null", new File("./user/package.name"));
            FileIO.writeCode("0", new File("./user/id.item"));
            FileIO.writeCode("", new File("./user/var.list"));
            FileIO.writeCode("0", new File("./user/id.achievement"));
            FileIO.writeCode("0", new File("./user/id.dimension"));
            FileIO.writeCode("0", new File("./user/id.biome"));
            FileIO.writeCode("0", new File("./user/id.mob"));
            FileIO.writeCode("0", new File("./user/id.gui"));
            FileIO.writeCode("yes", new File("./user/is.setup"));
            new File("./user/decomp.ile").delete();
            FileIO.writeCode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mods>\n\n\n</mods>", new File("./user/mods.xml"));
            FileIO.deleteDir(new File("./user/mods/"));
            FileIO.deleteDir(new File("./user/data/"));
            FileIO.deleteDir(new File("./user/lang/"));
            FileIO.deleteDir(new File("./user/json/"));
            FileIO.deleteDir(new File("./user/sound/"));
            FileIO.deleteDir(new File("./user/textures/"));
            FileIO.deleteDir(new File("./logs/"));
            FileIO.deleteDir(new File("./mcskin3d/"));
            FileIO.deleteDir(new File("./user/workspace"));
            FileIO.copyfile("./res/sound/sound.list", "./res/sound/sound.original");
            FileIO.copyfile("./res/sound/sound.original", "./res/sound/sound.list");
            new File("./user/mods/").mkdirs();
            new File("./user/sound/").mkdirs();
            new File("./user/workspace/").mkdirs();
            FileIO.writeCode("w2=Workspace 2\nw1=Workspace 1\nselected=wrk1.mcr\nw3=Workspace 3\nw5=Workspace 4\nw6=Workspace 5", new File("./user/workspace/workspace.settings"));
            new File("./user/mods/").mkdirs();
            JOptionPane.showMessageDialog(null, lang.getProperty("clean"), "Info", 1, new ImageIcon("./res/gui/icon.png"));
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        MCPUtil.reset();
    }

    public static boolean check() {
        return new File(String.valueOf(MCPUtil.getLoc()) + "/forge/mcp/src/minecraft/net/minecraft/src/BaseMod.java").isFile();
    }

    public static void cleanOldMods() {
        MCPUtil.cleanOldMods(true);
    }

    public static void cleanOldMods(boolean a) {
        File[] f = new File(MainUI.CODEBASE).listFiles();
        int i = 0;
        while (i < f.length) {
            if (!f[i].getName().startsWith("mcreator_") || f[i].getName().startsWith("mcreator_GlobalEvents") || f[i].getName().startsWith("mcreator_VarList")) {
                f[i].delete();
            }
            ++i;
        }
        f = new File(MainUI.CODEBASE.replaceAll(String.valueOf("mod.mcreator".replaceAll("\\.", "/")) + "/", "")).listFiles();
        i = 0;
        while (i < f.length) {
            f[i].delete();
            ++i;
        }
        if (a) {
            f = new File("./forge/src/main/resources/assets/").listFiles();
            i = 0;
            while (i < f.length) {
                if (!f[i].getName().equals("minecraft")) {
                    FileIO.deleteDir(f[i]);
                }
                ++i;
            }
        }
        try {
            if (new File("./forge/build/classes/main/").isDirectory()) {
                FileUtils.cleanDirectory((File)new File("./forge/build/classes/main/"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

