/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import si.pylo.mcreator.CodeView;
import si.pylo.mcreator.MainUI;
import si.pylo.mcreator.ModUtil;
import si.pylo.mcreator.SavedDataVector;

public class ProjectBrowser
extends JPanel {
    private static final long serialVersionUID = 1L;
    DefaultTreeModel mods = new DefaultTreeModel(null);
    JTree tree = new JTree(this.mods);

    public ProjectBrowser(final MainUI a) {
        this.setLayout(new BorderLayout());
        UIManager.put("Tree.rendererFillBackground", false);
        this.tree.setOpaque(false);
        this.tree.setCellRenderer(new MyRenderer());
        this.tree.updateUI();
        JScrollPane jsp = new JScrollPane(this.tree);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        jsp.setBorder(null);
        JToolBar tools = new JToolBar();
        tools.setFloatable(false);
        tools.setBackground(new Color(40, 40, 40));
        tools.setForeground(Color.white);
        JButton ed = new JButton();
        ed.setForeground(Color.white);
        ed.setOpaque(false);
        ed.setIcon(new ImageIcon("./res/gui/menu/edit-icon.png"));
        ed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ProjectBrowser.this.tree.getLastSelectedPathComponent();
                Object sel = selectedNode.getUserObject();
                if (sel instanceof File) {
                    File file = (File)sel;
                    CodeView cv = new CodeView(a, file);
                    cv.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Sorry, but this file can not be edited!");
                }
            }
        });
        tools.add(ed);
        JButton open = new JButton();
        open.setForeground(Color.white);
        open.setOpaque(false);
        open.setIcon(new ImageIcon("./res/gui/menu/explorer-icon.png"));
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ProjectBrowser.this.tree.getLastSelectedPathComponent();
                Object sel = selectedNode.getUserObject();
                if (sel instanceof File) {
                    File file = (File)sel;
                    try {
                        Desktop.getDesktop().open(new File(file.getCanonicalPath()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Sorry, but this file can not be opened!");
                }
            }
        });
        tools.add(open);
        JButton del = new JButton(new ImageIcon("./res/gui/remove.png"));
        del.setOpaque(false);
        del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)ProjectBrowser.this.tree.getLastSelectedPathComponent();
                Object sel = selectedNode.getUserObject();
                if (sel instanceof File) {
                    int n = JOptionPane.showConfirmDialog(null, "<html>Are you sure that you want to delete selected file?<br><b>Note: deleting wrong files can destroy your workspace!", "Delete file", 0);
                    if (n == 0) {
                        File file = (File)sel;
                        file.delete();
                        ProjectBrowser.this.reloadTree();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Sorry, but this file can not be removed!");
                }
            }
        });
        tools.add(del);
        JButton ref = new JButton(new ImageIcon("./res/gui/menu/refresh-icon.png"));
        ref.setOpaque(false);
        ref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProjectBrowser.this.reloadTree();
            }
        });
        tools.add(ref);
        this.add("North", tools);
        this.setOpaque(false);
        this.add("Center", jsp);
        this.reloadTree();
    }

    public void reloadTree() {
        int i;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Current workspace");
        DefaultMutableTreeNode res = new DefaultMutableTreeNode("Resources");
        node.add(res);
        if (new File("./forge/src/main/resources/assets/").exists()) {
            File[] reso = new File("./forge/src/main/resources/assets/").listFiles();
            int i2 = 0;
            while (i2 < reso.length) {
                this.addNodes(res, reso[i2], true);
                ++i2;
            }
        }
        DefaultMutableTreeNode mod = new DefaultMutableTreeNode("Sources");
        if (new File(MainUI.CODEBASE).exists()) {
            File[] reso = new File(MainUI.CODEBASE).listFiles();
            i = 0;
            while (i < reso.length) {
                DefaultMutableTreeNode is = new DefaultMutableTreeNode(reso[i]);
                mod.add(is);
                ++i;
            }
        }
        node.add(mod);
        Object[] o = ModUtil.getModsList();
        i = 0;
        while (i < o.length) {
            ModUtil modItem = (ModUtil)o[i];
            DefaultMutableTreeNode is = new DefaultMutableTreeNode("<html>" + modItem.name + ":<small>" + modItem.type);
            SavedDataVector data = SavedDataVector.getSavedDataVector(modItem.name);
            if (data.getData("id") != null) {
                int[] ids = (int[])data.getData("id");
                int j = 0;
                while (j < 4) {
                    if (ids != null && ids[j] != 0) {
                        is.add(new DefaultMutableTreeNode("ID" + j + "=" + ids[j]));
                    }
                    ++j;
                }
                node.add(is);
            }
            ++i;
        }
        DefaultMutableTreeNode inf = new DefaultMutableTreeNode(new File("./forge/src/main/resources/mcmod.info"));
        node.add(inf);
        this.mods.setRoot(node);
    }

    private DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, File dir, boolean layer1) {
        String curPath = dir.getPath();
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(dir);
        if (curTop != null) {
            curTop.add(curDir);
        }
        Vector<String> ol = new Vector<String>();
        String[] tmp = dir.list();
        int i = 0;
        while (i < tmp.length) {
            ol.addElement(tmp[i]);
            ++i;
        }
        Collections.sort(ol, String.CASE_INSENSITIVE_ORDER);
        Vector<File> files = new Vector<File>();
        int i2 = 0;
        while (i2 < ol.size()) {
            String thisObject = (String)ol.elementAt(i2);
            String newPath = curPath.equals(".") ? thisObject : String.valueOf(curPath) + File.separator + thisObject;
            File f = new File(newPath);
            if (f.isDirectory()) {
                this.addNodes(curDir, f, false);
            } else {
                files.addElement(new File(newPath));
            }
            ++i2;
        }
        int fnum = 0;
        while (fnum < files.size()) {
            curDir.add(new DefaultMutableTreeNode(files.elementAt(fnum)));
            ++fnum;
        }
        return curDir;
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            JLabel a = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (node.getUserObject() instanceof String) {
                String tsi = (String)node.getUserObject();
                a.setText(tsi);
                if (tsi.equals("Current workspace")) {
                    this.setIcon(new ImageIcon("./res/gui/code/package.png"));
                }
                if (tsi.equals("Resources")) {
                    this.setIcon(new ImageIcon("./res/gui/code/var.png"));
                }
                if (tsi.equals("Sources")) {
                    this.setIcon(new ImageIcon("./res/gui/code/class.png"));
                }
                if (tsi.startsWith("<html>")) {
                    this.setIcon(new ImageIcon("./res/gui/code/mod.png"));
                }
                if (tsi.startsWith("ID")) {
                    this.setIcon(new ImageIcon("./res/gui/code/macro.png"));
                }
            } else if (node.getUserObject() instanceof File) {
                File fil = (File)node.getUserObject();
                a.setText(fil.getName());
                a.setIcon(FileSystemView.getFileSystemView().getSystemIcon(fil));
                if (fil.getName().equals("mcmod.info")) {
                    this.setIcon(new ImageIcon("./res/gui/code/information.png"));
                }
            }
            a.setOpaque(false);
            a.setForeground(Color.white);
            this.setOpaque(false);
            this.setFont(new Font("Arial", 0, 13));
            this.setBorderSelectionColor(Color.green);
            return a;
        }
    }
}

