/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransport;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import si.pylo.mcreator.MCreatorUser;

public class PyloAPIAuthHelper {
    public static final String METHOD_SYSTEM_CONNECT = "system.connect";
    public static final String METHOD_USER_LOGOUT = "user.logout";
    public static final String METHOD_USER_LOGIN = "user.login";
    public static final String METHOD_USER_CREATE = "user.create";
    public static final String METHOD_FILE_SAVE = "file.save";
    private final String endpointURL;
    private XmlRpcClient xmlRpcClient;
    private String cookie;

    public PyloAPIAuthHelper(String endpointURL) throws MalformedURLException {
        this.endpointURL = endpointURL;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(this.endpointURL));
        this.xmlRpcClient = new XmlRpcClient();
        this.xmlRpcClient.setConfig((XmlRpcClientConfig)config);
    }

    public void connect() throws Exception {
        try {
            Map response = (Map)this.xmlRpcClient.execute(METHOD_SYSTEM_CONNECT, new Object[0]);
            System.out.println("Connected to server using SessionID: " + response.get("sessid"));
        }
        catch (Exception x) {
            throw new Exception("cannot connect to " + this.endpointURL + ": " + x.getMessage(), x);
        }
    }

    public MCreatorUser login(String username, String password) {
        Vector<String> params = new Vector<String>();
        params.add(username);
        params.add(password);
        Map response = null;
        try {
            response = (Map)this.xmlRpcClient.execute(METHOD_USER_LOGIN, params);
        }
        catch (XmlRpcException e) {
            System.out.println(e.getMessage());
        }
        if (response != null) {
            this.cookie = response.get("session_name") + "=" + response.get("sessid");
            XmlRpcSunHttpTransportFactory factory = new XmlRpcSunHttpTransportFactory(this.xmlRpcClient){

                public XmlRpcTransport getTransport() {
                    return new XmlRpcSunHttpTransport(PyloAPIAuthHelper.this.xmlRpcClient){

                        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
                            super.initHttpHeaders(request);
                            this.setRequestHeader("Cookie", PyloAPIAuthHelper.this.cookie);
                        }
                    };
                }
            };
            this.xmlRpcClient.setTransportFactory((XmlRpcTransportFactory)factory);
            System.out.println("Login seems OK, gathering userdata");
            MCreatorUser retval = new MCreatorUser();
            Map userdata = (Map)response.get("user");
            HashMap picture = null;
            if (!(userdata.get("picture") instanceof String)) {
                picture = (HashMap)((HashMap)userdata.get("picture")).clone();
            }
            retval.name = username;
            retval.url = picture != null ? (String)picture.get("url") : "err";
            retval.mail = (String)userdata.get("mail");
            retval.uid = (String)userdata.get("uid");
            return retval;
        }
        return null;
    }

    public void logout() throws Exception {
        Vector params = new Vector();
        this.xmlRpcClient.execute(METHOD_USER_LOGOUT, params);
        System.out.println("Logout Sucessfull");
    }

    public Map createUser(String name, String pass, String email) throws XmlRpcException {
        HashMap<String, Object> account = new HashMap<String, Object>();
        account.put("name", name);
        account.put("pass", pass);
        account.put("mail", email);
        account.put("status", "1");
        account.put("notify", "1");
        account.put("field_newsletter", PyloAPIAuthHelper.prepareCheckboxValueParam("1"));
        account.put("field_accept_terms", PyloAPIAuthHelper.prepareCheckboxValueParam("1"));
        Vector<HashMap<String, Object>> params = new Vector<HashMap<String, Object>>();
        params.add(account);
        System.out.println("Creating user");
        return (Map)this.xmlRpcClient.execute(METHOD_USER_CREATE, params);
    }

    public static HashMap<String, HashMap> prepareCheckboxValueParam(String value) {
        HashMap<String, String> arr111 = new HashMap<String, String>();
        arr111.put("value", value);
        HashMap<String, HashMap<String, String>> arr11 = new HashMap<String, HashMap<String, String>>();
        arr11.put("0", arr111);
        HashMap<String, HashMap> arr1 = new HashMap<String, HashMap>();
        arr1.put("und", arr11);
        return arr1;
    }

    public MCreatorUser tryToLogin(String user, String pass) {
        String adminName = user;
        String adminPass = pass;
        try {
            System.out.println("Trying to log in with username " + user);
            this.connect();
        }
        catch (Exception e) {
            System.out.println("Login FAILED!");
            e.printStackTrace();
            return null;
        }
        MCreatorUser ret = this.login(adminName, adminPass);
        if (ret != null) {
            System.out.println("Logged in - PYLOAPI");
        } else {
            System.out.println("Login FAILED!");
        }
        return ret;
    }

    public static String getTheme(String user) {
        return "";
    }
}

