/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.jnbt.ByteArrayTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;

public class Schematic {
    JCheckBox air = new JCheckBox("Spawn air");
    JCheckBox room = new JCheckBox("Check for room of schematic");
    JComboBox cbosa2 = new JComboBox<String>(new String[]{"Ground", "Air", "Underground"});
    JSpinner sp = new JSpinner(new SpinnerNumberModel(100, 0, 1000000, 1));

    public File getOpenDialog(JFrame f, File op, final String[] exp) {
        File fr = new File("");
        JFileChooser fc = new JFileChooser();
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 3));
        pane.add(new JLabel("Schematic conversion params: "));
        pane.add(this.air);
        pane.add(this.room);
        pane.add(this.pra(new JLabel("Place to spawn: "), this.cbosa2));
        pane.add(this.pra(new JLabel("Number of structures per 1000000 chunk: "), this.sp));
        fc.setAccessory(pane);
        fc.setSelectedFile(op);
        if (!exp[0].equals("dir")) {
            fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Files " + Arrays.toString(exp);
                }

                @Override
                public boolean accept(File arg0) {
                    int i = 0;
                    while (i < exp.length) {
                        if (arg0.getName().endsWith(exp[i]) || arg0.isDirectory()) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            });
        } else {
            fc.setFileSelectionMode(1);
        }
        int returnVal = fc.showOpenDialog(f);
        if (returnVal != 0) {
            return null;
        }
        fr = fc.getSelectedFile();
        return fr;
    }

    private static Tag getChildTag(Map<String, Tag> items, String key, Class<? extends Tag> expected) {
        Tag tag = items.get(key);
        return tag;
    }

    public static String getCodeForSchematic(File f, boolean ignoreAir, boolean checkForRoom) throws IOException {
        int length;
        int height;
        StringBuffer sb = new StringBuffer();
        FileInputStream fis = new FileInputStream(f);
        NBTInputStream nbt = new NBTInputStream((InputStream)fis);
        CompoundTag backuptag = (CompoundTag)nbt.readTag();
        Map tagCollection = backuptag.getValue();
        int width = ((Short)Schematic.getChildTag(tagCollection, "Width", ShortTag.class).getValue()).shortValue();
        if (width * (height = ((Short)Schematic.getChildTag(tagCollection, "Height", ShortTag.class).getValue()).shortValue()) * (length = ((Short)Schematic.getChildTag(tagCollection, "Length", ShortTag.class).getValue()).shortValue()) > 1600) {
            JOptionPane.showMessageDialog(null, "<html><br>Schematic you try to import is larger than 1600 blocks. Importing such big schematics may result as<br>recompilation errors because java can't support such big methods (64K limit).<br>If you can code, you can fix this by splitting method in smaller ones.<br>Otherwise you have to make schematic that is smaller.");
        }
        System.out.println("Schematic importer debug: W:" + width + ", H:" + height + ", L:" + length);
        byte[] blocks = (byte[])Schematic.getChildTag(tagCollection, "Blocks", ByteArrayTag.class).getValue();
        byte[] data = (byte[])Schematic.getChildTag(tagCollection, "Data", ByteArrayTag.class).getValue();
        List entities = (List)Schematic.getChildTag(tagCollection, "Entities", ListTag.class).getValue();
        Schematic.getChildTag(tagCollection, "TileEntities", ListTag.class).getValue();
        nbt.close();
        fis.close();
        sb.append("boolean place = true;\n\n");
        if (checkForRoom) {
            sb.append("for (int y = 0; y<" + height + "; y++)\n");
            sb.append("for (int z = 0; z<" + length + "; z++)\n");
            sb.append("for (int x = 0; x<" + width + "; x++)\n");
            sb.append("if(world.getBlockState(new BlockPos(i+x,j+y+1,k+z)).getBlock()!=Blocks.air)\n");
            sb.append("place = false;\n\n");
        }
        sb.append("if(place){\n");
        int id = 0;
        int j = 0;
        while (j < height) {
            int k = 0;
            while (k < length) {
                int i = 0;
                while (i < width) {
                    int ida;
                    if (data[id] == 0) {
                        if (!ignoreAir || blocks[id] != 0) {
                            ida = blocks[id];
                            if (ida < 0) {
                                ida = 128 + (128 - Math.abs(blocks[id]));
                            }
                            sb.append("world.setBlockState(new BlockPos(i+" + i + ", j+" + j + ", k+" + k + "), Block.getBlockById(" + ida + ").getStateFromMeta(0), 3);\n");
                        }
                    } else if (!ignoreAir || blocks[id] != 0) {
                        ida = blocks[id];
                        if (ida < 0) {
                            ida = 128 + (128 - Math.abs(blocks[id]));
                        }
                        sb.append("world.setBlockState(new BlockPos(i+" + i + ", j+" + j + ", k+" + k + "), Block.getBlockById(" + ida + ").getStateFromMeta(" + data[id] + "), 3);\n");
                    }
                    ++id;
                    ++i;
                }
                ++k;
            }
            ++j;
        }
        int sta = 0;
        for (Object t : entities) {
            CompoundTag a = (CompoundTag)t;
            Map map = a.getValue();
            ListTag hel = (ListTag)map.get("Pos");
            List pos = hel.getValue();
            double i = ((DoubleTag)pos.get(0)).getValue();
            double j2 = ((DoubleTag)pos.get(1)).getValue();
            double k = ((DoubleTag)pos.get(2)).getValue();
            String mobid = ((StringTag)map.get("id")).getValue();
            sb.append("Entity sentity" + sta + "=EntityList.createEntityByName(\"" + mobid + "\",world);\n" + "if (sentity" + sta + "!=null){\n" + "sentity" + sta + ".setLocationAndAngles(i+" + i + ",j+" + j2 + ",k+" + k + ",world.rand.nextFloat()*360F,0);\n" + "world.spawnEntityInWorld(sentity" + sta + ");\n" + "}\n");
            ++sta;
        }
        sb.append("}");
        return sb.toString();
    }

    public static String getSchematicInfo(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        NBTInputStream nbt = new NBTInputStream((InputStream)fis);
        CompoundTag backuptag = (CompoundTag)nbt.readTag();
        Map tagCollection = backuptag.getValue();
        short width = (Short)Schematic.getChildTag(tagCollection, "Width", ShortTag.class).getValue();
        short height = (Short)Schematic.getChildTag(tagCollection, "Height", ShortTag.class).getValue();
        short length = (Short)Schematic.getChildTag(tagCollection, "Length", ShortTag.class).getValue();
        byte[] blocks = (byte[])Schematic.getChildTag(tagCollection, "Blocks", ByteArrayTag.class).getValue();
        Schematic.getChildTag(tagCollection, "Data", ByteArrayTag.class).getValue();
        Schematic.getChildTag(tagCollection, "Entities", ListTag.class).getValue();
        Schematic.getChildTag(tagCollection, "TileEntities", ListTag.class).getValue();
        nbt.close();
        fis.close();
        return "<html>File name: " + f.getName() + "<br>" + "Width: " + width + "<br>" + "Height: " + height + "<br>" + "Length: " + length + "<br>" + "Total block data:<b> " + blocks.length;
    }

    public static void main(String[] args) throws IOException {
        File fa = new File("test.schematic");
        System.out.println(Schematic.getSchematicInfo(fa));
        System.out.println(Schematic.getCodeForSchematic(fa, false, true));
        try {
            File f = new File("test.schematic");
            FileInputStream fis = new FileInputStream(f);
            NBTInputStream nbt = new NBTInputStream((InputStream)fis);
            CompoundTag backuptag = (CompoundTag)nbt.readTag();
            Map tagCollection = backuptag.getValue();
            short width = (Short)Schematic.getChildTag(tagCollection, "Width", ShortTag.class).getValue();
            short height = (Short)Schematic.getChildTag(tagCollection, "Height", ShortTag.class).getValue();
            short length = (Short)Schematic.getChildTag(tagCollection, "Length", ShortTag.class).getValue();
            byte[] blocks = (byte[])Schematic.getChildTag(tagCollection, "Blocks", ByteArrayTag.class).getValue();
            byte[] data = (byte[])Schematic.getChildTag(tagCollection, "Data", ByteArrayTag.class).getValue();
            List entities = (List)Schematic.getChildTag(tagCollection, "Entities", ListTag.class).getValue();
            Schematic.getChildTag(tagCollection, "TileEntities", ListTag.class).getValue();
            nbt.close();
            fis.close();
            System.out.println("Size: " + width + "x" + height + "x" + length);
            System.out.println("MCreator list start");
            System.out.println(blocks.length);
            System.out.println(data.length);
            System.out.println("===================");
            for (Object t : entities) {
                CompoundTag a = (CompoundTag)t;
                Map map = a.getValue();
                ListTag hel = (ListTag)map.get("Pos");
                List pos = hel.getValue();
                ((DoubleTag)pos.get(0)).getValue();
                ((DoubleTag)pos.get(1)).getValue();
                ((DoubleTag)pos.get(2)).getValue();
                String id = ((StringTag)map.get("id")).getValue();
                System.out.println(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel pra(Component component, Component component2) {
        JPanel p = new JPanel(new FlowLayout(1));
        p.setOpaque(false);
        p.add(component);
        p.add(component2);
        return p;
    }
}

