/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import si.pylo.mcreator.FileIO;

public class TODOWindow
extends JPanel {
    private static final long serialVersionUID = 1L;
    DefaultListModel<Task> lmodel = new DefaultListModel();
    JList<Task> list = new JList<Task>(this.lmodel);

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TODOWindow(JFrame f) {
        super(new BorderLayout());
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBackground(new Color(40, 40, 40));
        JButton bt = new JButton();
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(null, "Enther the name of the task:\n", "TODO list task name", -1);
                Object[] options = new Object[]{"LOW", "NORMAL", "HIGH"};
                int n = JOptionPane.showOptionDialog(null, "Please select task priority:", "Task priority", 0, 3, null, options, options[1]);
                Task t = new Task();
                t.name = s;
                t.priority = n;
                t.complete = false;
                TODOWindow.this.lmodel.addElement(t);
                TODOWindow.this.saveTodo();
            }
        });
        bt.setOpaque(false);
        bt.setIcon(new ImageIcon("./res/gui/add.png"));
        bt.setForeground(Color.white);
        bar.add(bt);
        JButton bt2 = new JButton();
        bt2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Task task = TODOWindow.this.list.getSelectedValue();
                if (task != null) {
                    task.complete = true;
                    TODOWindow.this.repaint();
                }
                TODOWindow.this.saveTodo();
            }
        });
        bt2.setOpaque(false);
        bt2.setIcon(new ImageIcon("./res/gui/complete.png"));
        bt2.setForeground(Color.white);
        bar.add(bt2);
        JButton bt3 = new JButton();
        bt3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Task task = TODOWindow.this.list.getSelectedValue();
                TODOWindow.this.lmodel.removeElement(task);
                TODOWindow.this.saveTodo();
            }
        });
        bt3.setOpaque(false);
        bt3.setIcon(new ImageIcon("./res/gui/remove.png"));
        bt3.setForeground(Color.white);
        bar.add(bt3);
        this.add("North", bar);
        this.list.setCellRenderer(new Render());
        String[] lines = FileIO.readCode(new File("./user/todo.list")).trim().split("\n");
        int i = 0;
        while (i < lines.length) {
            String[] data = lines[i].split(";SP@;");
            if (data.length == 3) {
                Task todo = new Task();
                todo.name = data[0];
                todo.complete = Boolean.parseBoolean(data[1]);
                todo.priority = Integer.parseInt(data[2]);
                this.lmodel.addElement(todo);
            }
            ++i;
        }
        this.list.setOpaque(false);
        JScrollPane spo = new JScrollPane(this.list);
        spo.setHorizontalScrollBarPolicy(31);
        spo.setOpaque(false);
        spo.getViewport().setOpaque(false);
        this.add("Center", spo);
        this.setOpaque(false);
    }

    public void saveTodo() {
        Object[] pbj = this.lmodel.toArray();
        String lines = "";
        int i = 0;
        while (i < pbj.length) {
            Task task = (Task)pbj[i];
            lines = String.valueOf(lines) + task.name + ";SP@;" + task.complete + ";SP@;" + task.priority + ";SP@;\n";
            ++i;
        }
        FileIO.writeCode(lines, new File("./user/todo.list"));
    }

    class Render
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        Render() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Task ma = (Task)value;
            if (isSelected) {
                this.setForeground(Color.black);
                this.setOpaque(true);
            } else {
                this.setForeground(Color.white);
                this.setOpaque(false);
            }
            this.setText("<html><div style=\"width: 140px\"><font size=5>" + ma.name + "</font><br> Priority: " + Task.Priority.stringize(ma.priority) + ", Status: " + (!ma.complete ? "<font color=red>TODO!" : "<font color=green>COMPLETE") + "</font><hr>");
            this.setIcon(new ImageIcon("./res/gui/priority_" + Task.Priority.stringize(ma.priority) + ".png"));
            return this;
        }
    }

    public static class Task {
        String name;
        boolean complete = true;
        int priority = 1;

        public static class Priority {
            public static final int LOW = 0;
            public static final int NORMAL = 1;
            public static final int HIGH = 2;

            public static String stringize(int i) {
                if (i == 0) {
                    return "LOW";
                }
                if (i == 1) {
                    return "NORMAL";
                }
                if (i == 2) {
                    return "HIGH";
                }
                return "UNKNOWN";
            }
        }
    }
}

