/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import si.pylo.mcreator.VariableListManager;

public class VariableListView
extends JPanel {
    private static final long serialVersionUID = 1L;
    JButton nazaj = new JButton("Exit variable editor");
    DefaultListModel<VariableListManager.Variable> dml = new DefaultListModel();
    JList<VariableListManager.Variable> list = new JList<VariableListManager.Variable>(this.dml);

    public VariableListView(final JFrame f) {
        this.setLayout(new BorderLayout());
        JPanel toppan = new JPanel();
        toppan.setOpaque(false);
        JButton addVar = new JButton("Add new variable");
        JButton remVar = new JButton("Remove selected variable");
        remVar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableListView.this.dml.removeElement(VariableListView.this.list.getSelectedValue());
                VariableListManager.writeVariables(VariableListView.this.dml.toArray());
            }
        });
        addVar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GridLayout glo = new GridLayout(3, 2);
                glo.setHgap(10);
                glo.setVgap(10);
                final JPanel params = new JPanel(glo);
                final JComboBox<String> cobo = new JComboBox<String>(new String[]{"Number", "Logic", "String"});
                final JTextField fo = new JTextField(25);
                fo.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        if (!Character.isLetter(e.getKeyChar())) {
                            e.consume();
                            UIManager.getLookAndFeel().provideErrorFeedback(fo);
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }
                });
                final JTextField string = new JTextField(18);
                final JSpinner number = new JSpinner(new SpinnerNumberModel(1, -1000000000, 1000000000, 1));
                final JComboBox<String> logic = new JComboBox<String>(new String[]{"true", "false"});
                final JPanel initvh = new JPanel();
                params.add(new JLabel("<html>Variable type:  <br><small>See Wiki for more info"));
                params.add(cobo);
                params.add(new JLabel("<html>Name:  <br><small>EN alphabet chars only!<br>Names musn't duplicate."));
                params.add(fo);
                params.add(new JLabel("Initial value:  "));
                params.add(initvh);
                initvh.add(number);
                cobo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        if (cobo.getSelectedItem().equals("Number")) {
                            initvh.removeAll();
                            initvh.add(number);
                        }
                        if (cobo.getSelectedItem().equals("Logic")) {
                            initvh.removeAll();
                            initvh.add(logic);
                        }
                        if (cobo.getSelectedItem().equals("String")) {
                            initvh.removeAll();
                            initvh.add(string);
                        }
                        SwingUtilities.updateComponentTreeUI(params);
                    }
                });
                Object[] options = new Object[]{"Add", "Cancel"};
                int n = JOptionPane.showOptionDialog(f, VariableListView.this.p(params), "Add variable", 1, 3, null, options, options[0]);
                if (n == 0) {
                    VariableListManager.Variable var;
                    String name;
                    String val;
                    if (cobo.getSelectedItem().equals("Number")) {
                        val = number.getValue().toString();
                        name = fo.getText();
                        var = new VariableListManager.Variable();
                        var.name = name;
                        var.val = val;
                        var.type = "Number";
                        VariableListView.this.dml.addElement(var);
                    }
                    if (cobo.getSelectedItem().equals("Logic")) {
                        val = (String)logic.getSelectedItem();
                        name = fo.getText();
                        var = new VariableListManager.Variable();
                        var.name = name;
                        var.val = val;
                        var.type = "Logic";
                        VariableListView.this.dml.addElement(var);
                    }
                    if (cobo.getSelectedItem().equals("String")) {
                        val = string.getText();
                        name = fo.getText();
                        var = new VariableListManager.Variable();
                        var.name = name;
                        var.val = val;
                        var.type = "String";
                        VariableListView.this.dml.addElement(var);
                    }
                    VariableListManager.writeVariables(VariableListView.this.dml.toArray());
                }
            }
        });
        this.update2(addVar);
        this.update2(remVar);
        toppan.add(addVar);
        toppan.add(remVar);
        this.add("North", toppan);
        this.list.setOpaque(false);
        this.list.setCellRenderer(new Render());
        Vector<VariableListManager.Variable> vars = VariableListManager.readVariables();
        for (VariableListManager.Variable var : vars) {
            this.dml.addElement(var);
        }
        JScrollPane sp = new JScrollPane(this.list);
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        sp.setPreferredSize(new Dimension(905, 430));
        sp.setVerticalScrollBarPolicy(22);
        sp.setBorder(BorderFactory.createLineBorder(Color.white, 1));
        this.add("Center", this.p(sp));
        this.update2(this.nazaj);
        this.add("South", this.p(this.nazaj));
        this.setOpaque(false);
    }

    public void updateAll() {
        this.dml.removeAllElements();
        Vector<VariableListManager.Variable> vars = VariableListManager.readVariables();
        for (VariableListManager.Variable var : vars) {
            this.dml.addElement(var);
        }
        this.list.clearSelection();
    }

    private JPanel p(Component component) {
        JPanel p = new JPanel(new FlowLayout(1));
        p.setOpaque(false);
        p.add(component);
        return p;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(880, 540);
        f.setVisible(true);
    }

    private void update2(final JButton bnew) {
        bnew.setForeground(Color.white);
        bnew.setOpaque(false);
        bnew.setBorder(BorderFactory.createLineBorder(Color.white, 2));
        bnew.setContentAreaFilled(false);
        bnew.setPreferredSize(new Dimension(310, 40));
        bnew.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                bnew.setOpaque(false);
                bnew.setForeground(Color.white);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                bnew.setOpaque(true);
                bnew.setForeground(Color.black);
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
    }

    class Render
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        Render() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VariableListManager.Variable ma = (VariableListManager.Variable)value;
            if (isSelected) {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
                this.setOpaque(true);
            } else {
                this.setForeground(Color.white);
                this.setOpaque(false);
            }
            this.setFont(new Font("Arial", 0, 18));
            this.setIcon(new ImageIcon("./res/gui/variable/" + ma.type + ".png"));
            this.setText(String.valueOf(ma.name) + " = " + ma.val);
            return this;
        }
    }
}

