/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import org.fuin.utils4j.Utils4J;
import si.pylo.mcreator.Block;
import si.pylo.mcreator.FileIO;
import si.pylo.mcreator.MCPUtil;
import si.pylo.mcreator.MainUI;
import si.pylo.mcreator.ModUtil;
import si.pylo.mcreator.NewGUI;
import si.pylo.mcreator.ProcessUnit;
import si.pylo.mcreator.ProgressDialog;
import si.pylo.mcreator.ProgressMonitor;
import si.pylo.mcreator.TileDialog;
import si.pylo.mcreator.WorkspaceView;

public class Workspace {
    static boolean exporting = false;

    public static void exportMCR(final File where, final JFrame main) {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (exporting) {
                }
                exporting = true;
                ProgressDialog dial = new ProgressDialog((Window)main, "Workspace export");
                new File("./tempexport").mkdirs();
                ProcessUnit p1 = new ProcessUnit("Creating tmp directory");
                dial.addProgress(p1);
                p1.ok();
                dial.refreshDisplay();
                new File("./tempexport/user").mkdirs();
                ProcessUnit p2 = new ProcessUnit("Cloning user specific data");
                dial.addProgress(p2);
                try {
                    FileIO.copyDirectory(new File("user"), new File("./tempexport/user"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                new File("./tempexport/user/user.pylo").delete();
                new File("./tempexport/user/skip.pylo").delete();
                new File("./tempexport/user/mode.sel").delete();
                new File("./tempexport/user/windows.conf").delete();
                new File("./tempexport/user/todo.list").delete();
                FileIO.deleteDir(new File("./tempexport/user/workspace/"));
                p2.ok();
                dial.refreshDisplay();
                ProcessUnit p3 = new ProcessUnit("Cloning forge workspace");
                dial.addProgress(p3);
                new File("./tempexport/forge/src/main").mkdirs();
                try {
                    FileIO.copyDirectory(new File("./forge/src/main"), new File("./tempexport/forge/src/main"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                p3.ok();
                dial.refreshDisplay();
                ProcessUnit p4 = new ProcessUnit("Compressing workspace");
                dial.addProgress(p4);
                try {
                    Utils4J.zipDir((File)new File("./tempexport"), (String)"", (File)where);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                p4.ok();
                dial.refreshDisplay();
                ProcessUnit p5 = new ProcessUnit("Removing tmp directory");
                dial.addProgress(p5);
                FileIO.deleteDir(new File("./tempexport"));
                p5.ok();
                dial.refreshDisplay();
                dial.hideAll();
                exporting = false;
            }
        };
        t.start();
    }

    public static void importMCR(final File what, final JFrame f, final Block[] blocks, final TileDialog[] td, final TileDialog[] td2, final WorkspaceView mov) {
        Thread t = new Thread(){

            @Override
            public void run() {
                File[] files;
                while (exporting) {
                }
                ProgressDialog dial = new ProgressDialog((Window)f, "Workspace import");
                ProcessUnit p1 = new ProcessUnit("Removing old sources");
                dial.addProgress(p1);
                p1.ok();
                dial.refreshDisplay();
                File fo = new File(MainUI.CODEBASE);
                File[] fileArray = files = fo.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File a = fileArray[n2];
                    a.delete();
                    ++n2;
                }
                ProcessUnit p2 = new ProcessUnit("Extracting workspace");
                dial.addProgress(p2);
                FileIO.unzip(what.toString(), ".");
                p2.ok();
                dial.refreshDisplay();
                ProcessUnit p3 = new ProcessUnit("Fixing textures");
                dial.addProgress(p3);
                p3.ok();
                dial.refreshDisplay();
                ProcessUnit p4 = new ProcessUnit("Loading mods");
                dial.addProgress(p4);
                Object[] mods = ModUtil.getModsList();
                float max = mods.length;
                System.out.println("Mods to load: " + max);
                mov.dml.removeAllElements();
                int val = 0;
                Object[] objectArray = mods;
                int n3 = mods.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object tmp = objectArray[n4];
                    ++val;
                    ModUtil mod = (ModUtil)tmp;
                    NewGUI gui = NewGUI.getNewGUIInstanceBasedOnModTypeStringPassedAsTheArgument(f, blocks, mod.type, td, td2);
                    gui.openInEditingMode(mod.name);
                    gui.recompile = false;
                    gui.editingMode = true;
                    gui.koncaj();
                    p4.percent = (int)((float)val / max * 100.0f);
                    dial.refreshDisplay();
                    ++n4;
                }
                mov.updateMods();
                p4.ok();
                dial.refreshDisplay();
                ProcessUnit p5 = new ProcessUnit("Recompiling");
                dial.addProgress(p5);
                MCPUtil.recompile(new ProgressMonitor());
                p5.ok();
                dial.refreshDisplay();
                dial.hideAll();
            }
        };
        t.start();
    }

    public static void importLinkseyi(File what, JFrame f, Block[] blocks, TileDialog[] td, TileDialog[] td2, WorkspaceView mov) {
        Workspace.parseLinkseyi(FileIO.readCode(what));
    }

    public static void parseLinkseyi(String data) {
        String[] lines;
        String[] stringArray = lines = data.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().toLowerCase().equals("block:")) {
                System.out.println("block found!");
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
    }

    public static void importMCRAndMakeOne(File file, JFrame f, Block[] blocks, TileDialog[] td, TileDialog[] td2, WorkspaceView mv) {
        mv.ask = false;
        mv.rem3.doClick();
        mv.ask = true;
        Workspace.exportMCR(file, f);
    }

    public static void cleanup(File file, JFrame f, Block[] blocks, TileDialog[] td, TileDialog[] td2, WorkspaceView mv) {
        mv.ask = false;
        mv.rem3.doClick();
        mv.ask = true;
    }
}

