/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator.imageeditor;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class MImageEditor
extends JComponent {
    private static final long serialVersionUID = 1L;
    public Color transparent1 = Color.LIGHT_GRAY;
    public Color transparent2 = Color.DARK_GRAY;
    public Color[][] chroma;
    public boolean[][] rubberp;
    public Color[][] prechroma;
    public Color fill = Color.BLACK;
    public Point pointone;
    public Point pointtwo;
    public Point pointone1;
    public Point pointtwo1;
    public ArrayList<Color[][]> undo = new ArrayList();
    public int mx = 0;
    public int current = 0;
    public int y;
    public int x;
    public int size = 16;
    public boolean mreza = false;

    public MImageEditor(int s) {
        this.size = s;
        this.chroma = new Color[this.size][this.size];
        this.prechroma = new Color[this.size][this.size];
        this.rubberp = new boolean[this.size][this.size];
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                this.rubberp[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public void setColors(Color color, int x, int y) {
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.chroma[x][y] = color;
            this.repaint();
        }
    }

    public void setRubberPreview(int x, int y) {
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.rubberp[x][y] = true;
        }
        this.repaint();
    }

    public void setPreviewColors(Color color, int x, int y) {
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.prechroma[x][y] = color;
        }
        this.repaint();
    }

    public void setRectFirst(Color color, int x, int y) {
        this.fill = color;
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.pointone = new Point(x, y);
        }
        this.repaint();
    }

    public void setRectSecond(int x, int y) {
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.pointtwo = new Point(x, y);
            this.fillRectangle();
        }
        this.repaint();
    }

    public void setRectFirstPreview(Color color, int x, int y) {
        this.fill = color;
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.pointone1 = new Point(x, y);
        }
        this.repaint();
    }

    public void setRectSecondPreview(int x, int y) {
        if (!(x < 0 | x > this.size - 1 | y < 0 | y > this.size - 1)) {
            this.pointtwo1 = new Point(x, y);
            this.fillRectanglePreview();
        }
        this.repaint();
    }

    public void fillRectanglePreview() {
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                if (this.pointone1.getX() >= this.pointtwo1.getX()) {
                    if (this.pointone1.getY() >= this.pointtwo1.getY() && (double)i <= this.pointone1.getX() & (double)i >= this.pointtwo1.getX() & (double)j <= this.pointone1.getY() & (double)j >= this.pointtwo1.getY()) {
                        this.prechroma[i][j] = this.fill;
                    }
                    if (this.pointone1.getY() <= this.pointtwo1.getY() && (double)i <= this.pointone1.getX() & (double)i >= this.pointtwo1.getX() & (double)j >= this.pointone1.getY() & (double)j <= this.pointtwo1.getY()) {
                        this.prechroma[i][j] = this.fill;
                    }
                } else if (this.pointone1.getX() <= this.pointtwo1.getX()) {
                    if (this.pointone1.getY() <= this.pointtwo1.getY() && (double)i >= this.pointone1.getX() & (double)i <= this.pointtwo1.getX() & (double)j >= this.pointone1.getY() & (double)j <= this.pointtwo1.getY()) {
                        this.prechroma[i][j] = this.fill;
                    }
                    if (this.pointone1.getY() >= this.pointtwo1.getY() && (double)i >= this.pointone1.getX() & (double)i <= this.pointtwo1.getX() & (double)j <= this.pointone1.getY() & (double)j >= this.pointtwo1.getY()) {
                        this.prechroma[i][j] = this.fill;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void fillRectangle() {
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                if (this.pointone.getX() >= this.pointtwo.getX()) {
                    if (this.pointone.getY() >= this.pointtwo.getY() && (double)i <= this.pointone.getX() & (double)i >= this.pointtwo.getX() & (double)j <= this.pointone.getY() & (double)j >= this.pointtwo.getY()) {
                        this.chroma[i][j] = this.fill;
                    }
                    if (this.pointone.getY() <= this.pointtwo.getY() && (double)i <= this.pointone.getX() & (double)i >= this.pointtwo.getX() & (double)j >= this.pointone.getY() & (double)j <= this.pointtwo.getY()) {
                        this.chroma[i][j] = this.fill;
                    }
                } else if (this.pointone.getX() <= this.pointtwo.getX()) {
                    if (this.pointone.getY() <= this.pointtwo.getY() && (double)i >= this.pointone.getX() & (double)i <= this.pointtwo.getX() & (double)j >= this.pointone.getY() & (double)j <= this.pointtwo.getY()) {
                        this.chroma[i][j] = this.fill;
                    }
                    if (this.pointone.getY() >= this.pointtwo.getY() && (double)i >= this.pointone.getX() & (double)i <= this.pointtwo.getX() & (double)j <= this.pointone.getY() & (double)j >= this.pointtwo.getY()) {
                        this.chroma[i][j] = this.fill;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.fill = Color.BLACK;
    }

    public Color[][] getColorArray() {
        return this.chroma;
    }

    public Color[][] getPreviewColorArray() {
        return this.prechroma;
    }

    public void fillArea(int x, int y, Color original, Color fill, Color[][] arr) {
        int maxX = arr.length - 1;
        int maxY = arr[0].length - 1;
        int[][] stack = new int[(maxX + 1) * (maxY + 1)][2];
        int index = 0;
        stack[0][0] = x;
        stack[0][1] = y;
        arr[x][y] = fill;
        while (index >= 0) {
            x = stack[index][0];
            y = stack[index][1];
            --index;
            if (x > 0 && arr[x - 1][y] == original) {
                arr[x - 1][y] = fill;
                stack[++index][0] = x - 1;
                stack[index][1] = y;
            }
            if (x < maxX && arr[x + 1][y] == original) {
                arr[x + 1][y] = fill;
                stack[++index][0] = x + 1;
                stack[index][1] = y;
            }
            if (y > 0 && arr[x][y - 1] == original) {
                arr[x][y - 1] = fill;
                stack[++index][0] = x;
                stack[index][1] = y - 1;
            }
            if (y >= maxY || arr[x][y + 1] != original) continue;
            arr[x][y + 1] = fill;
            stack[++index][0] = x;
            stack[index][1] = y + 1;
        }
        this.repaint();
    }

    public void deleteAll() {
        int i = 0;
        while (i < this.chroma.length) {
            int j = 0;
            while (j < this.chroma[i].length) {
                this.chroma[i][j] = null;
                ++j;
            }
            ++i;
        }
        this.repaint();
    }

    public static Color[][] copy(Color[][] grid) {
        Color[][] copied = new Color[grid.length][];
        int i = 0;
        while (i < grid.length) {
            copied[i] = Arrays.copyOf(grid[i], grid[i].length);
            ++i;
        }
        return copied;
    }

    public void saveStartRevision() {
        this.undo = new ArrayList();
        this.current = 0;
        System.out.println("Saving: " + this.current);
        this.undo.add(this.current, MImageEditor.copy(this.chroma));
        this.mx = 1;
    }

    public void saveRevision() {
        ++this.current;
        this.mx = this.current;
        this.undo.add(this.current, MImageEditor.copy(this.chroma));
        this.repaint();
    }

    public void undo() {
        if (this.current > 0) {
            --this.current;
            this.chroma = MImageEditor.copy(this.undo.get(this.current));
            this.repaint();
        }
    }

    public void redo() {
        if (this.current < this.mx) {
            ++this.current;
            this.chroma = MImageEditor.copy(this.undo.get(this.current));
            this.repaint();
        }
    }

    public int getPixels() {
        return this.size;
    }

    public void setGrid(boolean bol) {
        this.mreza = bol;
        this.repaint();
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public void open(File fil) {
        block85: {
            BufferedImage img;
            block88: {
                int j;
                int i;
                String s;
                Object[] possibilities;
                Frame frame;
                block86: {
                    img = null;
                    try {
                        img = ImageIO.read(fil);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (img == null) break block85;
                    if (img.getHeight() == img.getWidth() && (img.getHeight() + img.getWidth()) / 2 <= 64 || JOptionPane.showConfirmDialog(null, "Image hasn't got simetrical edges or is to big.\nDo you want to resize it?", "Resize", 0) != 0) break block86;
                    frame = new Frame();
                    possibilities = new Object[]{"4 x 4", "8 x 8", "16 x 16", "32 x 32", "64 x 64"};
                    switch (s = (String)JOptionPane.showInputDialog(frame, "Select the size of an image:", "Select size", -1, null, possibilities, "16 x 16")) {
                        case "4 x 4": {
                            img = MImageEditor.resize(img, 4, 4);
                            this.size = img.getHeight();
                            this.chroma = new Color[this.size][this.size];
                            this.prechroma = new Color[this.size][this.size];
                            this.rubberp = new boolean[this.size][this.size];
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.rubberp[i][j] = false;
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    if (img.getTransparency() > 128) {
                                        this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            break;
                        }
                        case "8 x 8": {
                            img = MImageEditor.resize(img, 8, 8);
                            this.size = img.getHeight();
                            this.chroma = new Color[this.size][this.size];
                            this.prechroma = new Color[this.size][this.size];
                            this.rubberp = new boolean[this.size][this.size];
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.rubberp[i][j] = false;
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                    ++j;
                                }
                                ++i;
                            }
                            break;
                        }
                        case "16 x 16": {
                            img = MImageEditor.resize(img, 16, 16);
                            this.size = img.getHeight();
                            this.chroma = new Color[this.size][this.size];
                            this.prechroma = new Color[this.size][this.size];
                            this.rubberp = new boolean[this.size][this.size];
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.rubberp[i][j] = false;
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                    ++j;
                                }
                                ++i;
                            }
                            break;
                        }
                        case "32 x 32": {
                            img = MImageEditor.resize(img, 32, 32);
                            this.size = img.getHeight();
                            this.chroma = new Color[this.size][this.size];
                            this.prechroma = new Color[this.size][this.size];
                            this.rubberp = new boolean[this.size][this.size];
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.rubberp[i][j] = false;
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                    ++j;
                                }
                                ++i;
                            }
                            break;
                        }
                        case "64 x 64": {
                            img = MImageEditor.resize(img, 64, 64);
                            this.size = img.getHeight();
                            this.chroma = new Color[this.size][this.size];
                            this.prechroma = new Color[this.size][this.size];
                            this.rubberp = new boolean[this.size][this.size];
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.rubberp[i][j] = false;
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < this.size) {
                                j = 0;
                                while (j < this.size) {
                                    this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                    ++j;
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                }
                if (JOptionPane.showConfirmDialog(null, "Your image fitts all the requirements.\nDo you want to resize iz anyway?", "Resize", 0) != 0) break block88;
                frame = new Frame();
                possibilities = new Object[]{"4 x 4", "8 x 8", "16 x 16", "32 x 32", "64 x 64"};
                switch (s = (String)JOptionPane.showInputDialog(frame, "Select the size of an image:", "Select size", -1, null, possibilities, "16 x 16")) {
                    case "4 x 4": {
                        img = MImageEditor.resize(img, 4, 4);
                        this.size = img.getHeight();
                        this.chroma = new Color[this.size][this.size];
                        this.prechroma = new Color[this.size][this.size];
                        this.rubberp = new boolean[this.size][this.size];
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.rubberp[i][j] = false;
                                ++j;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        break block85;
                    }
                    case "8 x 8": {
                        img = MImageEditor.resize(img, 8, 8);
                        this.size = img.getHeight();
                        this.chroma = new Color[this.size][this.size];
                        this.prechroma = new Color[this.size][this.size];
                        this.rubberp = new boolean[this.size][this.size];
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.rubberp[i][j] = false;
                                ++j;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        break block85;
                    }
                    case "16 x 16": {
                        img = MImageEditor.resize(img, 16, 16);
                        this.size = img.getHeight();
                        this.chroma = new Color[this.size][this.size];
                        this.prechroma = new Color[this.size][this.size];
                        this.rubberp = new boolean[this.size][this.size];
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.rubberp[i][j] = false;
                                ++j;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        break block85;
                    }
                    case "32 x 32": {
                        img = MImageEditor.resize(img, 32, 32);
                        this.size = img.getHeight();
                        this.chroma = new Color[this.size][this.size];
                        this.prechroma = new Color[this.size][this.size];
                        this.rubberp = new boolean[this.size][this.size];
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.rubberp[i][j] = false;
                                ++j;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        break block85;
                    }
                    case "64 x 64": {
                        img = MImageEditor.resize(img, 64, 64);
                        this.size = img.getHeight();
                        this.chroma = new Color[this.size][this.size];
                        this.prechroma = new Color[this.size][this.size];
                        this.rubberp = new boolean[this.size][this.size];
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.rubberp[i][j] = false;
                                ++j;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.size) {
                            j = 0;
                            while (j < this.size) {
                                this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        break block22;
                    }
                }
                break block85;
            }
            this.size = img.getHeight();
            this.chroma = new Color[this.size][this.size];
            this.prechroma = new Color[this.size][this.size];
            this.rubberp = new boolean[this.size][this.size];
            int i = 0;
            while (i < this.size) {
                int j = 0;
                while (j < this.size) {
                    this.rubberp[i][j] = false;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.size) {
                int j = 0;
                while (j < this.size) {
                    this.chroma[i][j] = this.isTransparent(i, j, img) ? null : new Color(img.getRGB(i, j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean isTransparent(int x, int y, BufferedImage img) {
        int pixel = img.getRGB(x, y);
        return pixel >> 24 == 0;
    }

    public void writeImage(String path) {
        BufferedImage image = new BufferedImage(this.chroma.length, this.chroma[0].length, 2);
        Graphics2D gdvad = (Graphics2D)image.getGraphics();
        int x = 0;
        while (x < this.size) {
            int y = 0;
            while (y < this.size) {
                if (this.chroma[x][y] != null) {
                    gdvad.setColor(this.chroma[x][y]);
                } else {
                    gdvad.setColor(new Color(0, 0, 0, 0));
                }
                gdvad.drawLine(x, y, x, y);
                ++y;
            }
            ++x;
        }
        File ImageFile = new File(path);
        try {
            ImageIO.write((RenderedImage)image, "png", ImageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int j;
        this.y = this.getHeight() + this.size - (this.getHeight() + this.size) % this.size;
        this.x = this.getWidth() + this.size - (this.getWidth() + this.size) % this.size;
        BufferedImage img = new BufferedImage(this.size * 16, this.size * 16, 2);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        int i = 0;
        while (i < this.size) {
            j = 0;
            while (j < this.size) {
                if (this.chroma[i][j] != null) {
                    g2d.setColor(this.chroma[i][j]);
                    g2d.fillRect(i * img.getWidth() / this.size, j * img.getHeight() / this.size, img.getWidth() / this.size, img.getHeight() / this.size);
                } else {
                    g2d.setColor(this.transparent1);
                    g2d.fillRect(i * img.getWidth() / this.size, j * img.getHeight() / this.size, img.getWidth() / this.size, img.getHeight() / this.size);
                    g2d.setColor(this.transparent2);
                    g2d.fillRect(i * img.getWidth() / this.size, j * img.getHeight() / this.size, img.getWidth() / this.size / 2, img.getHeight() / this.size / 2);
                    g2d.fillRect((int)(((double)i + 0.5) * (double)(img.getWidth() / this.size)), (int)(((double)j + 0.5) * (double)(img.getHeight() / this.size)), img.getWidth() / this.size / 2, img.getHeight() / this.size / 2);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size) {
            j = 0;
            while (j < this.size) {
                if (this.prechroma[i][j] != null) {
                    g2d.setColor(new Color(this.prechroma[i][j].getRed(), this.prechroma[i][j].getGreen(), this.prechroma[i][j].getBlue(), 128));
                    g2d.fillRect(i * img.getWidth() / this.size, j * img.getHeight() / this.size, img.getWidth() / this.size, img.getHeight() / this.size);
                }
                if (this.rubberp[i][j]) {
                    g2d.setColor(new Color(this.transparent1.getRed(), this.transparent1.getGreen(), this.transparent1.getBlue(), 128));
                    g2d.fillRect(i * img.getWidth() / this.size, j * img.getHeight() / this.size, img.getWidth() / this.size, img.getHeight() / this.size);
                    g2d.setColor(new Color(this.transparent2.getRed(), this.transparent2.getGreen(), this.transparent2.getBlue(), 128));
                    g2d.fillRect(i * img.getWidth() / this.size, j * img.getHeight() / this.size, img.getWidth() / this.size / 2, img.getHeight() / this.size / 2);
                    g2d.fillRect((int)(((double)i + 0.5) * (double)(img.getWidth() / this.size)), (int)(((double)j + 0.5) * (double)(img.getHeight() / this.size)), img.getWidth() / this.size / 2, img.getHeight() / this.size / 2);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size) {
            j = 0;
            while (j < this.size) {
                this.rubberp[i][j] = false;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size) {
            j = 0;
            while (j < this.size) {
                this.prechroma[i][j] = null;
                ++j;
            }
            ++i;
        }
        if (this.mreza) {
            g2d.setColor(Color.BLACK);
            i = 1;
            while (i < this.size) {
                g2d.drawLine(i * (img.getWidth() / this.size), 0, i * (img.getWidth() / this.size), this.y);
                j = 1;
                while (j < this.size) {
                    g2d.drawLine(0, j * (img.getHeight() / this.size), this.x, j * (img.getHeight() / this.size));
                    ++j;
                }
                ++i;
            }
        } else {
            g2d.setColor(Color.BLACK);
        }
        g2d.drawRect(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2d.setColor(Color.RED);
        g2d.drawLine(img.getWidth() / 2, img.getHeight() / 2 + 10, img.getWidth() / 2, img.getHeight() / 2 - 10);
        g2d.drawLine(img.getWidth() / 2 + 10, img.getHeight() / 2, img.getWidth() / 2 - 10, img.getHeight() / 2);
        g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), null);
        g.dispose();
        ((Graphics2D)g).setComposite(AlphaComposite.Src);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

