/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class RotatedButton
extends JButton {
    private static final long serialVersionUID = 1L;
    XButton template;
    boolean clockwise;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Test Rotated Button");
                frame.setDefaultCloseOperation(3);
                frame.setSize(400, 400);
                frame.setLayout(new FlowLayout());
                frame.add(new RotatedButton("Test Clockwise", true));
                frame.add(new RotatedButton("Test Anticlockwise", false));
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public RotatedButton(String text, boolean clockwise) {
        this.template = new XButton(text);
        this.clockwise = clockwise;
        Dimension d = this.template.getPreferredSize();
        this.setPreferredSize(new Dimension(d.height, d.width));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension d = this.getSize();
        this.template.setSize(d.height, d.width);
        if (this.clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -this.getSize().width);
        } else {
            g2.translate(0, this.getSize().height);
            g2.rotate(-1.5707963267948966);
        }
        this.template.setSelected(this.getModel().isPressed());
        this.template.paintComponent(g2);
        g2.dispose();
    }

    private class XButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;

        XButton(String text) {
            super(text);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

