/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.gradle.GradleStartCommon;
import org.apache.logging.log4j.Level;

public class GradleForgeHacks {
    private static final String NO_CORE_SEARCH = "--noCoreSearch";
    private static final String COREMOD_VAR = "fml.coreMods.load";
    private static final String COREMOD_MF = "FMLCorePlugin";
    private static final String MOD_ATD_CLASS = "net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer";
    private static final String MOD_AT_METHOD = "addJar";
    public static final Map<String, File> coreMap = Maps.newHashMap();

    public static void searchCoremods(GradleStartCommon common) {
        if (common.extras.contains(NO_CORE_SEARCH)) {
            GradleStartCommon.LOGGER.info("GradleStart coremod searching disabled!");
            common.extras.remove(NO_CORE_SEARCH);
            return;
        }
        AtRegistrar atRegistrar = new AtRegistrar();
        URLClassLoader urlClassLoader = (URLClassLoader)GradleStartCommon.class.getClassLoader();
        for (URL url : urlClassLoader.getURLs()) {
            try {
                GradleForgeHacks.searchCoremodAtUrl(url, atRegistrar);
            }
            catch (IOException | IllegalAccessException | InvocationTargetException | URISyntaxException e) {
                GradleStartCommon.LOGGER.warn("GradleForgeHacks failed to search for coremod at url {}", (Object)url, (Object)e);
            }
        }
        HashSet coremodsSet = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)System.getProperty(COREMOD_VAR))) {
            coremodsSet.addAll(Splitter.on((char)',').splitToList((CharSequence)System.getProperty(COREMOD_VAR)));
        }
        coremodsSet.addAll(coreMap.keySet());
        System.setProperty(COREMOD_VAR, Joiner.on((char)',').join((Iterable)coremodsSet));
        if (!Strings.isNullOrEmpty((String)common.getTweakClass())) {
            common.extras.add("--tweakClass");
            common.extras.add("net.minecraftforge.gradle.tweakers.CoremodTweaker");
        }
    }

    private static void searchCoremodAtUrl(URL url, AtRegistrar atRegistrar) throws IOException, InvocationTargetException, IllegalAccessException, URISyntaxException {
        String clazz;
        if (!url.getProtocol().startsWith("file")) {
            return;
        }
        File coreMod = new File(url.toURI().getPath());
        Manifest manifest = null;
        if (!coreMod.exists()) {
            return;
        }
        if (coreMod.isDirectory()) {
            File manifestMF = new File(coreMod, "META-INF/MANIFEST.MF");
            if (manifestMF.exists()) {
                FileInputStream stream = new FileInputStream(manifestMF);
                manifest = new Manifest(stream);
                stream.close();
            }
        } else if (coreMod.getName().endsWith("jar")) {
            try (JarFile jar = new JarFile(coreMod);){
                manifest = jar.getManifest();
                if (manifest != null) {
                    atRegistrar.addJar(jar, manifest);
                }
            }
        }
        if (manifest != null && !Strings.isNullOrEmpty((String)(clazz = manifest.getMainAttributes().getValue(COREMOD_MF)))) {
            GradleStartCommon.LOGGER.info("Found and added coremod: " + clazz);
            coreMap.put(clazz, coreMod);
        }
    }

    public static final class AccessTransformerTransformer
    implements IClassTransformer {
        public AccessTransformerTransformer() {
            this.doStuff((LaunchClassLoader)this.getClass().getClassLoader());
        }

        private void doStuff(LaunchClassLoader classloader) {
            Class<?> clazz = null;
            IClassTransformer instance = null;
            for (IClassTransformer transformer : classloader.getTransformers()) {
                if (!transformer.getClass().getCanonicalName().endsWith(GradleForgeHacks.MOD_ATD_CLASS)) continue;
                clazz = transformer.getClass();
                instance = transformer;
            }
            if (clazz == null || instance == null) {
                GradleStartCommon.LOGGER.log(Level.ERROR, "ModAccessTransformer was somehow not found.");
                return;
            }
            Collection modifiers = null;
            try {
                Field f = clazz.getSuperclass().getDeclaredFields()[1];
                f.setAccessible(true);
                modifiers = ((Multimap)f.get(instance)).values();
            }
            catch (Throwable t) {
                GradleStartCommon.LOGGER.log(Level.ERROR, "AccessTransformer.modifiers field was somehow not found...");
                return;
            }
            if (modifiers.isEmpty()) {
                return;
            }
            Field nameField = null;
            try {
                Object mod = null;
                Iterator iterator = modifiers.iterator();
                if (iterator.hasNext()) {
                    Object val = iterator.next();
                    mod = val;
                }
                nameField = mod.getClass().getFields()[0];
                nameField.setAccessible(true);
            }
            catch (Throwable t) {
                GradleStartCommon.LOGGER.log(Level.ERROR, "AccessTransformer.Modifier.name field was somehow not found...");
                return;
            }
            HashMap nameMap = Maps.newHashMap();
            try {
                this.readCsv(new File(GradleStartCommon.CSV_DIR, "fields.csv"), nameMap);
                this.readCsv(new File(GradleStartCommon.CSV_DIR, "methods.csv"), nameMap);
            }
            catch (IOException e) {
                GradleStartCommon.LOGGER.log(Level.ERROR, "Could not load CSV files!");
                e.printStackTrace();
                return;
            }
            GradleStartCommon.LOGGER.log(Level.INFO, "Remapping AccessTransformer rules...");
            for (Object modifier : modifiers) {
                try {
                    String name = (String)nameField.get(modifier);
                    String newName = (String)nameMap.get(name);
                    if (newName == null) continue;
                    nameField.set(modifier, newName);
                }
                catch (Exception exception) {}
            }
        }

        private void readCsv(File file, Map<String, String> map) throws IOException {
            GradleStartCommon.LOGGER.log(Level.DEBUG, "Reading CSV file: {}", (Object)file);
            Splitter split = Splitter.on((char)',').trimResults().limit(3);
            for (String line : Files.readLines((File)file, (Charset)Charsets.UTF_8)) {
                if (line.startsWith("searge")) continue;
                List splits = split.splitToList((CharSequence)line);
                map.put((String)splits.get(0), (String)splits.get(1));
            }
        }

        public byte[] transform(String name, String transformedName, byte[] basicClass) {
            return basicClass;
        }
    }

    private static final class AtRegistrar {
        private static final Attributes.Name FMLAT = new Attributes.Name("FMLAT");
        @Nullable
        private Method newMethod = null;
        @Nullable
        private Method oldMethod = null;

        private AtRegistrar() {
            try {
                Class<?> modAtdClass = Class.forName(GradleForgeHacks.MOD_ATD_CLASS);
                try {
                    this.newMethod = modAtdClass.getDeclaredMethod(GradleForgeHacks.MOD_AT_METHOD, JarFile.class, String.class);
                }
                catch (NoSuchMethodException | SecurityException ignored) {
                    try {
                        this.oldMethod = modAtdClass.getDeclaredMethod(GradleForgeHacks.MOD_AT_METHOD, JarFile.class);
                    }
                    catch (NoSuchMethodException | SecurityException ignored2) {
                        GradleStartCommon.LOGGER.error("Failed to find method {}.{}", (Object)GradleForgeHacks.MOD_ATD_CLASS, (Object)GradleForgeHacks.MOD_AT_METHOD);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                GradleStartCommon.LOGGER.error("Failed to find class {}", (Object)GradleForgeHacks.MOD_ATD_CLASS);
            }
        }

        public void addJar(JarFile jarFile, Manifest manifest) throws InvocationTargetException, IllegalAccessException {
            if (this.newMethod != null) {
                String ats = manifest.getMainAttributes().getValue(FMLAT);
                if (ats != null && !ats.isEmpty()) {
                    this.newMethod.invoke(null, jarFile, ats);
                }
            } else if (this.oldMethod != null) {
                this.oldMethod.invoke(null, jarFile);
            }
        }
    }
}

