/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.alpha_dimension;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.mcreator.alpha_dimension.alpha_dimension;
import net.mcreator.alpha_dimension.alpha_dimensionVariables;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;

public class Elementsalpha_dimension
implements IFuelHandler,
IWorldGenerator {
    protected final List<ModElement> elements = new ArrayList<ModElement>();
    protected final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    protected final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    protected final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    protected final List<Supplier<EntityEntry>> entities = new ArrayList<Supplier<EntityEntry>>();
    protected final List<Supplier<Potion>> potions = new ArrayList<Supplier<Potion>>();
    private int messageID = 0;

    public void preInit(FMLPreInitializationEvent event) {
        try {
            for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ModElement.Tag.class.getName())) {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (clazz.getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(alpha_dimensionVariables.WorldSavedDataSyncMessageHandler.class, alpha_dimensionVariables.WorldSavedDataSyncMessage.class, Side.SERVER, Side.CLIENT);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ResourceLocation sound0 = new ResourceLocation("alpha_dimension", "1chickendeath");
        event.getRegistry().register(new SoundEvent(sound0).setRegistryName(sound0));
        ResourceLocation sound1 = new ResourceLocation("alpha_dimension", "1chickenhurt");
        event.getRegistry().register(new SoundEvent(sound1).setRegistryName(sound1));
        ResourceLocation sound2 = new ResourceLocation("alpha_dimension", "1chickensounds");
        event.getRegistry().register(new SoundEvent(sound2).setRegistryName(sound2));
        ResourceLocation sound3 = new ResourceLocation("alpha_dimension", "1cowdeath");
        event.getRegistry().register(new SoundEvent(sound3).setRegistryName(sound3));
        ResourceLocation sound4 = new ResourceLocation("alpha_dimension", "1cowhurt");
        event.getRegistry().register(new SoundEvent(sound4).setRegistryName(sound4));
        ResourceLocation sound5 = new ResourceLocation("alpha_dimension", "1cowsounds");
        event.getRegistry().register(new SoundEvent(sound5).setRegistryName(sound5));
        ResourceLocation sound6 = new ResourceLocation("alpha_dimension", "1creeperdeath");
        event.getRegistry().register(new SoundEvent(sound6).setRegistryName(sound6));
        ResourceLocation sound7 = new ResourceLocation("alpha_dimension", "1creeperhurt");
        event.getRegistry().register(new SoundEvent(sound7).setRegistryName(sound7));
        ResourceLocation sound8 = new ResourceLocation("alpha_dimension", "1zombiedeath");
        event.getRegistry().register(new SoundEvent(sound8).setRegistryName(sound8));
        ResourceLocation sound9 = new ResourceLocation("alpha_dimension", "1zombiehurt");
        event.getRegistry().register(new SoundEvent(sound9).setRegistryName(sound9));
        ResourceLocation sound10 = new ResourceLocation("alpha_dimension", "1zombiesounds");
        event.getRegistry().register(new SoundEvent(sound10).setRegistryName(sound10));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator cg, IChunkProvider cp) {
        this.elements.forEach(element -> element.generateWorld(random, chunkX * 16, chunkZ * 16, world, world.field_73011_w.getDimension(), cg, cp));
    }

    public int getBurnTime(ItemStack fuel) {
        for (ModElement element : this.elements) {
            int ret = element.addFuel(fuel);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            alpha_dimensionVariables.MapVariables mapdata = alpha_dimensionVariables.MapVariables.get(event.player.field_70170_p);
            alpha_dimensionVariables.WorldVariables worlddata = alpha_dimensionVariables.WorldVariables.get(event.player.field_70170_p);
            if (mapdata != null) {
                alpha_dimension.PACKET_HANDLER.sendTo((IMessage)new alpha_dimensionVariables.WorldSavedDataSyncMessage(0, mapdata), (EntityPlayerMP)event.player);
            }
            if (worlddata != null) {
                alpha_dimension.PACKET_HANDLER.sendTo((IMessage)new alpha_dimensionVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        alpha_dimensionVariables.WorldVariables worlddata;
        if (!event.player.field_70170_p.field_72995_K && (worlddata = alpha_dimensionVariables.WorldVariables.get(event.player.field_70170_p)) != null) {
            alpha_dimension.PACKET_HANDLER.sendTo((IMessage)new alpha_dimensionVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
    }

    public <T extends IMessage, V extends IMessage> void addNetworkMessage(Class<? extends IMessageHandler<T, V>> handler, Class<T> messageClass, Side ... sides) {
        for (Side side : sides) {
            alpha_dimension.PACKET_HANDLER.registerMessage(handler, messageClass, this.messageID, side);
        }
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityEntry>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Potion>> getPotions() {
        return this.potions;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final Elementsalpha_dimension elements;
        protected final int sortid;

        public ModElement(Elementsalpha_dimension elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLInitializationEvent event) {
        }

        public void preInit(FMLPreInitializationEvent event) {
        }

        public void generateWorld(Random random, int posX, int posZ, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        public void registerModels(ModelRegistryEvent event) {
        }

        public int addFuel(ItemStack fuel) {
            return 0;
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }

    public static class GuiHandler
    implements IGuiHandler {
        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }
    }
}

