/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.non;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.mcreator.non.non;
import net.mcreator.non.nonVariables;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;

public class Elementsnon
implements IFuelHandler,
IWorldGenerator {
    protected final List<ModElement> elements = new ArrayList<ModElement>();
    protected final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    protected final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    protected final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    protected final List<Supplier<EntityEntry>> entities = new ArrayList<Supplier<EntityEntry>>();
    protected final List<Supplier<Potion>> potions = new ArrayList<Supplier<Potion>>();
    private int messageID = 0;

    public void preInit(FMLPreInitializationEvent event) {
        try {
            for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ModElement.Tag.class.getName())) {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (clazz.getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(nonVariables.WorldSavedDataSyncMessageHandler.class, nonVariables.WorldSavedDataSyncMessage.class, Side.SERVER, Side.CLIENT);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ResourceLocation sound0 = new ResourceLocation("non", "vitulaambient");
        event.getRegistry().register(new SoundEvent(sound0).setRegistryName(sound0));
        ResourceLocation sound1 = new ResourceLocation("non", "vitulahurt");
        event.getRegistry().register(new SoundEvent(sound1).setRegistryName(sound1));
        ResourceLocation sound2 = new ResourceLocation("non", "vituladeath");
        event.getRegistry().register(new SoundEvent(sound2).setRegistryName(sound2));
        ResourceLocation sound3 = new ResourceLocation("non", "rubedoambient");
        event.getRegistry().register(new SoundEvent(sound3).setRegistryName(sound3));
        ResourceLocation sound4 = new ResourceLocation("non", "rubedohrt");
        event.getRegistry().register(new SoundEvent(sound4).setRegistryName(sound4));
        ResourceLocation sound5 = new ResourceLocation("non", "rubedodeath");
        event.getRegistry().register(new SoundEvent(sound5).setRegistryName(sound5));
        ResourceLocation sound6 = new ResourceLocation("non", "vitulamilked");
        event.getRegistry().register(new SoundEvent(sound6).setRegistryName(sound6));
        ResourceLocation sound7 = new ResourceLocation("non", "ardereambient");
        event.getRegistry().register(new SoundEvent(sound7).setRegistryName(sound7));
        ResourceLocation sound8 = new ResourceLocation("non", "arderehurt");
        event.getRegistry().register(new SoundEvent(sound8).setRegistryName(sound8));
        ResourceLocation sound9 = new ResourceLocation("non", "arderedeath");
        event.getRegistry().register(new SoundEvent(sound9).setRegistryName(sound9));
        ResourceLocation sound10 = new ResourceLocation("non", "purpurhop");
        event.getRegistry().register(new SoundEvent(sound10).setRegistryName(sound10));
        ResourceLocation sound11 = new ResourceLocation("non", "purpurhurt");
        event.getRegistry().register(new SoundEvent(sound11).setRegistryName(sound11));
        ResourceLocation sound12 = new ResourceLocation("non", "purpurdeath");
        event.getRegistry().register(new SoundEvent(sound12).setRegistryName(sound12));
        ResourceLocation sound13 = new ResourceLocation("non", "fireburstambient");
        event.getRegistry().register(new SoundEvent(sound13).setRegistryName(sound13));
        ResourceLocation sound14 = new ResourceLocation("non", "fireburstdeath");
        event.getRegistry().register(new SoundEvent(sound14).setRegistryName(sound14));
        ResourceLocation sound15 = new ResourceLocation("non", "firebursthurt");
        event.getRegistry().register(new SoundEvent(sound15).setRegistryName(sound15));
        ResourceLocation sound16 = new ResourceLocation("non", "frozenambient");
        event.getRegistry().register(new SoundEvent(sound16).setRegistryName(sound16));
        ResourceLocation sound17 = new ResourceLocation("non", "frozenhurt");
        event.getRegistry().register(new SoundEvent(sound17).setRegistryName(sound17));
        ResourceLocation sound18 = new ResourceLocation("non", "frozendeath");
        event.getRegistry().register(new SoundEvent(sound18).setRegistryName(sound18));
        ResourceLocation sound19 = new ResourceLocation("non", "frostambient");
        event.getRegistry().register(new SoundEvent(sound19).setRegistryName(sound19));
        ResourceLocation sound20 = new ResourceLocation("non", "frosthurt");
        event.getRegistry().register(new SoundEvent(sound20).setRegistryName(sound20));
        ResourceLocation sound21 = new ResourceLocation("non", "frostdeath");
        event.getRegistry().register(new SoundEvent(sound21).setRegistryName(sound21));
        ResourceLocation sound22 = new ResourceLocation("non", "iamamonster");
        event.getRegistry().register(new SoundEvent(sound22).setRegistryName(sound22));
        ResourceLocation sound23 = new ResourceLocation("non", "nowiamdead");
        event.getRegistry().register(new SoundEvent(sound23).setRegistryName(sound23));
        ResourceLocation sound24 = new ResourceLocation("non", "ow");
        event.getRegistry().register(new SoundEvent(sound24).setRegistryName(sound24));
        ResourceLocation sound25 = new ResourceLocation("non", "spitterambient");
        event.getRegistry().register(new SoundEvent(sound25).setRegistryName(sound25));
        ResourceLocation sound26 = new ResourceLocation("non", "spitterhurt");
        event.getRegistry().register(new SoundEvent(sound26).setRegistryName(sound26));
        ResourceLocation sound27 = new ResourceLocation("non", "spitterdeath");
        event.getRegistry().register(new SoundEvent(sound27).setRegistryName(sound27));
        ResourceLocation sound28 = new ResourceLocation("non", "oceans");
        event.getRegistry().register(new SoundEvent(sound28).setRegistryName(sound28));
        ResourceLocation sound29 = new ResourceLocation("non", "tminus");
        event.getRegistry().register(new SoundEvent(sound29).setRegistryName(sound29));
        ResourceLocation sound30 = new ResourceLocation("non", "bellings");
        event.getRegistry().register(new SoundEvent(sound30).setRegistryName(sound30));
        ResourceLocation sound31 = new ResourceLocation("non", "bellingshurt");
        event.getRegistry().register(new SoundEvent(sound31).setRegistryName(sound31));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator cg, IChunkProvider cp) {
        this.elements.forEach(element -> element.generateWorld(random, chunkX * 16, chunkZ * 16, world, world.field_73011_w.getDimension(), cg, cp));
    }

    public int getBurnTime(ItemStack fuel) {
        for (ModElement element : this.elements) {
            int ret = element.addFuel(fuel);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            nonVariables.MapVariables mapdata = nonVariables.MapVariables.get(event.player.field_70170_p);
            nonVariables.WorldVariables worlddata = nonVariables.WorldVariables.get(event.player.field_70170_p);
            if (mapdata != null) {
                non.PACKET_HANDLER.sendTo((IMessage)new nonVariables.WorldSavedDataSyncMessage(0, mapdata), (EntityPlayerMP)event.player);
            }
            if (worlddata != null) {
                non.PACKET_HANDLER.sendTo((IMessage)new nonVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        nonVariables.WorldVariables worlddata;
        if (!event.player.field_70170_p.field_72995_K && (worlddata = nonVariables.WorldVariables.get(event.player.field_70170_p)) != null) {
            non.PACKET_HANDLER.sendTo((IMessage)new nonVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
    }

    public <T extends IMessage, V extends IMessage> void addNetworkMessage(Class<? extends IMessageHandler<T, V>> handler, Class<T> messageClass, Side ... sides) {
        for (Side side : sides) {
            non.PACKET_HANDLER.registerMessage(handler, messageClass, this.messageID, side);
        }
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityEntry>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Potion>> getPotions() {
        return this.potions;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final Elementsnon elements;
        protected final int sortid;

        public ModElement(Elementsnon elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLInitializationEvent event) {
        }

        public void preInit(FMLPreInitializationEvent event) {
        }

        public void generateWorld(Random random, int posX, int posZ, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        public void registerModels(ModelRegistryEvent event) {
        }

        public int addFuel(ItemStack fuel) {
            return 0;
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }

    public static class GuiHandler
    implements IGuiHandler {
        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }
    }
}

