/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kindomoffoxes.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mcreator.kindomoffoxes.KindomOfFoxesModElements;
import net.mcreator.kindomoffoxes.item.LunarCrystalPowderItem;
import net.mcreator.kindomoffoxes.item.LunarStaffItem;
import net.mcreator.kindomoffoxes.itemgroup.KOFMiscelaneousItemGroup;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@KindomOfFoxesModElements.ModElement.Tag
public class LunarWizardEntity
extends KindomOfFoxesModElements.ModElement {
    public static EntityType entity = null;

    public LunarWizardEntity(KindomOfFoxesModElements instance) {
        super(instance, 73);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.8f).func_206830_a("lunar_wizard").setRegistryName("lunar_wizard");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -6710887, -13369345, new Item.Properties().func_200916_a(KOFMiscelaneousItemGroup.tab)).setRegistryName("lunar_wizard_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("kindom_of_foxes:lunar_forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 20, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 40.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta) {
        LunarWizardEntity.addBoxHelper(renderer, texU, texV, x, y, z, dx, dy, dz, delta, renderer.field_78809_i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta, boolean mirror) {
        renderer.field_78809_i = mirror;
        renderer.func_217178_a("", x, y, z, dx, dy, dz, delta, texU, texV);
    }

    public static class ModelLunarWizard
    extends EntityModel<Entity> {
        private final ModelRenderer bb_main;
        private final ModelRenderer bone;
        private final ModelRenderer bone2;
        private final ModelRenderer bone3;
        private final ModelRenderer bone4;
        private final ModelRenderer bone5;

        public ModelLunarWizard() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.bb_main = new ModelRenderer((Model)this);
            this.bb_main.func_78793_a(0.0f, 24.0f, 0.0f);
            LunarWizardEntity.addBoxHelper(this.bb_main, 0, 0, -4.0f, -24.0f, -2.0f, 8, 15, 4, 0.0f, false);
            LunarWizardEntity.addBoxHelper(this.bb_main, 16, 19, -1.0f, -17.0f, -1.0f, 2, 2, 2, 0.0f, false);
            this.bone = new ModelRenderer((Model)this);
            this.bone.func_78793_a(3.0f, 15.0f, 0.0f);
            LunarWizardEntity.addBoxHelper(this.bone, 14, 30, -1.0f, 0.0f, -1.0f, 2, 9, 2, 0.0f, false);
            this.bone2 = new ModelRenderer((Model)this);
            this.bone2.func_78793_a(4.0f, 2.0f, 0.0f);
            LunarWizardEntity.addBoxHelper(this.bone2, 0, 19, 0.0f, -1.0f, -1.0f, 2, 11, 2, 0.0f, false);
            this.bone3 = new ModelRenderer((Model)this);
            this.bone3.func_78793_a(-4.0f, 2.0f, 0.0f);
            LunarWizardEntity.addBoxHelper(this.bone3, 8, 19, -2.0f, -1.0f, -1.0f, 2, 11, 2, 0.0f, false);
            this.bone4 = new ModelRenderer((Model)this);
            this.bone4.func_78793_a(0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.bone4, 0.0f, 3.1416f, 0.0f);
            LunarWizardEntity.addBoxHelper(this.bone4, 18, 18, -3.0f, -6.0f, -3.0f, 6, 6, 6, 0.0f, false);
            this.bone5 = new ModelRenderer((Model)this);
            this.bone5.func_78793_a(-3.0f, 15.0f, 0.0f);
            LunarWizardEntity.addBoxHelper(this.bone5, 24, 0, -1.0f, 0.0f, -1.0f, 2, 9, 2, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            this.bb_main.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.bone.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.bone2.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.bone3.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.bone4.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.bone5.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.bone3.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.bone2.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.bone5.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.bone4.field_78796_g = f3 / 57.295776f;
            this.bone4.field_78795_f = f4 / 57.295776f;
            this.bone.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
        }
    }

    public static class CustomEntity
    extends MonsterEntity
    implements IRangedAttackMob {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 10;
            this.func_94061_f(false);
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)LunarStaffItem.block, 1));
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true, true));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal(this, 1.25, 20, 10.0f){

                public boolean func_75253_b() {
                    return this.func_75250_a();
                }
            });
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)LunarCrystalPowderItem.block, 1));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_82196_d(LivingEntity target, float flval) {
            LunarStaffItem.shoot((LivingEntity)this, target);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelLunarWizard(), 0.5f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("kindom_of_foxes:textures/wizardtexture.png");
                }
            });
        }
    }
}

