/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.smololive;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.smololive.SmololiveMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class SmololiveModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public SmololiveModElements() {
        sounds.put(new ResourceLocation("smololive", "entities.ame_living"), new SoundEvent(new ResourceLocation("smololive", "entities.ame_living")));
        sounds.put(new ResourceLocation("smololive", "entities.ame_hit"), new SoundEvent(new ResourceLocation("smololive", "entities.ame_hit")));
        sounds.put(new ResourceLocation("smololive", "entities.ame_death"), new SoundEvent(new ResourceLocation("smololive", "entities.ame_death")));
        sounds.put(new ResourceLocation("smololive", "entities.kiara_living"), new SoundEvent(new ResourceLocation("smololive", "entities.kiara_living")));
        sounds.put(new ResourceLocation("smololive", "entities.kiara_hit"), new SoundEvent(new ResourceLocation("smololive", "entities.kiara_hit")));
        sounds.put(new ResourceLocation("smololive", "entities.kiara_death"), new SoundEvent(new ResourceLocation("smololive", "entities.kiara_death")));
        sounds.put(new ResourceLocation("smololive", "entities.calli_living"), new SoundEvent(new ResourceLocation("smololive", "entities.calli_living")));
        sounds.put(new ResourceLocation("smololive", "entities.calli_hit"), new SoundEvent(new ResourceLocation("smololive", "entities.calli_hit")));
        sounds.put(new ResourceLocation("smololive", "entities.calli_death"), new SoundEvent(new ResourceLocation("smololive", "entities.calli_death")));
        sounds.put(new ResourceLocation("smololive", "recorder"), new SoundEvent(new ResourceLocation("smololive", "recorder")));
        sounds.put(new ResourceLocation("smololive", "entities.ina_living"), new SoundEvent(new ResourceLocation("smololive", "entities.ina_living")));
        sounds.put(new ResourceLocation("smololive", "entities.ina_hit"), new SoundEvent(new ResourceLocation("smololive", "entities.ina_hit")));
        sounds.put(new ResourceLocation("smololive", "entities.ina_death"), new SoundEvent(new ResourceLocation("smololive", "entities.ina_death")));
        sounds.put(new ResourceLocation("smololive", "entities.gura_living"), new SoundEvent(new ResourceLocation("smololive", "entities.gura_living")));
        sounds.put(new ResourceLocation("smololive", "entities.gura_hit"), new SoundEvent(new ResourceLocation("smololive", "entities.gura_hit")));
        sounds.put(new ResourceLocation("smololive", "entities.gura_death"), new SoundEvent(new ResourceLocation("smololive", "entities.gura_death")));
        sounds.put(new ResourceLocation("smololive", "a"), new SoundEvent(new ResourceLocation("smololive", "a")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("smololive").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        SmololiveMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final SmololiveModElements elements;
        protected final int sortid;

        public ModElement(SmololiveModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

