/*
 * Decompiled with CFR 0.152.
 */
package net.mj.mjsanimations.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.mj.mjsanimations.MjsAnimationsMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MjsAnimationsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MjsAnimationsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.NearGround = message.data.NearGround;
                    variables.Passive_Animations = message.data.Passive_Animations;
                    variables.Do_Naruto = message.data.Do_Naruto;
                    variables.Do_Fall = message.data.Do_Fall;
                    variables.Do_Squat = message.data.Do_Squat;
                    variables.Do_Fly = message.data.Do_Fly;
                    variables.Do_TPose = message.data.Do_TPose;
                    variables.Do_Zombie = message.data.Do_Zombie;
                    variables.Do_Dab = message.data.Do_Dab;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean NearGround = true;
        public boolean Passive_Animations = true;
        public boolean Do_Naruto = true;
        public boolean Do_Fall = true;
        public boolean Do_Squat = true;
        public boolean Do_Fly = true;
        public boolean Do_TPose = false;
        public boolean Do_Zombie = false;
        public boolean Do_Dab = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MjsAnimationsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("NearGround", this.NearGround);
            nbt.m_128379_("Passive_Animations", this.Passive_Animations);
            nbt.m_128379_("Do_Naruto", this.Do_Naruto);
            nbt.m_128379_("Do_Fall", this.Do_Fall);
            nbt.m_128379_("Do_Squat", this.Do_Squat);
            nbt.m_128379_("Do_Fly", this.Do_Fly);
            nbt.m_128379_("Do_TPose", this.Do_TPose);
            nbt.m_128379_("Do_Zombie", this.Do_Zombie);
            nbt.m_128379_("Do_Dab", this.Do_Dab);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.NearGround = nbt.m_128471_("NearGround");
            this.Passive_Animations = nbt.m_128471_("Passive_Animations");
            this.Do_Naruto = nbt.m_128471_("Do_Naruto");
            this.Do_Fall = nbt.m_128471_("Do_Fall");
            this.Do_Squat = nbt.m_128471_("Do_Squat");
            this.Do_Fly = nbt.m_128471_("Do_Fly");
            this.Do_TPose = nbt.m_128471_("Do_TPose");
            this.Do_Zombie = nbt.m_128471_("Do_Zombie");
            this.Do_Dab = nbt.m_128471_("Do_Dab");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("mjs_animations", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Passive_Animations = original.Passive_Animations;
            clone.Do_Naruto = original.Do_Naruto;
            clone.Do_Fall = original.Do_Fall;
            clone.Do_Squat = original.Do_Squat;
            clone.Do_Fly = original.Do_Fly;
            clone.Do_TPose = original.Do_TPose;
            clone.Do_Zombie = original.Do_Zombie;
            clone.Do_Dab = original.Do_Dab;
            if (!event.isWasDeath()) {
                clone.NearGround = original.NearGround;
            }
        }
    }
}

