/*
 * Decompiled with CFR 0.152.
 */
package net.cuckoo.adventuresandadversaries;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.cuckoo.adventuresandadversaries.AdventuresAndAdversariesMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class AdventuresAndAdversariesModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public AdventuresAndAdversariesModElements() {
        sounds.put(new ResourceLocation("adventures_and_adversaries", "risen_living"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "risen_living")));
        sounds.put(new ResourceLocation("adventures_and_adversaries", "risen_death"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "risen_death")));
        sounds.put(new ResourceLocation("adventures_and_adversaries", "risen_hurt"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "risen_hurt")));
        sounds.put(new ResourceLocation("adventures_and_adversaries", "ddanew"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "ddanew")));
        sounds.put(new ResourceLocation("adventures_and_adversaries", "darkestdepthsmood"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "darkestdepthsmood")));
        sounds.put(new ResourceLocation("adventures_and_adversaries", "mechanicalscouthurt"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "mechanicalscouthurt")));
        sounds.put(new ResourceLocation("adventures_and_adversaries", "mechanicalscoutdeath"), new SoundEvent(new ResourceLocation("adventures_and_adversaries", "mechanicalscoutdeath")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("adventures_and_adversaries").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        AdventuresAndAdversariesMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final AdventuresAndAdversariesModElements elements;
        protected final int sortid;

        public ModElement(AdventuresAndAdversariesModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

