/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.styve;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.styve.StyveMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class StyveModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public StyveModElements() {
        sounds.put(new ResourceLocation("styve", "deer_hurt"), new SoundEvent(new ResourceLocation("styve", "deer_hurt")));
        sounds.put(new ResourceLocation("styve", "deer_death"), new SoundEvent(new ResourceLocation("styve", "deer_death")));
        sounds.put(new ResourceLocation("styve", "midera_place"), new SoundEvent(new ResourceLocation("styve", "midera_place")));
        sounds.put(new ResourceLocation("styve", "midera_break"), new SoundEvent(new ResourceLocation("styve", "midera_break")));
        sounds.put(new ResourceLocation("styve", "stalite_ore_lava"), new SoundEvent(new ResourceLocation("styve", "stalite_ore_lava")));
        sounds.put(new ResourceLocation("styve", "midera_core_place"), new SoundEvent(new ResourceLocation("styve", "midera_core_place")));
        sounds.put(new ResourceLocation("styve", "extrial_portal_enter"), new SoundEvent(new ResourceLocation("styve", "extrial_portal_enter")));
        sounds.put(new ResourceLocation("styve", "tezmiress_place"), new SoundEvent(new ResourceLocation("styve", "tezmiress_place")));
        sounds.put(new ResourceLocation("styve", "fusskra_place"), new SoundEvent(new ResourceLocation("styve", "fusskra_place")));
        sounds.put(new ResourceLocation("styve", "snake_sand_place"), new SoundEvent(new ResourceLocation("styve", "snake_sand_place")));
        sounds.put(new ResourceLocation("styve", "ender_pearl_block_place"), new SoundEvent(new ResourceLocation("styve", "ender_pearl_block_place")));
        sounds.put(new ResourceLocation("styve", "end_sponge_pipe_poop"), new SoundEvent(new ResourceLocation("styve", "end_sponge_pipe_poop")));
        sounds.put(new ResourceLocation("styve", "steel_plate_step"), new SoundEvent(new ResourceLocation("styve", "steel_plate_step")));
        sounds.put(new ResourceLocation("styve", "paralyze"), new SoundEvent(new ResourceLocation("styve", "paralyze")));
        sounds.put(new ResourceLocation("styve", "skin_rip"), new SoundEvent(new ResourceLocation("styve", "skin_rip")));
        sounds.put(new ResourceLocation("styve", "bone_grow"), new SoundEvent(new ResourceLocation("styve", "bone_grow")));
        sounds.put(new ResourceLocation("styve", "egg_block_redstone"), new SoundEvent(new ResourceLocation("styve", "egg_block_redstone")));
        sounds.put(new ResourceLocation("styve", "music_disc_abyss"), new SoundEvent(new ResourceLocation("styve", "music_disc_abyss")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("styve").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        StyveMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final StyveModElements elements;
        protected final int sortid;

        public ModElement(StyveModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

