/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.multijumper.network;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.multijumper.MultijumperMod;
import net.mcreator.multijumper.procedures.OnJumpKeyPressedProcedure;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JumpKeyMessage {
    int type;
    int pressedms;

    public JumpKeyMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public JumpKeyMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(JumpKeyMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(JumpKeyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> JumpKeyMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.f_19853_;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!world.m_46805_(entity.m_142538_())) {
            return;
        }
        if (type == 0) {
            OnJumpKeyPressedProcedure.execute((Map<String, Object>)ImmutableMap.builder().put((Object)"entity", (Object)entity).put((Object)"world", (Object)world).build());
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MultijumperMod.addNetworkMessage(JumpKeyMessage.class, JumpKeyMessage::buffer, JumpKeyMessage::new, JumpKeyMessage::handler);
    }
}

