/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.multijumper.network;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.multijumper.MultijumperMod;
import net.mcreator.multijumper.client.gui.SetupGUIScreen;
import net.mcreator.multijumper.procedures.CloseIntroGUIProcedure;
import net.mcreator.multijumper.procedures.RequireEnchantmentsProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SetupGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SetupGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SetupGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SetupGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SetupGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SetupGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = SetupGUIScreen.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RequireEnchantmentsProcedure.execute((Map<String, Object>)ImmutableMap.builder().put((Object)"entity", (Object)entity).put((Object)"world", (Object)world).build());
        }
        if (buttonID == 1) {
            CloseIntroGUIProcedure.execute((Map<String, Object>)ImmutableMap.builder().put((Object)"entity", (Object)entity).put((Object)"world", (Object)world).build());
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MultijumperMod.addNetworkMessage(SetupGUIButtonMessage.class, SetupGUIButtonMessage::buffer, SetupGUIButtonMessage::new, SetupGUIButtonMessage::handler);
    }
}

