/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.variousworld.entity;

import java.util.Random;
import java.util.Set;
import net.mcreator.variousworld.init.VariousWorldModEntities;
import net.mcreator.variousworld.procedures.ZombieOfStonyMagmaEntityDiesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ZombieOfStonyMagmaEntity
extends Monster {
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("various_world:caverns_of_magma_growth"));

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        if (SPAWN_BIOMES.contains(event.getName())) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)VariousWorldModEntities.ZOMBIE_OF_STONY_MAGMA.get(), 10, 1, 2));
        }
    }

    public ZombieOfStonyMagmaEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ZombieOfStonyMagmaEntity>)((EntityType)VariousWorldModEntities.ZOMBIE_OF_STONY_MAGMA.get()), world);
    }

    public ZombieOfStonyMagmaEntity(EntityType<ZombieOfStonyMagmaEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.m_21557_(false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            protected double m_6639_(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 16.0f, 4.0f));
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("various_world:various_sound_of_zombie"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.basalt.hit"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.lava.pop"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19320_) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        ZombieOfStonyMagmaEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)VariousWorldModEntities.ZOMBIE_OF_STONY_MAGMA.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random) && Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        return builder;
    }
}

