/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.variousworld.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.mcreator.variousworld.init.VariousWorldModBlocks;
import net.mcreator.variousworld.world.biome.CavernofDeepBiome;
import net.mcreator.variousworld.world.biome.CavernsOfMagmaGrowthBiome;
import net.mcreator.variousworld.world.biome.CrystalicforestBiome;
import net.mcreator.variousworld.world.biome.PeacefulWastelandBiome;
import net.mcreator.variousworld.world.biome.SculkValleyBiome;
import net.mcreator.variousworld.world.biome.ShinyValleyBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VariousWorldModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"various_world");
    public static final RegistryObject<Biome> CRYSTALICFOREST = REGISTRY.register("crystalicforest", () -> CrystalicforestBiome.createBiome());
    public static final RegistryObject<Biome> PEACEFUL_WASTELAND = REGISTRY.register("peaceful_wasteland", () -> PeacefulWastelandBiome.createBiome());
    public static final RegistryObject<Biome> SCULK_VALLEY = REGISTRY.register("sculk_valley", () -> SculkValleyBiome.createBiome());
    public static final RegistryObject<Biome> SHINY_VALLEY = REGISTRY.register("shiny_valley", () -> ShinyValleyBiome.createBiome());
    public static final RegistryObject<Biome> CAVERNOF_DEEP = REGISTRY.register("cavernof_deep", () -> CavernofDeepBiome.createBiome());
    public static final RegistryObject<Biome> CAVERNS_OF_MAGMA_GROWTH = REGISTRY.register("caverns_of_magma_growth", () -> CavernsOfMagmaGrowthBiome.createBiome());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CrystalicforestBiome.init();
            PeacefulWastelandBiome.init();
            SculkValleyBiome.init();
            ShinyValleyBiome.init();
            CavernofDeepBiome.init();
            CavernsOfMagmaGrowthBiome.init();
        });
    }

    @Mod.EventBusSubscriber
    public static class BiomeInjector {
        @SubscribeEvent
        public static void onServerAboutToStart(ServerAboutToStartEvent event) {
            MinecraftServer server = event.getServer();
            Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
            Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
            WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
            for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
                DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
                if (dimensionType != dimensionTypeRegistry.m_123013_(DimensionType.f_63845_)) continue;
                ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                BiomeSource biomeSource = chunkGenerator.m_62218_();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                    parameters.add(new Pair((Object)CrystalicforestBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CRYSTALICFOREST.getId()))));
                    parameters.add(new Pair((Object)PeacefulWastelandBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PEACEFUL_WASTELAND.getId()))));
                    parameters.add(new Pair((Object)SculkValleyBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SCULK_VALLEY.getId()))));
                    parameters.add(new Pair((Object)ShinyValleyBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHINY_VALLEY.getId()))));
                    parameters.add(new Pair((Object)CavernsOfMagmaGrowthBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CAVERNS_OF_MAGMA_GROWTH.getId()))));
                    parameters.add(new Pair((Object)CavernofDeepBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CAVERNOF_DEEP.getId()))));
                    parameters.add(new Pair((Object)CavernsOfMagmaGrowthBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CAVERNS_OF_MAGMA_GROWTH.getId()))));
                    MultiNoiseBiomeSource moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                    chunkGenerator.f_62137_ = moddedNoiseSource;
                    chunkGenerator.f_62138_ = moddedNoiseSource;
                }
                if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
                NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.f_188871_();
                if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
                SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
                surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CAVERNOF_DEEP.getId()), ((Block)VariousWorldModBlocks.DEEP_MOSS.get()).m_49966_(), Blocks.f_50730_.m_49966_(), Blocks.f_50730_.m_49966_()));
                surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CAVERNS_OF_MAGMA_GROWTH.getId()), ((Block)VariousWorldModBlocks.BLACKLY_STONY_MAGMA.get()).m_49966_(), Blocks.f_50730_.m_49966_(), Blocks.f_50730_.m_49966_()));
                surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CRYSTALICFOREST.getId()), ((Block)VariousWorldModBlocks.CRYSTALIC_GRASS.get()).m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()));
                surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PEACEFUL_WASTELAND.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50546_.m_49966_(), Blocks.f_49992_.m_49966_()));
                surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SCULK_VALLEY.getId()), ((Block)VariousWorldModBlocks.SCULK_GRASS.get()).m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()));
                surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHINY_VALLEY.getId()), ((Block)VariousWorldModBlocks.SHINY_GRASS.get()).m_49966_(), ((Block)VariousWorldModBlocks.GNEISS.get()).m_49966_(), ((Block)VariousWorldModBlocks.GNEISS.get()).m_49966_()));
                surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CAVERNS_OF_MAGMA_GROWTH.getId()), ((Block)VariousWorldModBlocks.BLACKLY_STONY_MAGMA.get()).m_49966_(), Blocks.f_50730_.m_49966_(), Blocks.f_50730_.m_49966_()));
                NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
            }
        }

        private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))})));
        }

        private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
        }
    }
}

