/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.variousworld.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;

public class MagicVinesBlock
extends Block
implements IForgeShearable {
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MagicVinesBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76274_, (MaterialColor)MaterialColor.f_76417_).m_60918_(SoundType.f_56760_).m_60913_(0.15f, 5.0f).m_60953_(s -> 5).m_60910_().m_60955_().m_60982_((bs, br, bp) -> true).m_60991_((bs, br, bp) -> true).m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), MagicVinesBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_57906_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_57906_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_57906_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    public VoxelShape m_5940_(BlockState p_57897_, BlockGetter p_57898_, BlockPos p_57899_, CollisionContext p_57900_) {
        return this.shapesCache.get(p_57897_);
    }

    public boolean m_7420_(BlockState p_181239_, BlockGetter p_181240_, BlockPos p_181241_) {
        return true;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean m_7898_(BlockState p_57861_, LevelReader p_57862_, BlockPos p_57863_) {
        return this.hasFaces(this.getUpdatedState(p_57861_, (BlockGetter)p_57862_, p_57863_));
    }

    private boolean hasFaces(BlockState p_57908_) {
        return this.countFaces(p_57908_) > 0;
    }

    private int countFaces(BlockState p_57910_) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)p_57910_.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter p_57888_, BlockPos p_57889_, Direction p_57890_) {
        if (p_57890_ == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = p_57889_.m_121945_(p_57890_);
        if (MagicVinesBlock.isAcceptableNeighbour(p_57888_, blockpos, p_57890_)) {
            return true;
        }
        if (p_57890_.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(p_57890_);
        BlockState blockstate = p_57888_.m_8055_(p_57889_.m_7494_());
        return blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter p_57854_, BlockPos p_57855_, Direction p_57856_) {
        return MultifaceBlock.m_153829_((BlockGetter)p_57854_, (Direction)p_57856_, (BlockPos)p_57855_, (BlockState)p_57854_.m_8055_(p_57855_));
    }

    private BlockState getUpdatedState(BlockState p_57902_, BlockGetter p_57903_, BlockPos p_57904_) {
        BlockPos blockpos = p_57904_.m_7494_();
        if (((Boolean)p_57902_.m_61143_((Property)UP)).booleanValue()) {
            p_57902_ = (BlockState)p_57902_.m_61124_((Property)UP, (Comparable)Boolean.valueOf(MagicVinesBlock.isAcceptableNeighbour(p_57903_, blockpos, Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = MagicVinesBlock.getPropertyForFace(direction);
            if (!((Boolean)p_57902_.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(p_57903_, p_57904_, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = p_57903_.m_8055_(blockpos);
                }
                flag = blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            p_57902_ = (BlockState)p_57902_.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return p_57902_;
    }

    public BlockState m_7417_(BlockState p_57875_, Direction p_57876_, BlockState p_57877_, LevelAccessor p_57878_, BlockPos p_57879_, BlockPos p_57880_) {
        if (p_57876_ == Direction.DOWN) {
            return super.m_7417_(p_57875_, p_57876_, p_57877_, p_57878_, p_57879_, p_57880_);
        }
        BlockState blockstate = this.getUpdatedState(p_57875_, (BlockGetter)p_57878_, p_57879_);
        return !this.hasFaces(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    public void m_213898_(BlockState p_222655_, ServerLevel p_222656_, BlockPos p_222657_, RandomSource p_222658_) {
        if (p_222656_.f_46441_.m_188503_(4) == 0 && p_222656_.isAreaLoaded(p_222657_, 4)) {
            Direction direction = Direction.m_235672_((RandomSource)p_222658_);
            BlockPos blockpos = p_222657_.m_7494_();
            if (direction.m_122434_().m_122479_() && !((Boolean)p_222655_.m_61143_((Property)MagicVinesBlock.getPropertyForFace(direction))).booleanValue()) {
                if (this.canSpread((BlockGetter)p_222656_, p_222657_)) {
                    BlockPos blockpos4 = p_222657_.m_121945_(direction);
                    BlockState blockstate4 = p_222656_.m_8055_(blockpos4);
                    if (blockstate4.m_60795_()) {
                        Direction direction3 = direction.m_122427_();
                        Direction direction4 = direction.m_122428_();
                        boolean flag = (Boolean)p_222655_.m_61143_((Property)MagicVinesBlock.getPropertyForFace(direction3));
                        boolean flag1 = (Boolean)p_222655_.m_61143_((Property)MagicVinesBlock.getPropertyForFace(direction4));
                        BlockPos blockpos2 = blockpos4.m_121945_(direction3);
                        BlockPos blockpos3 = blockpos4.m_121945_(direction4);
                        if (flag && MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, blockpos2, direction3)) {
                            p_222656_.m_7731_(blockpos4, (BlockState)this.m_49966_().m_61124_((Property)MagicVinesBlock.getPropertyForFace(direction3), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (flag1 && MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, blockpos3, direction4)) {
                            p_222656_.m_7731_(blockpos4, (BlockState)this.m_49966_().m_61124_((Property)MagicVinesBlock.getPropertyForFace(direction4), (Comparable)Boolean.valueOf(true)), 2);
                        } else {
                            Direction direction1 = direction.m_122424_();
                            if (flag && p_222656_.m_46859_(blockpos2) && MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, p_222657_.m_121945_(direction3), direction1)) {
                                p_222656_.m_7731_(blockpos2, (BlockState)this.m_49966_().m_61124_((Property)MagicVinesBlock.getPropertyForFace(direction1), (Comparable)Boolean.valueOf(true)), 2);
                            } else if (flag1 && p_222656_.m_46859_(blockpos3) && MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, p_222657_.m_121945_(direction4), direction1)) {
                                p_222656_.m_7731_(blockpos3, (BlockState)this.m_49966_().m_61124_((Property)MagicVinesBlock.getPropertyForFace(direction1), (Comparable)Boolean.valueOf(true)), 2);
                            } else if ((double)p_222658_.m_188501_() < 0.05 && MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, blockpos4.m_7494_(), Direction.UP)) {
                                p_222656_.m_7731_(blockpos4, (BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    } else if (MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, blockpos4, direction)) {
                        p_222656_.m_7731_(p_222657_, (BlockState)p_222655_.m_61124_((Property)MagicVinesBlock.getPropertyForFace(direction), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else {
                BlockState blockstate2;
                BlockState blockstate1;
                BlockPos blockpos1;
                BlockState blockstate;
                if (direction == Direction.UP && p_222657_.m_123342_() < p_222656_.m_151558_() - 1) {
                    if (this.canSupportAtFace((BlockGetter)p_222656_, p_222657_, direction)) {
                        p_222656_.m_7731_(p_222657_, (BlockState)p_222655_.m_61124_((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                    if (p_222656_.m_46859_(blockpos)) {
                        if (!this.canSpread((BlockGetter)p_222656_, p_222657_)) {
                            return;
                        }
                        BlockState blockstate3 = p_222655_;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!p_222658_.m_188499_() && MagicVinesBlock.isAcceptableNeighbour((BlockGetter)p_222656_, blockpos.m_121945_(direction2), direction2)) continue;
                            blockstate3 = (BlockState)blockstate3.m_61124_((Property)MagicVinesBlock.getPropertyForFace(direction2), (Comparable)Boolean.valueOf(false));
                        }
                        if (this.hasHorizontalConnection(blockstate3)) {
                            p_222656_.m_7731_(blockpos, blockstate3, 2);
                        }
                        return;
                    }
                }
                if (p_222657_.m_123342_() > p_222656_.m_141937_() && ((blockstate = p_222656_.m_8055_(blockpos1 = p_222657_.m_7495_())).m_60795_() || blockstate.m_60713_((Block)this)) && (blockstate1 = blockstate.m_60795_() ? this.m_49966_() : blockstate) != (blockstate2 = this.copyRandomFaces(p_222655_, blockstate1, p_222658_)) && this.hasHorizontalConnection(blockstate2)) {
                    p_222656_.m_7731_(blockpos1, blockstate2, 2);
                }
            }
        }
    }

    private BlockState copyRandomFaces(BlockState p_222651_, BlockState p_222652_, RandomSource p_222653_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_222653_.m_188499_() || !((Boolean)p_222651_.m_61143_((Property)(booleanproperty = MagicVinesBlock.getPropertyForFace(direction)))).booleanValue()) continue;
            p_222652_ = (BlockState)p_222652_.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return p_222652_;
    }

    private boolean hasHorizontalConnection(BlockState p_57912_) {
        return (Boolean)p_57912_.m_61143_((Property)NORTH) != false || (Boolean)p_57912_.m_61143_((Property)EAST) != false || (Boolean)p_57912_.m_61143_((Property)SOUTH) != false || (Boolean)p_57912_.m_61143_((Property)WEST) != false;
    }

    private boolean canSpread(BlockGetter p_57851_, BlockPos p_57852_) {
        int i = 4;
        Iterable iterable = BlockPos.m_121976_((int)(p_57852_.m_123341_() - 4), (int)(p_57852_.m_123342_() - 1), (int)(p_57852_.m_123343_() - 4), (int)(p_57852_.m_123341_() + 4), (int)(p_57852_.m_123342_() + 1), (int)(p_57852_.m_123343_() + 4));
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (!p_57851_.m_8055_(blockpos).m_60713_((Block)this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    public boolean m_6864_(BlockState p_57858_, BlockPlaceContext p_57859_) {
        BlockState blockstate = p_57859_.m_43725_().m_8055_(p_57859_.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return this.countFaces(blockstate) < PROPERTY_BY_DIRECTION.size();
        }
        return super.m_6864_(p_57858_, p_57859_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_57849_) {
        BlockState blockstate = p_57849_.m_43725_().m_8055_(p_57849_.m_8083_());
        boolean flag = blockstate.m_60713_((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.m_49966_();
        for (Direction direction : p_57849_.m_6232_()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = MagicVinesBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)p_57849_.m_43725_(), p_57849_.m_8083_(), direction)) continue;
            return (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57882_) {
        p_57882_.m_61104_(new Property[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState m_6843_(BlockState p_57868_, Rotation p_57869_) {
        switch (p_57869_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_57868_.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57868_.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_57868_.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57868_.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_57868_.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57868_.m_61143_((Property)SOUTH)));
            }
        }
        return p_57868_;
    }

    public BlockState m_6943_(BlockState p_57865_, Mirror p_57866_) {
        switch (p_57866_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_57865_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57865_.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57865_.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_57865_.m_61124_((Property)EAST, (Comparable)((Boolean)p_57865_.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57865_.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(p_57865_, p_57866_);
    }

    public static BooleanProperty getPropertyForFace(Direction p_57884_) {
        return PROPERTY_BY_DIRECTION.get(p_57884_);
    }
}

