/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.variousworld.entity;

import net.mcreator.variousworld.init.VariousWorldModBlocks;
import net.mcreator.variousworld.init.VariousWorldModEntities;
import net.mcreator.variousworld.init.VariousWorldModItems;
import net.mcreator.variousworld.procedures.CrystalWarriorEntityDiesProcedure;
import net.mcreator.variousworld.procedures.CrystalWarriorEntityIsHurtProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class CrystalWarriorEntity
extends IronGolem {
    public AnimationState attackAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_10);

    public CrystalWarriorEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<CrystalWarriorEntity>)((EntityType)VariousWorldModEntities.CRYSTAL_WARRIOR.get()), world);
    }

    static boolean hurtAndThrowTarget(LivingEntity p_34643_, LivingEntity p_34644_) {
        float f = (float)p_34643_.m_21133_(Attributes.f_22281_);
        boolean flag = p_34644_.m_6469_(p_34643_.m_269291_().m_269333_(p_34643_), f);
        if (flag) {
            p_34643_.m_19970_(p_34643_, (Entity)p_34644_);
            if (!p_34643_.m_6162_()) {
                CrystalWarriorEntity.throwTarget(p_34643_, p_34644_);
                CrystalWarriorEntity.throwTarget(p_34643_, p_34644_);
            }
        }
        return flag;
    }

    private boolean isMovingOnLand() {
        return this.f_19861_ && this.m_20184_().m_165925_() > 1.0E-6;
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            if (this.isMovingOnLand()) {
                this.walkAnimationState.m_216982_(this.f_19797_);
            } else {
                this.walkAnimationState.m_216973_();
            }
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12057_, 1.0f, this.m_6100_());
        return CrystalWarriorEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)p_34491_);
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ >= 4 && p_219360_ <= 20) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_219360_);
        }
    }

    static void throwTarget(LivingEntity p_34646_, LivingEntity p_34647_) {
        double d1;
        double d0 = p_34646_.m_21133_(Attributes.f_22282_);
        double d2 = 0.5 + d0 - (d1 = p_34647_.m_21133_(Attributes.f_22278_));
        if (!(d2 <= 0.0)) {
            double d3 = p_34647_.m_20185_() - p_34646_.m_20185_();
            double d4 = p_34647_.m_20189_() - p_34646_.m_20189_();
            float f = p_34646_.f_19853_.f_46441_.m_188503_(21) - 8;
            double d5 = d2 * (double)(p_34646_.f_19853_.f_46441_.m_188501_() * 0.75f + 0.25f);
            Vec3 vec3 = new Vec3(d3, 0.0, d4).m_82541_().m_82490_(d5).m_82524_(f);
            double d6 = d2 * (double)p_34646_.f_19853_.f_46441_.m_188501_() * 0.5;
            p_34647_.m_5997_(vec3.f_82479_, d6, vec3.f_82481_);
            p_34647_.f_19864_ = true;
        }
    }

    public CrystalWarriorEntity(EntityType<CrystalWarriorEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 15;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Crystal Warrior"));
        this.m_20340_(true);
        this.m_21530_();
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)VariousWorldModItems.CRYSTAL_SWORD.get()));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(8, (Goal)new RemoveBlockGoal(Blocks.f_50493_, (PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(9, (Goal)new RemoveBlockGoal(Blocks.f_50069_, (PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(10, (Goal)new RemoveBlockGoal(Blocks.f_50652_, (PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(11, (Goal)new RemoveBlockGoal((Block)VariousWorldModBlocks.ROSE_QUARTZ.get(), (PathfinderMob)this, 1.0, 3));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)VariousWorldModItems.CRYSTAL_GEM.get()));
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.elder_guardian.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.large_amethyst_bud.break")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.elder_guardian.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        CrystalWarriorEntityIsHurtProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this, source.m_7639_());
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268669_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        CrystalWarriorEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 400.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        builder = builder.m_22268_(Attributes.f_22282_, 1.5);
        return builder;
    }
}

