/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.variousworld.entity;

import java.util.EnumSet;
import java.util.Random;
import net.mcreator.variousworld.init.VariousWorldModEntities;
import net.mcreator.variousworld.procedures.FuryLordEntityDiesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class FuryLordEntity
extends Monster {
    private float speedFactor = 0.8f;
    private double speedModifier = 1.0;
    private static final EntityDataAccessor<Boolean> DATA_IS_ADVANCED = SynchedEntityData.m_135353_(FuryLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int explosionPower = 2;
    private static int attackAnimationRemainingTicks;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState idleInAirAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_10);

    public FuryLordEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FuryLordEntity>)((EntityType)VariousWorldModEntities.FURY_LORD.get()), world);
    }

    public boolean isAdvanced() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_ADVANCED);
    }

    public void setAdvanced(boolean p_32759_) {
        this.f_19804_.m_135381_(DATA_IS_ADVANCED, (Object)p_32759_);
        this.f_21342_ = this.isAdvanced() ? new FlyingMoveControl((Mob)this, 36, true) : new FlyingMoveControl((Mob)this, 25, true);
    }

    public FuryLordEntity(EntityType<FuryLordEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 30;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"\u00a75Fury Lord"));
        this.m_20340_(true);
        this.m_21530_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 25, true);
    }

    private boolean isMovingInAir() {
        return !this.f_19861_ && this.m_20184_().m_165925_() > 1.0E-6;
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            if (this.isMovingInAir()) {
                this.flyAnimationState.m_216982_(this.f_19797_);
                this.idleInAirAnimationState.m_216973_();
            } else {
                this.flyAnimationState.m_216973_();
                this.idleInAirAnimationState.m_216982_(this.f_19797_);
            }
        }
        if (this.m_21223_() < this.m_21233_() / 2.0f) {
            this.speedModifier = 1.5;
            this.explosionPower = 3;
            this.speedFactor = 1.0f;
            this.setAdvanced(true);
        } else {
            this.speedModifier = 1.0;
            this.explosionPower = 2;
            this.speedFactor = 0.8f;
            this.setAdvanced(false);
        }
        super.m_8119_();
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ >= 4 && p_219360_ <= 24) {
            int randomAttack = (int)Math.round(Math.random());
            if (randomAttack == 0) {
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attack1AnimationState.m_216977_(this.f_19797_);
            }
        } else {
            super.m_7822_(p_219360_);
        }
    }

    public boolean m_7327_(Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_11896_, 1.0f, this.m_6100_());
        return FuryLordEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)p_34491_);
    }

    static boolean hurtAndThrowTarget(LivingEntity p_34643_, LivingEntity p_34644_) {
        float f = (float)p_34643_.m_21133_(Attributes.f_22281_);
        return p_34644_.m_6469_(p_34643_.m_269291_().m_269333_(p_34643_), f);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean p_32759_) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)p_32759_);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    public int getAttackAnimationRemainingTicks() {
        return attackAnimationRemainingTicks;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_ADVANCED, (Object)false);
    }

    public void m_8107_() {
        if (attackAnimationRemainingTicks > 0) {
            --attackAnimationRemainingTicks;
        }
        this.m_20242_(true);
        super.m_8107_();
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return FuryLordEntity.this.m_5448_() != null && !FuryLordEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return FuryLordEntity.this.m_21566_().m_24995_() && FuryLordEntity.this.m_5448_() != null && FuryLordEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = FuryLordEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                FuryLordEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 2.5 * FuryLordEntity.this.speedModifier);
            }

            public void m_8037_() {
                LivingEntity livingentity = FuryLordEntity.this.m_5448_();
                if (FuryLordEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    FuryLordEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = FuryLordEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 32.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        FuryLordEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 2.5 * FuryLordEntity.this.speedModifier);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, this.speedFactor, 25){

            protected Vec3 m_7037_() {
                RandomSource random = FuryLordEntity.this.m_217043_();
                double dir_x = FuryLordEntity.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 32.0f);
                double dir_y = FuryLordEntity.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 32.0f);
                double dir_z = FuryLordEntity.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 32.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.f_21345_.m_25352_(5, (Goal)new FuryLordShootFireballGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player && Math.random() < 0.5) {
            Random random = new Random();
            int randomAttack = (int)Math.round(Math.random());
            if (randomAttack == 0) {
                source.m_7639_().m_20254_(20);
            } else if (randomAttack == 1 && source.m_7639_().m_20280_((Entity)this) < 4096.0 && this.m_142582_(source.m_7639_())) {
                source.m_7639_().m_6034_(this.m_20185_() + (double)random.nextInt(1), this.m_20186_(), this.m_20189_() + (double)random.nextInt(1));
            }
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        FuryLordEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.5);
        builder = builder.m_22268_(Attributes.f_22276_, 500.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 3.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        builder = builder.m_22268_(Attributes.f_22280_, 1.2);
        return builder;
    }

    static {
        DATA_IS_CHARGING = SynchedEntityData.m_135353_(FuryLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    static class FuryLordShootFireballGoal
    extends Goal {
        private final FuryLordEntity ghast;
        public int chargeTime;

        public FuryLordShootFireballGoal(FuryLordEntity p_32776_) {
            this.ghast = p_32776_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            if (livingentity != null) {
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.ghast) < 4096.0 && this.ghast.m_142582_((Entity)livingentity)) {
                    Level level = this.ghast.f_19853_;
                    ++this.chargeTime;
                    if (this.chargeTime == 20 && !this.ghast.m_20067_()) {
                        level.m_5898_(null, 1015, this.ghast.m_20183_(), 0);
                    }
                    if (this.ghast.isAdvanced()) {
                        if (this.chargeTime == 60) {
                            double d1 = 4.0;
                            Vec3 vec3 = this.ghast.m_20252_(1.0f);
                            double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vec3.f_82479_ * 4.0);
                            double d3 = livingentity.m_20227_(0.5) - (0.5 + this.ghast.m_20227_(0.5));
                            double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vec3.f_82481_ * 4.0);
                            if (!this.ghast.m_20067_()) {
                                level.m_5898_(null, 1016, this.ghast.m_20183_(), 0);
                            }
                            LargeFireball largefireball = new LargeFireball(level, (LivingEntity)this.ghast, d2, d3, d4, this.ghast.getExplosionPower());
                            largefireball.m_6034_(this.ghast.m_20185_() + vec3.f_82479_ * 4.0, this.ghast.m_20227_(0.5) + 0.5, largefireball.m_20189_() + vec3.f_82481_ * 4.0);
                            level.m_7967_((Entity)largefireball);
                            this.chargeTime = -60;
                            attackAnimationRemainingTicks = 30;
                        }
                    } else if (this.chargeTime == 80) {
                        double d1 = 4.0;
                        Vec3 vec3 = this.ghast.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vec3.f_82479_ * 4.0);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.ghast.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vec3.f_82481_ * 4.0);
                        if (!this.ghast.m_20067_()) {
                            level.m_5898_(null, 1016, this.ghast.m_20183_(), 0);
                        }
                        LargeFireball largefireball = new LargeFireball(level, (LivingEntity)this.ghast, d2, d3, d4, this.ghast.getExplosionPower());
                        largefireball.m_6034_(this.ghast.m_20185_() + vec3.f_82479_ * 4.0, this.ghast.m_20227_(0.5) + 0.5, largefireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)largefireball);
                        this.chargeTime = -80;
                        attackAnimationRemainingTicks = 30;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ghast.setCharging(this.chargeTime > 20);
            }
        }
    }
}

