/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.sashakyotoz.variousworld.init.VariousWorldModBlockEntities;
import net.sashakyotoz.variousworld.init.VariousWorldModBlocks;
import net.sashakyotoz.variousworld.init.VariousWorldModEnchantments;
import net.sashakyotoz.variousworld.init.VariousWorldModEntities;
import net.sashakyotoz.variousworld.init.VariousWorldModFeatures;
import net.sashakyotoz.variousworld.init.VariousWorldModItems;
import net.sashakyotoz.variousworld.init.VariousWorldModMenus;
import net.sashakyotoz.variousworld.init.VariousWorldModMobEffects;
import net.sashakyotoz.variousworld.init.VariousWorldModPaintings;
import net.sashakyotoz.variousworld.init.VariousWorldModParticleTypes;
import net.sashakyotoz.variousworld.init.VariousWorldModSounds;
import net.sashakyotoz.variousworld.init.VariousWorldModTabs;
import net.sashakyotoz.variousworld.init.VariousWorldModVillagerProfessions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="various_world")
public class VariousWorldMod {
    public static final Logger LOGGER = LogManager.getLogger(VariousWorldMod.class);
    public static final String MODID = "various_world";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("various_world", "various_world"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public VariousWorldMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        VariousWorldModSounds.init();
        VariousWorldModBlocks.REGISTRY.register(bus);
        VariousWorldModItems.REGISTRY.register(bus);
        VariousWorldModEntities.REGISTRY.register(bus);
        VariousWorldModBlockEntities.REGISTRY.register(bus);
        VariousWorldModEnchantments.REGISTRY.register(bus);
        VariousWorldModPaintings.REGISTRY.register(bus);
        VariousWorldModParticleTypes.REGISTRY.register(bus);
        VariousWorldModMobEffects.REGISTRY.register(bus);
        VariousWorldModTabs.CREATIVE_MODE_TABS.register(bus);
        VariousWorldModMenus.REGISTRY.register(bus);
        VariousWorldModFeatures.REGISTRY.register(bus);
        VariousWorldModVillagerProfessions.PROFESSIONS.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

