/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.sashakyotoz.variousworld.init.VariousWorldModEntities;
import net.sashakyotoz.variousworld.procedures.CrystalicBowProjectileHitsLivingEntityProcedure;
import net.sashakyotoz.variousworld.procedures.CrystalicBowWhileProjectileFlyingTickProcedure;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class CrystalicBowEntity
extends AbstractArrow
implements ItemSupplier {
    public CrystalicBowEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)VariousWorldModEntities.CRYSTALIC_BOW.get(), world);
    }

    public CrystalicBowEntity(EntityType<? extends CrystalicBowEntity> type, Level world) {
        super(type, world);
    }

    public CrystalicBowEntity(EntityType<? extends CrystalicBowEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Blocks.f_50016_);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        CrystalicBowProjectileHitsLivingEntityProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), entityHitResult.m_82443_());
    }

    public void m_8119_() {
        super.m_8119_();
        CrystalicBowWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public static CrystalicBowEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        int k;
        int j;
        CrystalicBowEntity entityarrow = new CrystalicBowEntity((EntityType<? extends CrystalicBowEntity>)((EntityType)VariousWorldModEntities.CRYSTALIC_BOW.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 1.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)entity.m_21205_()) > 0) {
            entityarrow.m_20254_(100);
        }
        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)entity.m_21205_())) > 0) {
            entityarrow.m_36781_(entityarrow.m_36789_() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)entity.m_21205_())) > 0) {
            entityarrow.m_36735_(k);
        }
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static CrystalicBowEntity shoot(LivingEntity entity, LivingEntity target) {
        int k;
        int j;
        CrystalicBowEntity entityarrow = new CrystalicBowEntity((EntityType<? extends CrystalicBowEntity>)((EntityType)VariousWorldModEntities.CRYSTALIC_BOW.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(4.0);
        entityarrow.m_36735_(2);
        entityarrow.m_36762_(false);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)entity.m_21205_()) > 0) {
            entityarrow.m_20254_(100);
        }
        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)entity.m_21205_())) > 0) {
            entityarrow.m_36781_(entityarrow.m_36789_() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)entity.m_21205_())) > 0) {
            entityarrow.m_36735_(k);
        }
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

