/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.sashakyotoz.variousworld.VariousWorldMod;
import net.sashakyotoz.variousworld.entity.ArmoredskeletonEntity;
import net.sashakyotoz.variousworld.entity.CrystalWarriorEntity;
import net.sashakyotoz.variousworld.entity.NecromancerStaffEntity;
import net.sashakyotoz.variousworld.entity.SculkScytheRangedItemEntity;
import net.sashakyotoz.variousworld.entity.SculkSkeletonEntity;
import net.sashakyotoz.variousworld.init.VariousWorldModEntities;
import net.sashakyotoz.variousworld.init.VariousWorldModItems;
import net.sashakyotoz.variousworld.procedures.SculkNecromancerSkeletonEntityDiesProcedure;

public class SculkNecromancerSkeletonEntity
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_SUMMON_COOLDOWN = SynchedEntityData.m_135353_(SculkNecromancerSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState attackAnimationState = new AnimationState();
    public static int attackAnimationRemainingTicks;
    public final AnimationState walkAnimationState = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_10);

    public SculkNecromancerSkeletonEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SculkNecromancerSkeletonEntity>)((EntityType)VariousWorldModEntities.SCULK_NECROMANCER_SKELETON.get()), world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SUMMON_COOLDOWN, (Object)0);
    }

    public int summonCooldown() {
        return (Integer)this.f_19804_.m_135370_(DATA_SUMMON_COOLDOWN);
    }

    public void setSummonCooldown(int p_32759_) {
        this.f_19804_.m_135381_(DATA_SUMMON_COOLDOWN, (Object)p_32759_);
    }

    public int getAttackAnimationRemainingTicks() {
        return attackAnimationRemainingTicks;
    }

    public boolean m_7327_(Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        attackAnimationRemainingTicks = 30;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_11865_, 1.0f, this.m_6100_());
        return CrystalWarriorEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)p_34491_);
    }

    public void m_7822_(byte p_34496_) {
        if (p_34496_ == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
            this.m_5496_(SoundEvents.f_11865_, 1.0f, this.m_6100_());
        } else {
            super.m_7822_(p_34496_);
        }
    }

    public SculkNecromancerSkeletonEntity(EntityType<SculkNecromancerSkeletonEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 20;
        this.m_21557_(false);
        this.m_21530_();
        int randomAttack = (int)Math.round(Math.random());
        if (randomAttack == 0) {
            this.m_21468_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)VariousWorldModItems.NECROMANCER_WAND.get()));
        } else {
            this.m_21468_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)VariousWorldModItems.SCULK_SCYTHE.get()));
        }
    }

    private boolean isMovingOnLand() {
        return this.m_20096_() && this.m_20184_().m_165925_() > 1.0E-6;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.isMovingOnLand()) {
                this.walkAnimationState.m_216982_(this.f_19797_);
            } else {
                this.walkAnimationState.m_216973_();
            }
        }
        super.m_8119_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected double m_6639_(LivingEntity entity) {
                return (double)(this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_()) + 4.0;
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, ArmoredskeletonEntity.class, false, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new SculkNecromancerSkeletonAbility(this));
        this.f_21345_.m_25352_(8, (Goal)new NecromancerSummonSpellGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_6504_(LivingEntity target, float flval) {
        int attackVariant = (int)Math.round(Math.random());
        if (attackVariant == 0) {
            SculkScytheRangedItemEntity.shoot((LivingEntity)this, target);
        } else {
            NecromancerStaffEntity.shoot((LivingEntity)this, target);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.skeleton.step"))), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sculk_sensor.clicking"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.setSummonCooldown(this.summonCooldown() + (int)(Math.random() * 20.0));
        VariousWorldMod.LOGGER.debug("" + this.summonCooldown());
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        SculkNecromancerSkeletonEntityDiesProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 350.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        return builder;
    }

    static class SculkNecromancerSkeletonAbility
    extends Goal {
        private final SculkNecromancerSkeletonEntity skeleton;
        private int attackTime = 0;
        float f1 = Mth.m_14036_((float)0.15f, (float)0.1f, (float)1.0f);

        public SculkNecromancerSkeletonAbility(SculkNecromancerSkeletonEntity p_32776_) {
            this.skeleton = p_32776_;
        }

        public boolean m_8036_() {
            return this.skeleton.m_5448_() != null && this.skeleton.summonCooldown() < 80;
        }

        public void m_8056_() {
            attackAnimationRemainingTicks = 0;
        }

        public void m_8041_() {
            attackAnimationRemainingTicks = 0;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.skeleton.m_5448_();
            if (livingentity != null) {
                if (livingentity.m_20280_((Entity)this.skeleton) < 4096.0 && this.skeleton.m_142582_((Entity)livingentity)) {
                    if (this.attackTime == 30) {
                        this.attackTime = 0;
                        this.skeleton.m_6504_(livingentity, this.f1);
                    } else if (this.attackTime < 30) {
                        ++this.attackTime;
                    }
                    this.skeleton.m_21573_().m_26573_();
                    attackAnimationRemainingTicks = 30;
                } else if (attackAnimationRemainingTicks > 0) {
                    this.skeleton.m_21573_().m_5624_((Entity)livingentity, 0.3);
                    --attackAnimationRemainingTicks;
                }
            }
        }
    }

    static class NecromancerSummonSpellGoal
    extends Goal {
        private final TargetingConditions skeletonCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        private final SculkNecromancerSkeletonEntity skeleton;

        public NecromancerSummonSpellGoal(SculkNecromancerSkeletonEntity p_32776_) {
            this.skeleton = p_32776_;
        }

        public void m_8056_() {
            VariousWorldMod.LOGGER.debug("Spell started");
            this.action();
        }

        public boolean m_8036_() {
            int i = this.skeleton.m_9236_().m_45971_(SculkSkeletonEntity.class, this.skeletonCountTargeting, (LivingEntity)this.skeleton, this.skeleton.m_20191_().m_82400_(16.0)).size();
            return this.skeleton.m_5448_() != null && this.skeleton.summonCooldown() >= 80 && this.skeleton.f_19796_.m_188503_(4) + 1 > i;
        }

        public void m_8041_() {
            this.skeleton.setSummonCooldown(0);
        }

        public void action() {
            ServerLevel serverlevel = (ServerLevel)this.skeleton.m_9236_();
            this.skeleton.m_21573_().m_26573_();
            int i = this.skeleton.m_9236_().m_45971_(SculkSkeletonEntity.class, this.skeletonCountTargeting, (LivingEntity)this.skeleton, this.skeleton.m_20191_().m_82400_(16.0)).size();
            if (i == 0) {
                i = (int)((long)i + (1L + Math.round(Math.random())));
            }
            for (int j = 0; j < i; ++j) {
                SculkSkeletonEntity sculkSkeleton = new SculkSkeletonEntity((EntityType<SculkSkeletonEntity>)((EntityType)VariousWorldModEntities.SCULK_SKELETON.get()), this.skeleton.m_9236_());
                sculkSkeleton.m_20035_(new BlockPos((int)this.skeleton.m_20185_(), (int)this.skeleton.m_20186_(), (int)this.skeleton.m_20189_()), 0.0f, 0.0f);
                sculkSkeleton.m_6518_((ServerLevelAccessor)serverlevel, this.skeleton.m_9236_().m_6436_(new BlockPos((int)this.skeleton.m_20185_(), (int)this.skeleton.m_20186_(), (int)this.skeleton.m_20189_())), MobSpawnType.MOB_SUMMONED, null, null);
                sculkSkeleton.setOwner((Mob)this.skeleton);
                this.skeleton.m_9236_().m_7967_((Entity)sculkSkeleton);
            }
        }
    }
}

