/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.sashakyotoz.variousworld.entity.WanderingSpiritAbilityShootEntity;
import net.sashakyotoz.variousworld.init.VariousWorldModEntities;
import org.jetbrains.annotations.NotNull;

public class WanderingSpiritSummonedOfSculksEntity
extends Monster
implements RangedAttackMob {
    public static boolean spiritShot = false;
    private int attackAnimationRemainingTicks;
    private int rangedAttackAnimationRemainingTicks;

    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    public int getRangedAttackAnimationRemainingTicks() {
        return this.rangedAttackAnimationRemainingTicks;
    }

    public WanderingSpiritSummonedOfSculksEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WanderingSpiritSummonedOfSculksEntity>)((EntityType)VariousWorldModEntities.WANDERING_SPIRIT_SUMMONED_OF_SCULKS.get()), world);
    }

    public WanderingSpiritSummonedOfSculksEntity(EntityType<WanderingSpiritSummonedOfSculksEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 3;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AgeableMob.class, false, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new FollowMobGoal((Mob)this, (double)1.2f, 8.0f, 4.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(7, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new WanderingSpiritAbility(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_215739_, 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sculk_sensor.hit"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sculk_sensor.break"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)VariousWorldModEntities.WANDERING_SPIRIT_SUMMONED_OF_SCULKS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WanderingSpiritSummonedOfSculksEntity::checkSpiritConditions);
    }

    public static boolean checkSpiritConditions(EntityType<? extends WanderingSpiritSummonedOfSculksEntity> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, RandomSource p_219018_) {
        return p_219015_.m_46791_() != Difficulty.PEACEFUL && WanderingSpiritSummonedOfSculksEntity.m_217057_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (RandomSource)p_219018_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 100.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 3.0);
        return builder;
    }

    static boolean hurtAndTarget(LivingEntity p_34643_, LivingEntity p_34644_) {
        float f = (float)p_34643_.m_21133_(Attributes.f_22281_);
        boolean flag = p_34644_.m_6469_(p_34643_.m_269291_().m_269333_(p_34643_), f);
        if (flag) {
            p_34643_.m_19970_(p_34643_, (Entity)p_34644_);
        }
        return flag;
    }

    public boolean m_7327_(Entity p_34491_) {
        if (Math.random() > 0.5) {
            spiritShot = false;
        }
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 30;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_215778_, 0.75f, this.m_6100_());
        return WanderingSpiritSummonedOfSculksEntity.hurtAndTarget((LivingEntity)this, (LivingEntity)p_34491_);
    }

    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        this.rangedAttackAnimationRemainingTicks = RandomSource.m_216327_().m_216339_(20, 40);
        WanderingSpiritAbilityShootEntity.shoot((LivingEntity)this, p_33317_);
    }

    static class WanderingSpiritAbility
    extends Goal {
        private final WanderingSpiritSummonedOfSculksEntity spirit;
        private int attackTime = 0;
        float f1 = Mth.m_14036_((float)0.1f, (float)0.1f, (float)1.0f);

        public WanderingSpiritAbility(WanderingSpiritSummonedOfSculksEntity p_32776_) {
            this.spirit = p_32776_;
        }

        public boolean m_8036_() {
            return this.spirit.m_5448_() != null && !spiritShot;
        }

        public void m_8056_() {
            this.spirit.rangedAttackAnimationRemainingTicks = 0;
        }

        public void m_8041_() {
            this.spirit.rangedAttackAnimationRemainingTicks = 0;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.spirit.m_5448_();
            if (livingentity != null && livingentity.m_20280_((Entity)this.spirit) < 4096.0 && this.spirit.m_142582_((Entity)livingentity)) {
                if (this.attackTime == 30) {
                    spiritShot = true;
                    this.spirit.m_6504_(livingentity, this.f1);
                    this.spirit.m_21573_().m_5624_((Entity)livingentity, 0.3);
                    this.spirit.rangedAttackAnimationRemainingTicks = 0;
                    this.attackTime = 0;
                } else if (this.attackTime < 30) {
                    ++this.attackTime;
                    this.spirit.m_21573_().m_26573_();
                }
            }
        }
    }
}

