/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sashakyotoz.variousworld.init.VariousWorldModBlocks;

@Mod.EventBusSubscriber
public class VariousWorldModBiomes {
    public static final ResourceKey<Biome> CRYSTALIC_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("various_world", "crystalicforest"));
    public static final ResourceKey<Biome> PEACEFUL_WASTELAND = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("various_world", "peaceful_wasteland"));
    public static final ResourceKey<Biome> SCULK_VALLEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("various_world", "sculk_valley"));
    public static final ResourceKey<Biome> SHINY_VALLEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("various_world", "shiny_valley"));
    public static final ResourceKey<Biome> CAVERN_OF_DEEP = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("various_world", "cavernof_deep"));
    public static final ResourceKey<Biome> CAVERNS_OF_MAGMA_GROWTH = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("various_world", "caverns_of_magma_growth"));

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registries.f_256787_);
        Registry levelStemTypeRegistry = server.m_206579_().m_175515_(Registries.f_256862_);
        Registry biomeRegistry = server.m_206579_().m_175515_(Registries.f_256952_);
        for (LevelStem levelStem : levelStemTypeRegistry.m_123024_().toList()) {
            DimensionType dimensionType = (DimensionType)levelStem.f_63975_().m_203334_();
            if (dimensionType != dimensionTypeRegistry.m_123013_(BuiltinDimensionTypes.f_223538_)) continue;
            ChunkGenerator chunkGenerator = levelStem.f_63976_();
            BiomeSource biomeSource = chunkGenerator.m_62218_();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.m_274409_().m_186850_());
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.15f, (float)0.75f), Climate.Parameter.m_186822_((float)-0.25f, (float)0.45f), Climate.Parameter.m_186822_((float)-0.015f, (float)0.65f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.515f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186822_((float)-0.95f, (float)0.275f), 0L), (Object)biomeRegistry.m_246971_(CRYSTALIC_FOREST)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.15f, (float)0.75f), Climate.Parameter.m_186822_((float)-0.25f, (float)0.45f), Climate.Parameter.m_186822_((float)-0.015f, (float)0.65f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.515f), Climate.Parameter.m_186820_((float)1.0f), Climate.Parameter.m_186822_((float)-0.95f, (float)0.275f), 0L), (Object)biomeRegistry.m_246971_(CRYSTALIC_FOREST)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.25f, (float)0.75f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.775f), Climate.Parameter.m_186822_((float)-0.05f, (float)0.85f), Climate.Parameter.m_186822_((float)-0.265f, (float)0.635f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186822_((float)-0.75f, (float)0.05f), 0L), (Object)biomeRegistry.m_246971_(PEACEFUL_WASTELAND)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.25f, (float)0.75f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.775f), Climate.Parameter.m_186822_((float)-0.05f, (float)0.85f), Climate.Parameter.m_186822_((float)-0.265f, (float)0.635f), Climate.Parameter.m_186820_((float)1.0f), Climate.Parameter.m_186822_((float)-0.75f, (float)0.05f), 0L), (Object)biomeRegistry.m_246971_(PEACEFUL_WASTELAND)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)-0.55f, (float)0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)0.45f), Climate.Parameter.m_186822_((float)0.28f, (float)1.14f), Climate.Parameter.m_186822_((float)-0.352f, (float)0.232f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186822_((float)-0.125f, (float)0.725f), 0L), (Object)biomeRegistry.m_246971_(SCULK_VALLEY)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)-0.55f, (float)0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)0.45f), Climate.Parameter.m_186822_((float)0.28f, (float)1.14f), Climate.Parameter.m_186822_((float)-0.352f, (float)0.232f), Climate.Parameter.m_186820_((float)1.0f), Climate.Parameter.m_186822_((float)-0.125f, (float)0.725f), 0L), (Object)biomeRegistry.m_246971_(SCULK_VALLEY)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.45f, (float)0.95f), Climate.Parameter.m_186822_((float)0.275f, (float)0.925f), Climate.Parameter.m_186822_((float)-0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.325f, (float)1.05f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186822_((float)-0.5f, (float)0.75f), 0L), (Object)biomeRegistry.m_246971_(SHINY_VALLEY)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.45f, (float)0.95f), Climate.Parameter.m_186822_((float)0.275f, (float)0.925f), Climate.Parameter.m_186822_((float)-0.2f, (float)0.65f), Climate.Parameter.m_186822_((float)0.325f, (float)1.25f), Climate.Parameter.m_186820_((float)1.0f), Climate.Parameter.m_186822_((float)-0.675f, (float)0.675f), 0L), (Object)biomeRegistry.m_246971_(SHINY_VALLEY)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)-0.75f, (float)-0.25f), Climate.Parameter.m_186822_((float)-0.85f, (float)-0.15f), Climate.Parameter.m_186822_((float)0.575f, (float)1.05f), Climate.Parameter.m_186822_((float)-0.475f, (float)0.375f), Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), Climate.Parameter.m_186822_((float)0.25f, (float)0.75f), 0L), (Object)biomeRegistry.m_246971_(CAVERN_OF_DEEP)));
                parameters.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.m_186822_((float)0.35f, (float)1.0f), Climate.Parameter.m_186822_((float)-0.15f, (float)1.05f), Climate.Parameter.m_186822_((float)0.25f, (float)0.85f), Climate.Parameter.m_186822_((float)0.35f, (float)1.0f), Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), Climate.Parameter.m_186822_((float)0.25f, (float)0.75f), 0L), (Object)biomeRegistry.m_246971_(CAVERNS_OF_MAGMA_GROWTH)));
                chunkGenerator.f_62137_ = MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.f_223020_ = Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(chunkGenerator.f_62137_.m_207840_()), biome -> ((BiomeGenerationSettings)chunkGenerator.f_223021_.apply(biome)).m_47818_(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.f_188871_();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
            surfaceRules.add(1, VariousWorldModBiomes.anySurfaceRule(CAVERN_OF_DEEP, ((Block)VariousWorldModBlocks.DEEP_MOSS.get()).m_49966_(), Blocks.f_50730_.m_49966_(), Blocks.f_50730_.m_49966_()));
            surfaceRules.add(1, VariousWorldModBiomes.anySurfaceRule(CAVERNS_OF_MAGMA_GROWTH, ((Block)VariousWorldModBlocks.BLACKLY_STONY_MAGMA.get()).m_49966_(), ((Block)VariousWorldModBlocks.BLACKLY_STONY_MAGMA.get()).m_49966_(), Blocks.f_50730_.m_49966_()));
            surfaceRules.add(1, VariousWorldModBiomes.preliminarySurfaceRule(CRYSTALIC_FOREST, ((Block)VariousWorldModBlocks.CRYSTALIC_GRASS.get()).m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()));
            surfaceRules.add(1, VariousWorldModBiomes.preliminarySurfaceRule(PEACEFUL_WASTELAND, Blocks.f_50440_.m_49966_(), Blocks.f_50546_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, VariousWorldModBiomes.preliminarySurfaceRule(SCULK_VALLEY, ((Block)VariousWorldModBlocks.SCULK_GRASS.get()).m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()));
            surfaceRules.add(1, VariousWorldModBiomes.preliminarySurfaceRule(SHINY_VALLEY, ((Block)VariousWorldModBlocks.SHINY_GRASS.get()).m_49966_(), ((Block)VariousWorldModBlocks.GNEISS.get()).m_49966_(), ((Block)VariousWorldModBlocks.GNEISS.get()).m_49966_()));
            NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_224370_(), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
            noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
    }
}

