/*
 * Decompiled with CFR 0.152.
 */
package net.dimacloud.woundcraft;

import java.util.function.Supplier;
import net.dimacloud.woundcraft.WoundcraftMod;
import net.dimacloud.woundcraft.WoundcraftModElements;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class WoundcraftModVariables {
    public static double timer = 0.0;
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    public WoundcraftModVariables(WoundcraftModElements elements) {
        elements.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    private void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("woundcraft", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        clone.woundpoints_num = original.woundpoints_num;
        clone.xpnum = original.xpnum;
        clone.killed_toxigator = original.killed_toxigator;
        clone.killed_frozen = original.killed_frozen;
        clone.killed_molten = original.killed_molten;
        clone.killed_shadow = original.killed_shadow;
        clone.killed_birdman = original.killed_birdman;
        if (!event.isWasDeath()) {
            clone.mana = original.mana;
            clone.manause = original.manause;
            clone.shield_uses = original.shield_uses;
            clone.space_hold = original.space_hold;
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.mana = message.data.mana;
                    variables.manause = message.data.manause;
                    variables.woundpoints_num = message.data.woundpoints_num;
                    variables.xpnum = message.data.xpnum;
                    variables.shield_uses = message.data.shield_uses;
                    variables.space_hold = message.data.space_hold;
                    variables.killed_toxigator = message.data.killed_toxigator;
                    variables.killed_frozen = message.data.killed_frozen;
                    variables.killed_molten = message.data.killed_molten;
                    variables.killed_shadow = message.data.killed_shadow;
                    variables.killed_birdman = message.data.killed_birdman;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double mana = 0.0;
        public double manause = 0.0;
        public double woundpoints_num = 0.0;
        public double xpnum = 0.0;
        public double shield_uses = 1.0;
        public boolean space_hold = false;
        public boolean killed_toxigator = false;
        public boolean killed_frozen = false;
        public boolean killed_molten = false;
        public boolean killed_shadow = false;
        public boolean killed_birdman = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                WoundcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74780_a("mana", instance.mana);
            nbt.func_74780_a("manause", instance.manause);
            nbt.func_74780_a("woundpoints_num", instance.woundpoints_num);
            nbt.func_74780_a("xpnum", instance.xpnum);
            nbt.func_74780_a("shield_uses", instance.shield_uses);
            nbt.func_74757_a("space_hold", instance.space_hold);
            nbt.func_74757_a("killed_toxigator", instance.killed_toxigator);
            nbt.func_74757_a("killed_frozen", instance.killed_frozen);
            nbt.func_74757_a("killed_molten", instance.killed_molten);
            nbt.func_74757_a("killed_shadow", instance.killed_shadow);
            nbt.func_74757_a("killed_birdman", instance.killed_birdman);
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.mana = nbt.func_74769_h("mana");
            instance.manause = nbt.func_74769_h("manause");
            instance.woundpoints_num = nbt.func_74769_h("woundpoints_num");
            instance.xpnum = nbt.func_74769_h("xpnum");
            instance.shield_uses = nbt.func_74769_h("shield_uses");
            instance.space_hold = nbt.func_74767_n("space_hold");
            instance.killed_toxigator = nbt.func_74767_n("killed_toxigator");
            instance.killed_frozen = nbt.func_74767_n("killed_frozen");
            instance.killed_molten = nbt.func_74767_n("killed_molten");
            instance.killed_shadow = nbt.func_74767_n("killed_shadow");
            instance.killed_birdman = nbt.func_74767_n("killed_birdman");
        }
    }

    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> PLAYER_VARIABLES_CAPABILITY.getDefaultInstance());

        private PlayerVariablesProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, (Object)((PlayerVariables)this.instance.orElseThrow(RuntimeException::new)), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, (Object)((PlayerVariables)this.instance.orElseThrow(RuntimeException::new)), null, nbt);
        }
    }
}

