/*
 * Decompiled with CFR 0.152.
 */
package net.dimacloud.woundcraft.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.dimacloud.woundcraft.WoundcraftModElements;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@WoundcraftModElements.ModElement.Tag
public class MonkeyEntity
extends WoundcraftModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.7f, 1.1f).func_206830_a("monkey").setRegistryName("monkey");

    public MonkeyEntity(WoundcraftModElements instance) {
        super(instance, 172);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10076908, -13159, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("monkey_spawn_egg"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            boolean biomeCriteria = false;
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("woundcraft:floran_ancient_jungle"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("woundcraft:floran_plains"))) {
                biomeCriteria = true;
            }
            if (!biomeCriteria) continue;
            biome.func_76747_a(EntityClassification.AMBIENT).add(new Biome.SpawnListEntry(entity, 40, 4, 4));
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new Modelmonkey(), 0.7f){

            public ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("woundcraft:textures/monkey.png");
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta) {
        MonkeyEntity.addBoxHelper(renderer, texU, texV, x, y, z, dx, dy, dz, delta, renderer.field_78809_i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta, boolean mirror) {
        renderer.field_78809_i = mirror;
        renderer.func_217178_a("", x, y, z, dx, dy, dz, delta, texU, texV);
    }

    public static class Modelmonkey
    extends EntityModel<Entity> {
        private final ModelRenderer body;
        private final ModelRenderer head;
        private final ModelRenderer left1;
        private final ModelRenderer right1;
        private final ModelRenderer left2;
        private final ModelRenderer right2;
        private final ModelRenderer tail;

        public Modelmonkey() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, 18.0f, -3.0f);
            this.setRotationAngle(this.body, -0.7854f, 0.0f, 0.0f);
            MonkeyEntity.addBoxHelper(this.body, 0, 0, -5.0f, -7.0f, -5.0f, 10, 7, 12, 0.0f, false);
            MonkeyEntity.addBoxHelper(this.body, 0, 0, -1.0f, -13.0711f, 4.6569f, 2, 6, 2, 0.0f, false);
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, 13.0f, -5.0f);
            MonkeyEntity.addBoxHelper(this.head, 0, 19, -4.0f, -8.0f, -5.0f, 8, 8, 8, 0.0f, false);
            MonkeyEntity.addBoxHelper(this.head, 24, 19, -6.0f, -7.0f, -2.0f, 2, 5, 1, 0.0f, false);
            MonkeyEntity.addBoxHelper(this.head, 0, 19, 4.0f, -7.0f, -2.0f, 2, 5, 1, 0.0f, false);
            MonkeyEntity.addBoxHelper(this.head, 40, 30, -3.0f, -4.0f, -6.0f, 6, 3, 2, 0.0f, false);
            this.left1 = new ModelRenderer((Model)this);
            this.left1.func_78793_a(-5.0f, 16.0f, -4.0f);
            MonkeyEntity.addBoxHelper(this.left1, 0, 35, -1.0f, -2.0f, -2.0f, 4, 10, 4, 0.0f, false);
            this.right1 = new ModelRenderer((Model)this);
            this.right1.func_78793_a(4.0f, 16.0f, -4.0f);
            MonkeyEntity.addBoxHelper(this.right1, 28, 31, -2.0f, -2.0f, -2.0f, 4, 10, 4, 0.0f, false);
            this.left2 = new ModelRenderer((Model)this);
            this.left2.func_78793_a(-5.0f, 17.0f, 4.0f);
            MonkeyEntity.addBoxHelper(this.left2, 32, 19, -1.0f, 0.0f, -2.0f, 4, 7, 4, 0.0f, false);
            this.right2 = new ModelRenderer((Model)this);
            this.right2.func_78793_a(3.0f, 17.0f, 4.0f);
            MonkeyEntity.addBoxHelper(this.right2, 32, 0, -1.0f, 0.0f, -2.0f, 4, 7, 4, 0.0f, false);
            this.tail = new ModelRenderer((Model)this);
            this.tail.func_78793_a(0.0f, 13.0f, 10.0f);
            this.setRotationAngle(this.tail, -0.3054f, 0.0f, 0.0f);
            MonkeyEntity.addBoxHelper(this.tail, 16, 35, -1.0f, -12.0f, -1.0f, 2, 12, 2, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            this.body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.head.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.left1.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.right1.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.left2.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.right2.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.tail.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.right1.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.right2.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.left2.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.left1.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
        }
    }

    public static class CustomEntity
    extends CreatureEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 6;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{((Object)((Object)this)).getClass()}));
            this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
            this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.5f));
            this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(6, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("woundcraft:monkey_live"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("woundcraft:monkey_hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("woundcraft:monkey_death"));
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        }
    }
}

