/*
 * Decompiled with CFR 0.152.
 */
package net.dimacloud.woundcraft;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dimacloud.woundcraft.WoundcraftMod;
import net.dimacloud.woundcraft.WoundcraftModVariables;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class WoundcraftModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public WoundcraftModElements() {
        sounds.put(new ResourceLocation("woundcraft", "entity.vampire.growl"), new SoundEvent(new ResourceLocation("woundcraft", "entity.vampire.growl")));
        sounds.put(new ResourceLocation("woundcraft", "entity.vampire.hurt"), new SoundEvent(new ResourceLocation("woundcraft", "entity.vampire.hurt")));
        sounds.put(new ResourceLocation("woundcraft", "entity.vampire.death"), new SoundEvent(new ResourceLocation("woundcraft", "entity.vampire.death")));
        sounds.put(new ResourceLocation("woundcraft", "entity.bug.fly"), new SoundEvent(new ResourceLocation("woundcraft", "entity.bug.fly")));
        sounds.put(new ResourceLocation("woundcraft", "entity.bug.death"), new SoundEvent(new ResourceLocation("woundcraft", "entity.bug.death")));
        sounds.put(new ResourceLocation("woundcraft", "entity.bug.hurt"), new SoundEvent(new ResourceLocation("woundcraft", "entity.bug.hurt")));
        sounds.put(new ResourceLocation("woundcraft", "item.armor.crystal.equip.2"), new SoundEvent(new ResourceLocation("woundcraft", "item.armor.crystal.equip.2")));
        sounds.put(new ResourceLocation("woundcraft", "entity.stegosaur.breath"), new SoundEvent(new ResourceLocation("woundcraft", "entity.stegosaur.breath")));
        sounds.put(new ResourceLocation("woundcraft", "entity.stegosaur.medium"), new SoundEvent(new ResourceLocation("woundcraft", "entity.stegosaur.medium")));
        sounds.put(new ResourceLocation("woundcraft", "entity.stegosaur.damage"), new SoundEvent(new ResourceLocation("woundcraft", "entity.stegosaur.damage")));
        sounds.put(new ResourceLocation("woundcraft", "ancientgolem_death"), new SoundEvent(new ResourceLocation("woundcraft", "ancientgolem_death")));
        sounds.put(new ResourceLocation("woundcraft", "ancientgolem_hit"), new SoundEvent(new ResourceLocation("woundcraft", "ancientgolem_hit")));
        sounds.put(new ResourceLocation("woundcraft", "ancientgolem_walk"), new SoundEvent(new ResourceLocation("woundcraft", "ancientgolem_walk")));
        sounds.put(new ResourceLocation("woundcraft", "entity.molten.death"), new SoundEvent(new ResourceLocation("woundcraft", "entity.molten.death")));
        sounds.put(new ResourceLocation("woundcraft", "entity.molten.hurt"), new SoundEvent(new ResourceLocation("woundcraft", "entity.molten.hurt")));
        sounds.put(new ResourceLocation("woundcraft", "entity.molten.say2"), new SoundEvent(new ResourceLocation("woundcraft", "entity.molten.say2")));
        sounds.put(new ResourceLocation("woundcraft", "entity.molten.say1"), new SoundEvent(new ResourceLocation("woundcraft", "entity.molten.say1")));
        sounds.put(new ResourceLocation("woundcraft", "entity.ancientgolem.spawn"), new SoundEvent(new ResourceLocation("woundcraft", "entity.ancientgolem.spawn")));
        sounds.put(new ResourceLocation("woundcraft", "spell.fire"), new SoundEvent(new ResourceLocation("woundcraft", "spell.fire")));
        sounds.put(new ResourceLocation("woundcraft", "spell.thunder"), new SoundEvent(new ResourceLocation("woundcraft", "spell.thunder")));
        sounds.put(new ResourceLocation("woundcraft", "spell.frost"), new SoundEvent(new ResourceLocation("woundcraft", "spell.frost")));
        sounds.put(new ResourceLocation("woundcraft", "spell.fire.impact"), new SoundEvent(new ResourceLocation("woundcraft", "spell.fire.impact")));
        sounds.put(new ResourceLocation("woundcraft", "spell.frost.succes"), new SoundEvent(new ResourceLocation("woundcraft", "spell.frost.succes")));
        sounds.put(new ResourceLocation("woundcraft", "leef.damage"), new SoundEvent(new ResourceLocation("woundcraft", "leef.damage")));
        sounds.put(new ResourceLocation("woundcraft", "leef.death"), new SoundEvent(new ResourceLocation("woundcraft", "leef.death")));
        sounds.put(new ResourceLocation("woundcraft", "leef.living"), new SoundEvent(new ResourceLocation("woundcraft", "leef.living")));
        sounds.put(new ResourceLocation("woundcraft", "spell.blast"), new SoundEvent(new ResourceLocation("woundcraft", "spell.blast")));
        sounds.put(new ResourceLocation("woundcraft", "spell.shield"), new SoundEvent(new ResourceLocation("woundcraft", "spell.shield")));
        sounds.put(new ResourceLocation("woundcraft", "spell.shield.break"), new SoundEvent(new ResourceLocation("woundcraft", "spell.shield.break")));
        sounds.put(new ResourceLocation("woundcraft", "spell.shield.2"), new SoundEvent(new ResourceLocation("woundcraft", "spell.shield.2")));
        sounds.put(new ResourceLocation("woundcraft", "dry_dinozix_death"), new SoundEvent(new ResourceLocation("woundcraft", "dry_dinozix_death")));
        sounds.put(new ResourceLocation("woundcraft", "dry_dinozix_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "dry_dinozix_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "dry_dinozix_jump"), new SoundEvent(new ResourceLocation("woundcraft", "dry_dinozix_jump")));
        sounds.put(new ResourceLocation("woundcraft", "dinozix_death"), new SoundEvent(new ResourceLocation("woundcraft", "dinozix_death")));
        sounds.put(new ResourceLocation("woundcraft", "dinozix_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "dinozix_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "entity.bird.hurt"), new SoundEvent(new ResourceLocation("woundcraft", "entity.bird.hurt")));
        sounds.put(new ResourceLocation("woundcraft", "entity.bird.death"), new SoundEvent(new ResourceLocation("woundcraft", "entity.bird.death")));
        sounds.put(new ResourceLocation("woundcraft", "entity.bird.voice"), new SoundEvent(new ResourceLocation("woundcraft", "entity.bird.voice")));
        sounds.put(new ResourceLocation("woundcraft", "spell.short"), new SoundEvent(new ResourceLocation("woundcraft", "spell.short")));
        sounds.put(new ResourceLocation("woundcraft", "spell.long"), new SoundEvent(new ResourceLocation("woundcraft", "spell.long")));
        sounds.put(new ResourceLocation("woundcraft", "darkmage.death"), new SoundEvent(new ResourceLocation("woundcraft", "darkmage.death")));
        sounds.put(new ResourceLocation("woundcraft", "darkmage.live"), new SoundEvent(new ResourceLocation("woundcraft", "darkmage.live")));
        sounds.put(new ResourceLocation("woundcraft", "darkmage.hurt"), new SoundEvent(new ResourceLocation("woundcraft", "darkmage.hurt")));
        sounds.put(new ResourceLocation("woundcraft", "minigolem.hurt"), new SoundEvent(new ResourceLocation("woundcraft", "minigolem.hurt")));
        sounds.put(new ResourceLocation("woundcraft", "minigolem.death"), new SoundEvent(new ResourceLocation("woundcraft", "minigolem.death")));
        sounds.put(new ResourceLocation("woundcraft", "rifle.shot"), new SoundEvent(new ResourceLocation("woundcraft", "rifle.shot")));
        sounds.put(new ResourceLocation("woundcraft", "staff.use"), new SoundEvent(new ResourceLocation("woundcraft", "staff.use")));
        sounds.put(new ResourceLocation("woundcraft", "leef_dmg_nonoise"), new SoundEvent(new ResourceLocation("woundcraft", "leef_dmg_nonoise")));
        sounds.put(new ResourceLocation("woundcraft", "leef_sth_nonoise"), new SoundEvent(new ResourceLocation("woundcraft", "leef_sth_nonoise")));
        sounds.put(new ResourceLocation("woundcraft", "leef_live_nonoise"), new SoundEvent(new ResourceLocation("woundcraft", "leef_live_nonoise")));
        sounds.put(new ResourceLocation("woundcraft", "monkey_live"), new SoundEvent(new ResourceLocation("woundcraft", "monkey_live")));
        sounds.put(new ResourceLocation("woundcraft", "monkey_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "monkey_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "monkey_death"), new SoundEvent(new ResourceLocation("woundcraft", "monkey_death")));
        sounds.put(new ResourceLocation("woundcraft", "rafflower_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "rafflower_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "rafflower_death"), new SoundEvent(new ResourceLocation("woundcraft", "rafflower_death")));
        sounds.put(new ResourceLocation("woundcraft", "rafflower_live"), new SoundEvent(new ResourceLocation("woundcraft", "rafflower_live")));
        sounds.put(new ResourceLocation("woundcraft", "cater_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "cater_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "cater_death"), new SoundEvent(new ResourceLocation("woundcraft", "cater_death")));
        sounds.put(new ResourceLocation("woundcraft", "ghost_living"), new SoundEvent(new ResourceLocation("woundcraft", "ghost_living")));
        sounds.put(new ResourceLocation("woundcraft", "ghost_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "ghost_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "ghost_death"), new SoundEvent(new ResourceLocation("woundcraft", "ghost_death")));
        sounds.put(new ResourceLocation("woundcraft", "serpent_growl"), new SoundEvent(new ResourceLocation("woundcraft", "serpent_growl")));
        sounds.put(new ResourceLocation("woundcraft", "serpent_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "serpent_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "birdman_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "birdman_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "birdman_death"), new SoundEvent(new ResourceLocation("woundcraft", "birdman_death")));
        sounds.put(new ResourceLocation("woundcraft", "birdman_live"), new SoundEvent(new ResourceLocation("woundcraft", "birdman_live")));
        sounds.put(new ResourceLocation("woundcraft", "frog_live"), new SoundEvent(new ResourceLocation("woundcraft", "frog_live")));
        sounds.put(new ResourceLocation("woundcraft", "frog_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "frog_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "frog_death"), new SoundEvent(new ResourceLocation("woundcraft", "frog_death")));
        sounds.put(new ResourceLocation("woundcraft", "cursed_say"), new SoundEvent(new ResourceLocation("woundcraft", "cursed_say")));
        sounds.put(new ResourceLocation("woundcraft", "cursed_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "cursed_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "cursed_death"), new SoundEvent(new ResourceLocation("woundcraft", "cursed_death")));
        sounds.put(new ResourceLocation("woundcraft", "taton_death"), new SoundEvent(new ResourceLocation("woundcraft", "taton_death")));
        sounds.put(new ResourceLocation("woundcraft", "robotic_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "robotic_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "taton_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "taton_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "taton_idle"), new SoundEvent(new ResourceLocation("woundcraft", "taton_idle")));
        sounds.put(new ResourceLocation("woundcraft", "robotic_death"), new SoundEvent(new ResourceLocation("woundcraft", "robotic_death")));
        sounds.put(new ResourceLocation("woundcraft", "yeti_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "yeti_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "yeti_death"), new SoundEvent(new ResourceLocation("woundcraft", "yeti_death")));
        sounds.put(new ResourceLocation("woundcraft", "bbird_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "bbird_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "bbird_live"), new SoundEvent(new ResourceLocation("woundcraft", "bbird_live")));
        sounds.put(new ResourceLocation("woundcraft", "bbird_death"), new SoundEvent(new ResourceLocation("woundcraft", "bbird_death")));
        sounds.put(new ResourceLocation("woundcraft", "maksik"), new SoundEvent(new ResourceLocation("woundcraft", "maksik")));
        sounds.put(new ResourceLocation("woundcraft", "solar1"), new SoundEvent(new ResourceLocation("woundcraft", "solar1")));
        sounds.put(new ResourceLocation("woundcraft", "solar2"), new SoundEvent(new ResourceLocation("woundcraft", "solar2")));
        sounds.put(new ResourceLocation("woundcraft", "solar3"), new SoundEvent(new ResourceLocation("woundcraft", "solar3")));
        sounds.put(new ResourceLocation("woundcraft", "evil_hurt"), new SoundEvent(new ResourceLocation("woundcraft", "evil_hurt")));
        sounds.put(new ResourceLocation("woundcraft", "evil_live"), new SoundEvent(new ResourceLocation("woundcraft", "evil_live")));
        sounds.put(new ResourceLocation("woundcraft", "evil_death"), new SoundEvent(new ResourceLocation("woundcraft", "evil_death")));
        sounds.put(new ResourceLocation("woundcraft", "factory_amb"), new SoundEvent(new ResourceLocation("woundcraft", "factory_amb")));
        sounds.put(new ResourceLocation("woundcraft", "rainforest_amb"), new SoundEvent(new ResourceLocation("woundcraft", "rainforest_amb")));
        sounds.put(new ResourceLocation("woundcraft", "blizzard_amb"), new SoundEvent(new ResourceLocation("woundcraft", "blizzard_amb")));
        sounds.put(new ResourceLocation("woundcraft", "graveyard_amb"), new SoundEvent(new ResourceLocation("woundcraft", "graveyard_amb")));
        sounds.put(new ResourceLocation("woundcraft", "forest_amb"), new SoundEvent(new ResourceLocation("woundcraft", "forest_amb")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("woundcraft").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        MinecraftForge.EVENT_BUS.register((Object)new WoundcraftModVariables(this));
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        WoundcraftMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final WoundcraftModElements elements;
        protected final int sortid;

        public ModElement(WoundcraftModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

