
package net.mcreator.shar.world.biome;

import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.event.RegistryEvent;

import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.Biome;

import net.mcreator.shar.block.RedGrassBlockBlock;
import net.mcreator.shar.block.BeatStoneBlock;
import net.mcreator.shar.SharModElements;

@SharModElements.ModElement.Tag
public class BeatRedForestBiome extends SharModElements.ModElement {
	public static Biome biome;
	public BeatRedForestBiome(SharModElements instance) {
		super(instance, 11);
		FMLJavaModLoadingContext.get().getModEventBus().register(new BiomeRegisterHandler());
	}
	private static class BiomeRegisterHandler {
		@SubscribeEvent
		public void registerBiomes(RegistryEvent.Register<Biome> event) {
			if (biome == null) {
				BiomeAmbience effects = new BiomeAmbience.Builder().setFogColor(-8912896).setWaterColor(-8912896).setWaterFogColor(-10485760)
						.withSkyColor(-8912896).withFoliageColor(-8912896).withGrassColor(-8912896).build();
				BiomeGenerationSettings.Builder biomeGenerationSettings = new BiomeGenerationSettings.Builder()
						.withSurfaceBuilder(SurfaceBuilder.DEFAULT.func_242929_a(new SurfaceBuilderConfig(RedGrassBlockBlock.block.getDefaultState(),
								BeatStoneBlock.block.getDefaultState(), BeatStoneBlock.block.getDefaultState())));
				MobSpawnInfo.Builder mobSpawnInfo = new MobSpawnInfo.Builder().isValidSpawnBiomeForPlayer();
				biome = new Biome.Builder().precipitation(Biome.RainType.RAIN).category(Biome.Category.NONE).depth(0.5f).scale(0.4f).temperature(1f)
						.downfall(0.25f).setEffects(effects).withMobSpawnSettings(mobSpawnInfo.copy())
						.withGenerationSettings(biomeGenerationSettings.build()).build();
				event.getRegistry().register(biome.setRegistryName("shar:beat_red_forest"));
			}
		}
	}
	@Override
	public void init(FMLCommonSetupEvent event) {
	}
}
