
/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.clashofclans.init;

import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.event.RegistryEvent;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.BlockItem;

import net.mcreator.clashofclans.item.TownHall2Item;
import net.mcreator.clashofclans.item.TownHall1Item;
import net.mcreator.clashofclans.item.GoldCoinsIngotItem;
import net.mcreator.clashofclans.item.GiantItem;
import net.mcreator.clashofclans.item.GiantFistItem;
import net.mcreator.clashofclans.item.GiantArmorItem;
import net.mcreator.clashofclans.item.GemsItem;
import net.mcreator.clashofclans.item.ElixerItem;
import net.mcreator.clashofclans.item.DarkElixerItem;
import net.mcreator.clashofclans.item.BarbarianItem;
import net.mcreator.clashofclans.item.BarbarianArmorItem;
import net.mcreator.clashofclans.item.ArcherItem;
import net.mcreator.clashofclans.item.ArcherArmorItem;

import java.util.List;
import java.util.ArrayList;

@Mod.EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD)
public class ClashOfClansModItems {
	private static final List<Item> REGISTRY = new ArrayList<>();
	public static final Item TOWN_HALL_1 = register(new TownHall1Item());
	public static final Item TOWN_HALL_2 = register(new TownHall2Item());
	public static final Item ELIXER = register(new ElixerItem());
	public static final Item ELIXER_ORE = register(ClashOfClansModBlocks.ELIXER_ORE, CreativeModeTab.TAB_BUILDING_BLOCKS);
	public static final Item ELIXER_BLOCK = register(ClashOfClansModBlocks.ELIXER_BLOCK, CreativeModeTab.TAB_BUILDING_BLOCKS);
	public static final Item GOLD_COINS_INGOT = register(new GoldCoinsIngotItem());
	public static final Item GOLD_COINS_ORE = register(ClashOfClansModBlocks.GOLD_COINS_ORE, CreativeModeTab.TAB_BUILDING_BLOCKS);
	public static final Item GOLD_COINS_BLOCK = register(ClashOfClansModBlocks.GOLD_COINS_BLOCK, CreativeModeTab.TAB_BUILDING_BLOCKS);
	public static final Item DARK_ELIXER = register(new DarkElixerItem());
	public static final Item DARK_ELIXER_ORE = register(ClashOfClansModBlocks.DARK_ELIXER_ORE, CreativeModeTab.TAB_BUILDING_BLOCKS);
	public static final Item DARK_ELIXER_BLOCK = register(ClashOfClansModBlocks.DARK_ELIXER_BLOCK, CreativeModeTab.TAB_BUILDING_BLOCKS);
	public static final Item BARBARIAN_ARMOR_HELMET = register(new BarbarianArmorItem.Helmet());
	public static final Item BARBARIAN_ARMOR_CHESTPLATE = register(new BarbarianArmorItem.Chestplate());
	public static final Item BARBARIAN_ARMOR_LEGGINGS = register(new BarbarianArmorItem.Leggings());
	public static final Item BARBARIAN_ARMOR_BOOTS = register(new BarbarianArmorItem.Boots());
	public static final Item ARCHER_ARMOR_HELMET = register(new ArcherArmorItem.Helmet());
	public static final Item ARCHER_ARMOR_CHESTPLATE = register(new ArcherArmorItem.Chestplate());
	public static final Item ARCHER_ARMOR_LEGGINGS = register(new ArcherArmorItem.Leggings());
	public static final Item ARCHER_ARMOR_BOOTS = register(new ArcherArmorItem.Boots());
	public static final Item GIANT_FIST = register(new GiantFistItem());
	public static final Item GIANT_ARMOR_HELMET = register(new GiantArmorItem.Helmet());
	public static final Item GIANT_ARMOR_CHESTPLATE = register(new GiantArmorItem.Chestplate());
	public static final Item GIANT_ARMOR_LEGGINGS = register(new GiantArmorItem.Leggings());
	public static final Item GIANT_ARMOR_BOOTS = register(new GiantArmorItem.Boots());
	public static final Item GEMS = register(new GemsItem());
	public static final Item BARBARIAN = register(new BarbarianItem());
	public static final Item ARCHER = register(new ArcherItem());
	public static final Item GIANT = register(new GiantItem());

	private static Item register(Item item) {
		REGISTRY.add(item);
		return item;
	}

	private static Item register(Block block, CreativeModeTab tab) {
		return register(new BlockItem(block, new Item.Properties().tab(tab)).setRegistryName(block.getRegistryName()));
	}

	@SubscribeEvent
	public static void registerItems(RegistryEvent.Register<Item> event) {
		event.getRegistry().registerAll(REGISTRY.toArray(new Item[0]));
	}
}
