/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geotech.init;

import net.mcreator.geotech.entity.CombatBowProjectileEntity;
import net.mcreator.geotech.entity.CorruptedHuskEntity;
import net.mcreator.geotech.entity.OblivionBowProjectileEntity;
import net.mcreator.geotech.entity.RailgunProjectileEntity;
import net.mcreator.geotech.entity.RedstoneBugEntity;
import net.mcreator.geotech.entity.UnderwaterTNTEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeotechModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"geotech");
    public static final RegistryObject<EntityType<CorruptedHuskEntity>> CORRUPTED_HUSK = GeotechModEntities.register("corrupted_husk", EntityType.Builder.m_20704_(CorruptedHuskEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CorruptedHuskEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<OblivionBowProjectileEntity>> OBLIVION_BOW_PROJECTILE = GeotechModEntities.register("projectile_oblivion_bow_projectile", EntityType.Builder.m_20704_(OblivionBowProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(OblivionBowProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<CombatBowProjectileEntity>> COMBAT_BOW_PROJECTILE = GeotechModEntities.register("projectile_combat_bow_projectile", EntityType.Builder.m_20704_(CombatBowProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(CombatBowProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RailgunProjectileEntity>> RAILGUN_PROJECTILE = GeotechModEntities.register("projectile_railgun_projectile", EntityType.Builder.m_20704_(RailgunProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RailgunProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<UnderwaterTNTEntity>> UNDERWATER_TNT = GeotechModEntities.register("underwater_tnt", EntityType.Builder.m_20704_(UnderwaterTNTEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(UnderwaterTNTEntity::new).m_20719_().m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<RedstoneBugEntity>> REDSTONE_BUG = GeotechModEntities.register("redstone_bug", EntityType.Builder.m_20704_(RedstoneBugEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RedstoneBugEntity::new).m_20699_(0.4f, 0.3f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CorruptedHuskEntity.init();
            UnderwaterTNTEntity.init();
            RedstoneBugEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CORRUPTED_HUSK.get(), CorruptedHuskEntity.createAttributes().m_22265_());
        event.put((EntityType)UNDERWATER_TNT.get(), UnderwaterTNTEntity.createAttributes().m_22265_());
        event.put((EntityType)REDSTONE_BUG.get(), RedstoneBugEntity.createAttributes().m_22265_());
    }
}

