/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geotech.network;

import java.util.function.Supplier;
import net.mcreator.geotech.GeotechMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeotechModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GeotechMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Z = message.data.Z;
                    variables.Y = message.data.Y;
                    variables.X = message.data.X;
                    variables.Velocity = message.data.Velocity;
                    variables.Time = message.data.Time;
                    variables.LCE = message.data.LCE;
                    variables.Weather = message.data.Weather;
                    variables.MonsterRadar = message.data.MonsterRadar;
                    variables.Hp = message.data.Hp;
                    variables.Armor = message.data.Armor;
                    variables.GeotiteCrag = message.data.GeotiteCrag;
                    variables.GeotitePlateau = message.data.GeotitePlateau;
                    variables.NoteCount = message.data.NoteCount;
                    variables.Jetpack_Active = message.data.Jetpack_Active;
                    variables.SavedCoordinate1 = message.data.SavedCoordinate1;
                    variables.SavedCoordinate2 = message.data.SavedCoordinate2;
                    variables.SavedCoordinate3 = message.data.SavedCoordinate3;
                    variables.CoordinateName1 = message.data.CoordinateName1;
                    variables.CoordinateName2 = message.data.CoordinateName2;
                    variables.CoordinateName3 = message.data.CoordinateName3;
                    variables.Coordinatetosave = message.data.Coordinatetosave;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Z = 0.0;
        public double Y = 0.0;
        public double X = 0.0;
        public double Velocity = 0.0;
        public double Time = 0.0;
        public double LCE = 0.0;
        public String Weather = "\"\"";
        public String MonsterRadar = "\"\"";
        public String Hp = "\"\"";
        public String Armor = "\"\"";
        public boolean GeotiteCrag = false;
        public boolean GeotitePlateau = false;
        public double NoteCount = 0.0;
        public boolean Jetpack_Active = false;
        public String SavedCoordinate1 = "N/A";
        public String SavedCoordinate2 = "N/A";
        public String SavedCoordinate3 = "N/A";
        public String CoordinateName1 = "Coordinate Name";
        public String CoordinateName2 = "Coordinate Name";
        public String CoordinateName3 = "Coordinate Name";
        public String Coordinatetosave = "Coordinate Name";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GeotechMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Z", this.Z);
            nbt.m_128347_("Y", this.Y);
            nbt.m_128347_("X", this.X);
            nbt.m_128347_("Velocity", this.Velocity);
            nbt.m_128347_("Time", this.Time);
            nbt.m_128347_("LCE", this.LCE);
            nbt.m_128359_("Weather", this.Weather);
            nbt.m_128359_("MonsterRadar", this.MonsterRadar);
            nbt.m_128359_("Hp", this.Hp);
            nbt.m_128359_("Armor", this.Armor);
            nbt.m_128379_("GeotiteCrag", this.GeotiteCrag);
            nbt.m_128379_("GeotitePlateau", this.GeotitePlateau);
            nbt.m_128347_("NoteCount", this.NoteCount);
            nbt.m_128379_("Jetpack_Active", this.Jetpack_Active);
            nbt.m_128359_("SavedCoordinate1", this.SavedCoordinate1);
            nbt.m_128359_("SavedCoordinate2", this.SavedCoordinate2);
            nbt.m_128359_("SavedCoordinate3", this.SavedCoordinate3);
            nbt.m_128359_("CoordinateName1", this.CoordinateName1);
            nbt.m_128359_("CoordinateName2", this.CoordinateName2);
            nbt.m_128359_("CoordinateName3", this.CoordinateName3);
            nbt.m_128359_("Coordinatetosave", this.Coordinatetosave);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.Z = nbt.m_128459_("Z");
            this.Y = nbt.m_128459_("Y");
            this.X = nbt.m_128459_("X");
            this.Velocity = nbt.m_128459_("Velocity");
            this.Time = nbt.m_128459_("Time");
            this.LCE = nbt.m_128459_("LCE");
            this.Weather = nbt.m_128461_("Weather");
            this.MonsterRadar = nbt.m_128461_("MonsterRadar");
            this.Hp = nbt.m_128461_("Hp");
            this.Armor = nbt.m_128461_("Armor");
            this.GeotiteCrag = nbt.m_128471_("GeotiteCrag");
            this.GeotitePlateau = nbt.m_128471_("GeotitePlateau");
            this.NoteCount = nbt.m_128459_("NoteCount");
            this.Jetpack_Active = nbt.m_128471_("Jetpack_Active");
            this.SavedCoordinate1 = nbt.m_128461_("SavedCoordinate1");
            this.SavedCoordinate2 = nbt.m_128461_("SavedCoordinate2");
            this.SavedCoordinate3 = nbt.m_128461_("SavedCoordinate3");
            this.CoordinateName1 = nbt.m_128461_("CoordinateName1");
            this.CoordinateName2 = nbt.m_128461_("CoordinateName2");
            this.CoordinateName3 = nbt.m_128461_("CoordinateName3");
            this.Coordinatetosave = nbt.m_128461_("Coordinatetosave");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("geotech", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Z = original.Z;
            clone.Y = original.Y;
            clone.X = original.X;
            clone.Velocity = original.Velocity;
            clone.Time = original.Time;
            clone.LCE = original.LCE;
            clone.Weather = original.Weather;
            clone.MonsterRadar = original.MonsterRadar;
            clone.Hp = original.Hp;
            clone.Armor = original.Armor;
            clone.GeotiteCrag = original.GeotiteCrag;
            clone.GeotitePlateau = original.GeotitePlateau;
            clone.NoteCount = original.NoteCount;
            clone.SavedCoordinate1 = original.SavedCoordinate1;
            clone.SavedCoordinate2 = original.SavedCoordinate2;
            clone.SavedCoordinate3 = original.SavedCoordinate3;
            clone.CoordinateName1 = original.CoordinateName1;
            clone.CoordinateName2 = original.CoordinateName2;
            clone.CoordinateName3 = original.CoordinateName3;
            clone.Coordinatetosave = original.Coordinatetosave;
            if (!event.isWasDeath()) {
                clone.Jetpack_Active = original.Jetpack_Active;
            }
        }
    }
}

