/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geotech;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.geotech.ModItemProperties;
import net.mcreator.geotech.init.GeotechModBlockEntities;
import net.mcreator.geotech.init.GeotechModBlocks;
import net.mcreator.geotech.init.GeotechModEntities;
import net.mcreator.geotech.init.GeotechModItems;
import net.mcreator.geotech.init.GeotechModMenus;
import net.mcreator.geotech.init.GeotechModMobEffects;
import net.mcreator.geotech.init.GeotechModParticleTypes;
import net.mcreator.geotech.init.GeotechModPotions;
import net.mcreator.geotech.init.GeotechModSounds;
import net.mcreator.geotech.init.GeotechModTabs;
import net.mcreator.geotech.world.features.StructureFeature;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="geotech")
public class GeotechMod {
    public static final Logger LOGGER = LogManager.getLogger(GeotechMod.class);
    public static final String MODID = "geotech";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("geotech", "geotech"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public GeotechMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        GeotechModSounds.REGISTRY.register(bus);
        GeotechModBlocks.REGISTRY.register(bus);
        GeotechModBlockEntities.REGISTRY.register(bus);
        GeotechModItems.REGISTRY.register(bus);
        GeotechModEntities.REGISTRY.register(bus);
        GeotechModTabs.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        GeotechModMobEffects.REGISTRY.register(bus);
        GeotechModPotions.REGISTRY.register(bus);
        GeotechModParticleTypes.REGISTRY.register(bus);
        GeotechModMenus.REGISTRY.register(bus);
        bus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModItemProperties.addCustomItemProperties();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

