/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpgbuffs.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.rpgbuffs.RpgbuffsMod;
import net.mcreator.rpgbuffs.procedures.FireResProcProcedure;
import net.mcreator.rpgbuffs.procedures.HasteProcProcedure;
import net.mcreator.rpgbuffs.procedures.HealthProcProcedure;
import net.mcreator.rpgbuffs.procedures.HungerLimitProcProcedure;
import net.mcreator.rpgbuffs.procedures.JumpBoostProcProcedure;
import net.mcreator.rpgbuffs.procedures.RegenProcProcedure;
import net.mcreator.rpgbuffs.procedures.ResProcProcedure;
import net.mcreator.rpgbuffs.procedures.SpeedProcProcedure;
import net.mcreator.rpgbuffs.procedures.StrengthProcProcedure;
import net.mcreator.rpgbuffs.procedures.WaterBreathingProcProcedure;
import net.mcreator.rpgbuffs.world.inventory.BuffsGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BuffsGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public BuffsGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public BuffsGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(BuffsGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(BuffsGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            BuffsGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = BuffsGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            HealthProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            RegenProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SpeedProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            JumpBoostProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            HasteProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            StrengthProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            FireResProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            WaterBreathingProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            HungerLimitProcProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            ResProcProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RpgbuffsMod.addNetworkMessage(BuffsGUIButtonMessage.class, BuffsGUIButtonMessage::buffer, BuffsGUIButtonMessage::new, BuffsGUIButtonMessage::handler);
    }
}

