/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpgbuffs.network;

import java.util.function.Supplier;
import net.mcreator.rpgbuffs.RpgbuffsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RpgbuffsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        RpgbuffsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.WarPoints = message.data.WarPoints;
                    variables.MobsSlayed = message.data.MobsSlayed;
                    variables.BuffMenuTimer = message.data.BuffMenuTimer;
                    variables.Health = message.data.Health;
                    variables.Regen = message.data.Regen;
                    variables.Speed = message.data.Speed;
                    variables.JumpBoost = message.data.JumpBoost;
                    variables.Haste = message.data.Haste;
                    variables.LimitedHunger = message.data.LimitedHunger;
                    variables.Strength = message.data.Strength;
                    variables.FireRes = message.data.FireRes;
                    variables.WaterBreathing = message.data.WaterBreathing;
                    variables.Resistance = message.data.Resistance;
                    variables.HealthLevel = message.data.HealthLevel;
                    variables.RegenLevel = message.data.RegenLevel;
                    variables.SpeedLevel = message.data.SpeedLevel;
                    variables.JumpBoostLevel = message.data.JumpBoostLevel;
                    variables.HasteLevel = message.data.HasteLevel;
                    variables.LimitedHungerLevel = message.data.LimitedHungerLevel;
                    variables.StrengthLevel = message.data.StrengthLevel;
                    variables.FireResLevel = message.data.FireResLevel;
                    variables.WaterBreathingLevel = message.data.WaterBreathingLevel;
                    variables.ResistanceLevel = message.data.ResistanceLevel;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double WarPoints = 0.0;
        public double MobsSlayed = 0.0;
        public double BuffMenuTimer = 0.0;
        public String Health = "0/10 Cost 1";
        public String Regen = "0/10 Cost 1";
        public String Speed = "0/3 Cost 3";
        public String JumpBoost = "0/3 Cost 3";
        public String Haste = "0/1 Cost 5";
        public String LimitedHunger = "0/1 Cost 10";
        public String Strength = "0/3 Cost 3";
        public String FireRes = "0/1 Cost 10";
        public String WaterBreathing = "0/1 Cost 10";
        public String Resistance = "0/1 Cost 10";
        public double HealthLevel = 0.0;
        public double RegenLevel = 0.0;
        public double SpeedLevel = 0.0;
        public double JumpBoostLevel = 0.0;
        public double HasteLevel = 0.0;
        public double LimitedHungerLevel = 0.0;
        public double StrengthLevel = 0.0;
        public double FireResLevel = 0.0;
        public double WaterBreathingLevel = 0.0;
        public double ResistanceLevel = 0.0;

        public void syncPlayerVariables(Entity entity) {
            Entity entity2 = entity;
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                RpgbuffsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("WarPoints", this.WarPoints);
            nbt.m_128347_("MobsSlayed", this.MobsSlayed);
            nbt.m_128347_("BuffMenuTimer", this.BuffMenuTimer);
            nbt.m_128359_("Health", this.Health);
            nbt.m_128359_("Regen", this.Regen);
            nbt.m_128359_("Speed", this.Speed);
            nbt.m_128359_("JumpBoost", this.JumpBoost);
            nbt.m_128359_("Haste", this.Haste);
            nbt.m_128359_("LimitedHunger", this.LimitedHunger);
            nbt.m_128359_("Strength", this.Strength);
            nbt.m_128359_("FireRes", this.FireRes);
            nbt.m_128359_("WaterBreathing", this.WaterBreathing);
            nbt.m_128359_("Resistance", this.Resistance);
            nbt.m_128347_("HealthLevel", this.HealthLevel);
            nbt.m_128347_("RegenLevel", this.RegenLevel);
            nbt.m_128347_("SpeedLevel", this.SpeedLevel);
            nbt.m_128347_("JumpBoostLevel", this.JumpBoostLevel);
            nbt.m_128347_("HasteLevel", this.HasteLevel);
            nbt.m_128347_("LimitedHungerLevel", this.LimitedHungerLevel);
            nbt.m_128347_("StrengthLevel", this.StrengthLevel);
            nbt.m_128347_("FireResLevel", this.FireResLevel);
            nbt.m_128347_("WaterBreathingLevel", this.WaterBreathingLevel);
            nbt.m_128347_("ResistanceLevel", this.ResistanceLevel);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.WarPoints = nbt.m_128459_("WarPoints");
            this.MobsSlayed = nbt.m_128459_("MobsSlayed");
            this.BuffMenuTimer = nbt.m_128459_("BuffMenuTimer");
            this.Health = nbt.m_128461_("Health");
            this.Regen = nbt.m_128461_("Regen");
            this.Speed = nbt.m_128461_("Speed");
            this.JumpBoost = nbt.m_128461_("JumpBoost");
            this.Haste = nbt.m_128461_("Haste");
            this.LimitedHunger = nbt.m_128461_("LimitedHunger");
            this.Strength = nbt.m_128461_("Strength");
            this.FireRes = nbt.m_128461_("FireRes");
            this.WaterBreathing = nbt.m_128461_("WaterBreathing");
            this.Resistance = nbt.m_128461_("Resistance");
            this.HealthLevel = nbt.m_128459_("HealthLevel");
            this.RegenLevel = nbt.m_128459_("RegenLevel");
            this.SpeedLevel = nbt.m_128459_("SpeedLevel");
            this.JumpBoostLevel = nbt.m_128459_("JumpBoostLevel");
            this.HasteLevel = nbt.m_128459_("HasteLevel");
            this.LimitedHungerLevel = nbt.m_128459_("LimitedHungerLevel");
            this.StrengthLevel = nbt.m_128459_("StrengthLevel");
            this.FireResLevel = nbt.m_128459_("FireResLevel");
            this.WaterBreathingLevel = nbt.m_128459_("WaterBreathingLevel");
            this.ResistanceLevel = nbt.m_128459_("ResistanceLevel");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("rpgbuffs", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.WarPoints = original.WarPoints;
            clone.MobsSlayed = original.MobsSlayed;
            clone.BuffMenuTimer = original.BuffMenuTimer;
            clone.Health = original.Health;
            clone.Regen = original.Regen;
            clone.Speed = original.Speed;
            clone.JumpBoost = original.JumpBoost;
            clone.Haste = original.Haste;
            clone.LimitedHunger = original.LimitedHunger;
            clone.Strength = original.Strength;
            clone.FireRes = original.FireRes;
            clone.WaterBreathing = original.WaterBreathing;
            clone.Resistance = original.Resistance;
            clone.HealthLevel = original.HealthLevel;
            clone.RegenLevel = original.RegenLevel;
            clone.SpeedLevel = original.SpeedLevel;
            clone.JumpBoostLevel = original.JumpBoostLevel;
            clone.HasteLevel = original.HasteLevel;
            clone.LimitedHungerLevel = original.LimitedHungerLevel;
            clone.StrengthLevel = original.StrengthLevel;
            clone.FireResLevel = original.FireResLevel;
            clone.WaterBreathingLevel = original.WaterBreathingLevel;
            clone.ResistanceLevel = original.ResistanceLevel;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

