/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.justsomestuff.init;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mcreator.justsomestuff.world.features.CrystalFeature;
import net.mcreator.justsomestuff.world.features.HouseFeature;
import net.mcreator.justsomestuff.world.features.ores.HairFeature;
import net.mcreator.justsomestuff.world.features.ores.TealOreFeature;
import net.mcreator.justsomestuff.world.features.plants.SusFeature;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JustSomeStuffModFeatures {
    private static final Map<Feature<?>, FeatureRegistration> REGISTRY = new HashMap();

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])REGISTRY.keySet().toArray(new Feature[0]));
        REGISTRY.forEach((feature, registration) -> Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)feature.getRegistryName(), registration.configuredFeature()));
    }

    static {
        REGISTRY.put((Feature<?>)SusFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, SusFeature.GENERATE_BIOMES, SusFeature.CONFIGURED_FEATURE));
        REGISTRY.put((Feature<?>)HairFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HairFeature.GENERATE_BIOMES, HairFeature.CONFIGURED_FEATURE));
        REGISTRY.put((Feature<?>)TealOreFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, TealOreFeature.GENERATE_BIOMES, TealOreFeature.CONFIGURED_FEATURE));
        REGISTRY.put(HouseFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HouseFeature.GENERATE_BIOMES, HouseFeature.CONFIGURED_FEATURE));
        REGISTRY.put(CrystalFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CrystalFeature.GENERATE_BIOMES, CrystalFeature.CONFIGURED_FEATURE));
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, ConfiguredFeature<?, ?> configuredFeature) {
    }

    @Mod.EventBusSubscriber
    private static class BiomeFeatureLoader {
        private BiomeFeatureLoader() {
        }

        @SubscribeEvent
        public static void addFeatureToBiomes(BiomeLoadingEvent event) {
            for (FeatureRegistration registration : REGISTRY.values()) {
                if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
                event.getGeneration().getFeatures(registration.stage()).add(() -> registration.configuredFeature());
            }
        }
    }
}

