/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecore.init;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.minecore.world.biome.PalladiumMountainsBiome;
import net.mcreator.minecore.world.biome.ShiverfieldsBiome;
import net.mcreator.minecore.world.biome.ShiverforestBiome;
import net.mcreator.minecore.world.biome.ShiverhillsBiome;
import net.mcreator.minecore.world.biome.TwilightsBiome;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MinecoreModBiomes {
    private static final List<Biome> REGISTRY = new ArrayList<Biome>();
    public static Biome SHIVERFIELDS = MinecoreModBiomes.register("shiverfields", ShiverfieldsBiome.createBiome());
    public static Biome SHIVERFOREST = MinecoreModBiomes.register("shiverforest", ShiverforestBiome.createBiome());
    public static Biome SHIVERHILLS = MinecoreModBiomes.register("shiverhills", ShiverhillsBiome.createBiome());
    public static Biome PALLADIUM_MOUNTAINS = MinecoreModBiomes.register("palladium_mountains", PalladiumMountainsBiome.createBiome());
    public static Biome TWILIGHTS = MinecoreModBiomes.register("twilights", TwilightsBiome.createBiome());

    private static Biome register(String registryname, Biome biome) {
        REGISTRY.add((Biome)biome.setRegistryName(new ResourceLocation("minecore", registryname)));
        return biome;
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])REGISTRY.toArray(new Biome[0]));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ShiverfieldsBiome.init();
            ShiverforestBiome.init();
            ShiverhillsBiome.init();
            PalladiumMountainsBiome.init();
            TwilightsBiome.init();
        });
    }
}

