/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecore.block;

import java.util.Optional;
import java.util.Random;
import net.mcreator.minecore.world.teleporter.TwilightPortalShape;
import net.mcreator.minecore.world.teleporter.TwilightTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;

public class TwilightPortalBlock
extends NetherPortalBlock {
    public TwilightPortalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76298_).m_60910_().m_60977_().m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(s -> 0).m_60993_());
        this.setRegistryName("twilight_portal");
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
    }

    public static void portalSpawn(Level world, BlockPos pos) {
        Optional<TwilightPortalShape> optional = TwilightPortalShape.findEmptyPortalShape((LevelAccessor)world, pos, Direction.Axis.X);
        if (optional.isPresent()) {
            optional.get().createPortalBlocks();
        }
    }

    public BlockState m_7417_(BlockState p_54928_, Direction p_54929_, BlockState p_54930_, LevelAccessor p_54931_, BlockPos p_54932_, BlockPos p_54933_) {
        Direction.Axis direction$axis = p_54929_.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)p_54928_.m_61143_((Property)f_54904_);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && !p_54930_.m_60713_((Block)this) && !new TwilightPortalShape(p_54931_, p_54932_, direction$axis1).isComplete() ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_54928_, p_54929_, p_54930_, p_54931_, p_54932_, p_54933_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        for (int i = 0; i < 4; ++i) {
            double px = (float)pos.m_123341_() + random.nextFloat();
            double py = (float)pos.m_123342_() + random.nextFloat();
            double pz = (float)pos.m_123343_() + random.nextFloat();
            double vx = ((double)random.nextFloat() - 0.5) / 2.0;
            double vy = ((double)random.nextFloat() - 0.5) / 2.0;
            double vz = ((double)random.nextFloat() - 0.5) / 2.0;
            int j = random.nextInt(4) - 1;
            if (world.m_8055_(pos.m_142125_()).m_60734_() != this && world.m_8055_(pos.m_142126_()).m_60734_() != this) {
                px = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                vx = random.nextFloat() * 2.0f * (float)j;
            } else {
                pz = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                vz = random.nextFloat() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123789_, px, py, pz, vx, vy, vz);
        }
        if (random.nextInt(110) == 0) {
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.portal.ambient")), SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_() && !entity.f_19853_.m_5776_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else if (entity.f_19853_.m_46472_() != ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("minecore:twilight"))) {
                entity.m_20091_();
                this.teleportToDimension(entity, pos, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("minecore:twilight")));
            } else {
                entity.m_20091_();
                this.teleportToDimension(entity, pos, (ResourceKey<Level>)Level.f_46428_);
            }
        }
    }

    private void teleportToDimension(Entity entity, BlockPos pos, ResourceKey<Level> destinationType) {
        entity.changeDimension(entity.m_20194_().m_129880_(destinationType), (ITeleporter)new TwilightTeleporter(entity.m_20194_().m_129880_(destinationType), pos));
    }
}

