/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecore.entity;

import java.util.Random;
import java.util.Set;
import net.mcreator.minecore.init.MinecoreModEntities;
import net.mcreator.minecore.init.MinecoreModItems;
import net.mcreator.minecore.procedures.FungalianBowsmanOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MoonBeastEntity
extends Monster {
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("minecore:twilights"));

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        if (SPAWN_BIOMES.contains(event.getName())) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData(MinecoreModEntities.MOON_BEAST, 150, 1, 2));
        }
    }

    public MoonBeastEntity(FMLPlayMessages.SpawnEntity packet, Level world) {
        this(MinecoreModEntities.MOON_BEAST, world);
    }

    public MoonBeastEntity(EntityType<MoonBeastEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 8;
        this.m_21557_(false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)MinecoreModItems.MOON_DUST));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source == DamageSource.f_19323_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6075_() {
        super.m_6075_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        MoonBeastEntity entity = this;
        Level world = this.f_19853_;
        FungalianBowsmanOnEntityTickUpdateProcedure.execute((Entity)entity);
    }

    public static void init() {
        SpawnPlacements.m_21754_(MinecoreModEntities.MOON_BEAST, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random) && Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22278_, 2.0);
        return builder;
    }
}

