/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecore.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.mcreator.minecore.init.MinecoreModBlocks;
import net.mcreator.minecore.world.biome.CharredCragsBiome;
import net.mcreator.minecore.world.biome.FlowerPlainsBiome;
import net.mcreator.minecore.world.biome.FungalInfectionBiome;
import net.mcreator.minecore.world.biome.PalladiumCracksBiome;
import net.mcreator.minecore.world.biome.PalladiumHillsBiome;
import net.mcreator.minecore.world.biome.ShiverCavesBiome;
import net.mcreator.minecore.world.biome.ShiverPlainsBiome;
import net.mcreator.minecore.world.biome.ShiverfieldsBiome;
import net.mcreator.minecore.world.biome.ShiverforestBiome;
import net.mcreator.minecore.world.biome.ShiverhillsBiome;
import net.mcreator.minecore.world.biome.ShroomCavesBiome;
import net.mcreator.minecore.world.biome.StoneCavesBiome;
import net.mcreator.minecore.world.biome.TwilightsBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MinecoreModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"minecore");
    public static final RegistryObject<Biome> SHIVERFIELDS = REGISTRY.register("shiverfields", () -> ShiverfieldsBiome.createBiome());
    public static final RegistryObject<Biome> SHIVERFOREST = REGISTRY.register("shiverforest", () -> ShiverforestBiome.createBiome());
    public static final RegistryObject<Biome> SHIVERHILLS = REGISTRY.register("shiverhills", () -> ShiverhillsBiome.createBiome());
    public static final RegistryObject<Biome> TWILIGHTS = REGISTRY.register("twilights", () -> TwilightsBiome.createBiome());
    public static final RegistryObject<Biome> CHARRED_CRAGS = REGISTRY.register("charred_crags", () -> CharredCragsBiome.createBiome());
    public static final RegistryObject<Biome> FUNGAL_INFECTION = REGISTRY.register("fungal_infection", () -> FungalInfectionBiome.createBiome());
    public static final RegistryObject<Biome> FLOWER_PLAINS = REGISTRY.register("flower_plains", () -> FlowerPlainsBiome.createBiome());
    public static final RegistryObject<Biome> SHIVER_CAVES = REGISTRY.register("shiver_caves", () -> ShiverCavesBiome.createBiome());
    public static final RegistryObject<Biome> PALLADIUM_CRACKS = REGISTRY.register("palladium_cracks", () -> PalladiumCracksBiome.createBiome());
    public static final RegistryObject<Biome> SHIVER_PLAINS = REGISTRY.register("shiver_plains", () -> ShiverPlainsBiome.createBiome());
    public static final RegistryObject<Biome> PALLADIUM_HILLS = REGISTRY.register("palladium_hills", () -> PalladiumHillsBiome.createBiome());
    public static final RegistryObject<Biome> SHROOM_CAVES = REGISTRY.register("shroom_caves", () -> ShroomCavesBiome.createBiome());
    public static final RegistryObject<Biome> STONE_CAVES = REGISTRY.register("stone_caves", () -> StoneCavesBiome.createBiome());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ShiverfieldsBiome.init();
            ShiverforestBiome.init();
            ShiverhillsBiome.init();
            TwilightsBiome.init();
            CharredCragsBiome.init();
            FungalInfectionBiome.init();
            FlowerPlainsBiome.init();
            ShiverCavesBiome.init();
            PalladiumCracksBiome.init();
            ShiverPlainsBiome.init();
            PalladiumHillsBiome.init();
            ShroomCavesBiome.init();
            StoneCavesBiome.init();
        });
    }

    @Mod.EventBusSubscriber
    public static class BiomeInjector {
        @SubscribeEvent
        public static void onServerAboutToStart(ServerAboutToStartEvent event) {
            MinecraftServer server = event.getServer();
            Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
            Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
            WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
            for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
                NoiseGeneratorSettings moddedNoiseGeneratorSettings;
                ArrayList<SurfaceRules.RuleSource> surfaceRules;
                SurfaceRules.SequenceRuleSource sequenceRuleSource;
                SurfaceRules.RuleSource currentRuleSource;
                BiomeSource noiseGeneratorSettings;
                NoiseBasedChunkGenerator noiseGenerator;
                MultiNoiseBiomeSource moddedNoiseSource;
                ArrayList<Pair> parameters;
                MultiNoiseBiomeSource noiseSource;
                ChunkGenerator chunkGenerator;
                DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
                if (dimensionType == dimensionTypeRegistry.m_123013_(DimensionType.f_63845_)) {
                    chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                    BiomeSource biomeSource = chunkGenerator.m_62218_();
                    if (biomeSource instanceof MultiNoiseBiomeSource) {
                        noiseSource = (MultiNoiseBiomeSource)biomeSource;
                        parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                        parameters.add(new Pair((Object)ShiverfieldsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVERFIELDS.getId()))));
                        parameters.add(new Pair((Object)ShiverforestBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVERFOREST.getId()))));
                        parameters.add(new Pair((Object)ShiverhillsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVERHILLS.getId()))));
                        parameters.add(new Pair((Object)FungalInfectionBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)FUNGAL_INFECTION.getId()))));
                        parameters.add(new Pair((Object)FlowerPlainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)FLOWER_PLAINS.getId()))));
                        parameters.add(new Pair((Object)ShiverPlainsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVER_PLAINS.getId()))));
                        parameters.add(new Pair((Object)PalladiumHillsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PALLADIUM_HILLS.getId()))));
                        parameters.add(new Pair((Object)ShiverCavesBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVER_CAVES.getId()))));
                        parameters.add(new Pair((Object)PalladiumCracksBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PALLADIUM_CRACKS.getId()))));
                        parameters.add(new Pair((Object)ShroomCavesBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHROOM_CAVES.getId()))));
                        parameters.add(new Pair((Object)StoneCavesBiome.PARAMETER_POINT_UNDERGROUND, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)STONE_CAVES.getId()))));
                        moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                        chunkGenerator.f_62137_ = moddedNoiseSource;
                        chunkGenerator.f_62138_ = moddedNoiseSource;
                    }
                    if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                        noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                        noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                        currentRuleSource = noiseGeneratorSettings.f_188871_();
                        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
                            sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                            surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
                            surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVER_CAVES.getId()), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PALLADIUM_CRACKS.getId()), ((Block)MinecoreModBlocks.PALLADIUM_STONE.get()).m_49966_(), ((Block)MinecoreModBlocks.PALLADIUM_STONE.get()).m_49966_(), ((Block)MinecoreModBlocks.PALLADIUM_STONE.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHROOM_CAVES.getId()), ((Block)MinecoreModBlocks.MUSHY_DIRT.get()).m_49966_(), ((Block)MinecoreModBlocks.MUSHY_DIRT.get()).m_49966_(), ((Block)MinecoreModBlocks.MUSHY_DIRT.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)STONE_CAVES.getId()), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVERFIELDS.getId()), ((Block)MinecoreModBlocks.SHIVERDIRT.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVERFOREST.getId()), ((Block)MinecoreModBlocks.SHIVERDIRT.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVERHILLS.getId()), ((Block)MinecoreModBlocks.SHIVERDIRT.get()).m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)FUNGAL_INFECTION.getId()), ((Block)MinecoreModBlocks.MUSHY_GRASS.get()).m_49966_(), ((Block)MinecoreModBlocks.MUSHY_DIRT.get()).m_49966_(), ((Block)MinecoreModBlocks.MUSHY_DIRT.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)FLOWER_PLAINS.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SHIVER_PLAINS.getId()), ((Block)MinecoreModBlocks.SHIVERDIRT.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_(), ((Block)MinecoreModBlocks.SHIVERSTONE.get()).m_49966_()));
                            surfaceRules.add(1, BiomeInjector.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PALLADIUM_HILLS.getId()), ((Block)MinecoreModBlocks.PALLADIUM_GRASS.get()).m_49966_(), ((Block)MinecoreModBlocks.PALLADIUM_STONE.get()).m_49966_(), ((Block)MinecoreModBlocks.PALLADIUM_STONE.get()).m_49966_()));
                            moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                            noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
                        }
                    }
                }
                if (dimensionType != dimensionTypeRegistry.m_123013_(DimensionType.f_63846_)) continue;
                chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                noiseGeneratorSettings = chunkGenerator.m_62218_();
                if (noiseGeneratorSettings instanceof MultiNoiseBiomeSource) {
                    noiseSource = (MultiNoiseBiomeSource)noiseGeneratorSettings;
                    parameters = new ArrayList(noiseSource.f_48435_.m_186850_());
                    parameters.add(new Pair((Object)CharredCragsBiome.PARAMETER_POINT, (Object)biomeRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CHARRED_CRAGS.getId()))));
                    moddedNoiseSource = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                    chunkGenerator.f_62137_ = moddedNoiseSource;
                    chunkGenerator.f_62138_ = moddedNoiseSource;
                }
                if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
                noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
                currentRuleSource = noiseGeneratorSettings.f_188871_();
                if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
                sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                surfaceRules = new ArrayList(sequenceRuleSource.f_189697_());
                surfaceRules.add(2, BiomeInjector.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CHARRED_CRAGS.getId()), ((Block)MinecoreModBlocks.CHARRED_NETHERRACK.get()).m_49966_(), Blocks.f_50134_.m_49966_(), Blocks.f_50134_.m_49966_()));
                moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
                noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
            }
        }

        private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))})));
        }

        private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
            return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
        }
    }
}

