/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecore.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.minecore.MinecoreMod;
import net.mcreator.minecore.procedures.MinerPageTradesProcedure;
import net.mcreator.minecore.procedures.SetTradeItemProcedure;
import net.mcreator.minecore.world.inventory.EndMinerGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EndMinerGUISlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public EndMinerGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public EndMinerGUISlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(EndMinerGUISlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(EndMinerGUISlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EndMinerGUISlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slotID, int changeType, int meta, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = EndMinerGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slotID == 0 && changeType == 0) {
            SetTradeItemProcedure.execute((Entity)entity);
        }
        if (slotID == 1 && changeType == 1) {
            MinerPageTradesProcedure.execute((Entity)entity);
        }
        if (slotID == 1 && changeType == 2) {
            int amount = meta;
            MinerPageTradesProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MinecoreMod.addNetworkMessage(EndMinerGUISlotMessage.class, EndMinerGUISlotMessage::buffer, EndMinerGUISlotMessage::new, EndMinerGUISlotMessage::handler);
    }
}

